package com.instabug.survey.announcements.ui.fragment.versionupdate;

import com.instabug.library.core.ui.BasePresenter;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.models.AnnouncementItem;

import androidx.annotation.VisibleForTesting;

/**
 * Created by Barakat on 30/12/2018
 */
public class UpdateMessagePresenter extends BasePresenter<UpdateMessageContract.View>
        implements UpdateMessageContract.Presenter {

    public UpdateMessagePresenter(UpdateMessageContract.View view) {
        super(view);
    }

    @Override
    public void showVersionUpdateAnnouncement(AnnouncementItem announcementItem) {
        if (announcementItem.getOptions() != null) {
            boolean isMandatoryUpdate = announcementItem.getOptions().size() < 2;
            if (isMandatoryUpdate) {
                handelMandatoryUpdateAnnouncement(announcementItem);
            } else {
                handleOptionalUpdateAnnouncement(announcementItem);
            }
        }
    }

    @Override
    public void handleOptionalUpdateAnnouncement(AnnouncementItem announcementItem) {
        String title = announcementItem.getTitle();
        String message = announcementItem.getDescription();
        if (announcementItem.getOptions() != null && announcementItem.getOptions().size() > 1) {
            String positiveOption = announcementItem.getOptions().get(0);
            String negativeOption = announcementItem.getOptions().get(1);
            if (view != null) {
                UpdateMessageContract.View viewRef = view.get();
                if (viewRef != null) {
                    viewRef.showOptionalUpdateAnnouncement(title, message, positiveOption, negativeOption);
                }
            }
        }
    }

    @Override
    public void handelMandatoryUpdateAnnouncement(AnnouncementItem announcementItem) {
        String title = announcementItem.getTitle();
        String message = announcementItem.getDescription();
        if (announcementItem.getOptions() != null && announcementItem.getOptions().size() > 0) {
            String positiveOption = announcementItem.getOptions().get(0);
            if (view != null) {
                UpdateMessageContract.View viewRef = view.get();
                if (viewRef != null) {
                    viewRef.showMandatoryUpdateAnnouncement(title, message, positiveOption);
                }
            }
        }
    }

    public void onPositiveOptionClicked(AnnouncementItem announcementItem,
                                        Announcement announcement) {
        if (isAnnouncementItemHasDownloadLink(announcementItem)) {
            if (view != null) {
                UpdateMessageContract.View view = this.view.get();
                if (view != null && announcementItem.getAnnouncementConfig() != null
                        && announcementItem.getAnnouncementConfig().getDownloadLink() != null
                        && announcementItem.getAnnouncementConfig().getDownloadLink().getAndroidLink() != null) {
                    view.onAnnouncementItemHasConfigLink(announcementItem.getAnnouncementConfig().getDownloadLink().getAndroidLink());
                }
            }
        } else {
            if (view != null) {
                UpdateMessageContract.View view = this.view.get();
                if (view != null) {
                    view.onAnnouncementItemDoesNotHaveConfigLink();
                }
            }
        }
        setAnnouncementIsAnswered(announcement);
    }

    private void setAnnouncementIsAnswered(Announcement announcement) {
        if (announcement.getAnnouncementItems() == null) return;
        for (AnnouncementItem item : announcement.getAnnouncementItems()) {
            if (item.getOptions() != null)
                item.setAnswer(item.getOptions().get(0));
        }
    }

    @VisibleForTesting
    boolean isAnnouncementItemHasDownloadLink(AnnouncementItem announcementItem) {
        return announcementItem.getAnnouncementConfig() != null
                && announcementItem.getAnnouncementConfig().getDownloadLink() != null
                && announcementItem.getAnnouncementConfig().getDownloadLink().getAndroidLink() != null
                && !announcementItem.getAnnouncementConfig().getDownloadLink().getAndroidLink().isEmpty();
    }
}
