package com.instabug.survey.announcements.settings;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.Instabug;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;

/**
 * Created by Barakat on 25/12/2018
 */
public class PersistableSettings {
    private static final String INSTABUG_ANNOUNCEMENT_SHARED_PREF_NAME = "instabug_announcements";
    private static final String IB_ANNOUNCEMENT_LAST_FETCH = "announcements_last_fetch_time";
    private static final String IB_ANNOUNCEMENT_LAST_TIME = "last_announcement_time";
    private static final String IB_APP_LATEST_VERSION = "announcements_app_latest_version";
    private static final String IB_SURVEY_COUNTRY_CODE_RESOLVER_API = "survey_resolve_country_code";
    private static final String IB_SURVEY_COUNTRY_CODE_RESOLVER_LAST_FETCH = "survey_resolve_country_code_last_fetch";
    private static final String IB_ANNOUNCEMENT_LAST_RETRIEVED_LOCALE = "announcement_last_retrieved_locale";

    private static PersistableSettings persistableSettings;
    private SharedPreferences sharedPreferences;
    private SharedPreferences.Editor editor;

    @SuppressLint("CommitPrefEdits")
    private PersistableSettings(Context context) {
        sharedPreferences =
                CoreServiceLocator.getInstabugSharedPreferences(context,
                        INSTABUG_ANNOUNCEMENT_SHARED_PREF_NAME);
        if (sharedPreferences != null) {
            editor = sharedPreferences.edit();
        }
    }

    public static void init(@NonNull Context context) {
        persistableSettings = new PersistableSettings(context);
    }

    @Nullable
    public static PersistableSettings getInstance() {
        if (persistableSettings == null && Instabug.getApplicationContext() != null)
            init(Instabug.getApplicationContext());
        return persistableSettings;
    }

    public void setLastFetchedAt(long time) {
        if (editor == null) return;
        editor.putLong(IB_ANNOUNCEMENT_LAST_FETCH, time);
        editor.apply();
    }

    public long getLastFetchedAt() {
        if (sharedPreferences == null) return 0L;
        return sharedPreferences.getLong(IB_ANNOUNCEMENT_LAST_FETCH, 0L);
    }


    public void setAppLatestVersion(String appLatestVersion) {
        if (editor == null) return;
        editor.putString(IB_APP_LATEST_VERSION, appLatestVersion);
        editor.apply();
    }

    @Nullable
    public String getAppLatestVersion() {
        if (sharedPreferences == null) return null;
        return sharedPreferences.getString(IB_APP_LATEST_VERSION, null);
    }


    public void setLastAnnouncementTime(long time) {
        if (editor == null) return;
        editor.putLong(IB_ANNOUNCEMENT_LAST_TIME, time);
        editor.apply();
    }

    public long getLastAnnouncementTime() {
        if (sharedPreferences == null) return 0L;
        return sharedPreferences.getLong(IB_ANNOUNCEMENT_LAST_TIME, 0L);
    }

    @Nullable
    public String getCountryCode() {
        if (sharedPreferences == null) return null;
        return sharedPreferences.getString(IB_SURVEY_COUNTRY_CODE_RESOLVER_API, null);
    }

    public void setCountryCode(String countryCode) {
        if (editor == null) return;
        editor.putString(IB_SURVEY_COUNTRY_CODE_RESOLVER_API, countryCode);
        editor.apply();
    }

    public long getCountryCodeLastFetch() {
        if (sharedPreferences == null) return 0L;
        return sharedPreferences.getLong(IB_SURVEY_COUNTRY_CODE_RESOLVER_LAST_FETCH, 0L);
    }

    public void setCountryCodeLastFetch(long timestamp) {
        if (editor == null) return;
        editor.putLong(IB_SURVEY_COUNTRY_CODE_RESOLVER_LAST_FETCH, timestamp);
        editor.apply();
    }


    public void setAnnouncementLastRetrievedLocale(String locale) {
        if (editor == null) return;
        editor.putString(IB_ANNOUNCEMENT_LAST_RETRIEVED_LOCALE, locale);
        editor.apply();
    }

    @Nullable
    public String getAnnouncementLastRetrievedLocale() {
        if (sharedPreferences == null) return "";
        return sharedPreferences.getString(IB_ANNOUNCEMENT_LAST_RETRIEVED_LOCALE, "");
    }
}
