/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.utils;

import com.instabug.library.util.TimeUtils;
import com.instabug.survey.common.models.Frequency;
import com.instabug.survey.models.Survey;
import java.util.concurrent.TimeUnit;

public class FrequencyProcessor {
    FrequencyProcessor() {
    }

    boolean isFrequentSurvey(Survey survey) {
        return this.checkFrequencyValidity(survey);
    }

    boolean checkFrequencyValidity(Survey survey) {
        Frequency frequency = survey.getTarget().getFrequency();
        boolean bl = survey.shouldReshowAfterDismiss();
        if (frequency.getType() == 1) {
            return bl || !survey.isPaused() && !survey.isAnswered() && !survey.isCancelled() && !survey.isLastEventDismiss();
        }
        int n = frequency.getShowingInterval();
        int n2 = this.getDifferenceDays(survey.getShownAt() * 1000L, TimeUtils.currentTimeMillis());
        boolean bl2 = frequency.getType() == 0;
        return bl || bl2 && n2 >= n;
    }

    int getDifferenceDays(long l, long l2) {
        return (int)TimeUnit.DAYS.convert(l2 - l, TimeUnit.MILLISECONDS);
    }
}

