/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey.thankspage;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.LocaleUtils;
import com.instabug.survey.R;
import com.instabug.survey.models.Survey;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.ui.SurveyActivity;
import com.instabug.survey.ui.ViewType;
import com.instabug.survey.ui.survey.thankspage.ThanksFragment;
import com.instabug.survey.ui.survey.thankspage.ThanksFragmentContract$View;
import com.instabug.survey.ui.survey.thankspage.ThanksFragmentPresenter;
import java.io.Serializable;
import java.util.Locale;

public abstract class ThanksAbstractFragment
extends InstabugBaseFragment<ThanksFragmentPresenter>
implements ThanksFragmentContract$View {
    @Nullable
    private ImageView brandingImage;
    @Nullable
    private TextView txtTitle;
    @Nullable
    private TextView txtSubTitle;
    @Nullable
    private LinearLayout poweredByFooter;

    public static ThanksAbstractFragment newInstance(@Nullable Survey survey) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putSerializable("key_survey", (Serializable)survey);
        ThanksFragment thanksFragment = new ThanksFragment();
        thanksFragment.setArguments(bundle2);
        return thanksFragment;
    }

    private void setTitle() {
        Object object = (ThanksFragmentPresenter)thanksAbstractFragment.presenter;
        if (object != null && thanksAbstractFragment.getSurvey() != null) {
            if ((object = object.getTitle(thanksAbstractFragment.getSurvey())) != null && (thanksAbstractFragment = thanksAbstractFragment.txtTitle) != null) {
                thanksAbstractFragment.setText((CharSequence)object);
            }
        } else {
            ThanksAbstractFragment thanksAbstractFragment = thanksAbstractFragment.txtTitle;
            if (thanksAbstractFragment != null) {
                thanksAbstractFragment.setText(R.string.instabug_custom_survey_thanks_title);
            }
        }
    }

    private void setMessage() {
        Object object = (ThanksFragmentPresenter)thanksAbstractFragment.presenter;
        if (object != null && thanksAbstractFragment.getSurvey() != null) {
            if ((object = object.getMessage(thanksAbstractFragment.getSurvey())) != null && (thanksAbstractFragment = thanksAbstractFragment.txtSubTitle) != null) {
                thanksAbstractFragment.setText((CharSequence)object);
            }
        } else {
            ThanksAbstractFragment thanksAbstractFragment = thanksAbstractFragment.txtSubTitle;
            if (thanksAbstractFragment != null) {
                thanksAbstractFragment.setText(R.string.instabug_custom_survey_thanks_subtitle);
            }
        }
    }

    private void startIntoAnimation() {
        if (this.getContext() == null) {
            return;
        }
        ThanksAbstractFragment thanksAbstractFragment = this;
        Animation animation = AnimationUtils.loadAnimation((Context)thanksAbstractFragment.getContext(), (int)R.anim.ib_srv_anim_fade_in_scale);
        Animation animation2 = AnimationUtils.loadAnimation((Context)thanksAbstractFragment.getContext(), (int)R.anim.ib_srv_anim_fly_in);
        Animation animation3 = AnimationUtils.loadAnimation((Context)thanksAbstractFragment.getContext(), (int)R.anim.ib_srv_anim_fly_in);
        animation2.setStartOffset(300L);
        animation3.setStartOffset(400L);
        TextView textView = thanksAbstractFragment.txtTitle;
        if (textView == null) {
            return;
        }
        textView.getViewTreeObserver().addOnGlobalLayoutListener(() -> {
            ImageView imageView;
            if (this.txtTitle != null && (imageView = this.brandingImage) != null && this.txtSubTitle != null) {
                ThanksAbstractFragment thanksAbstractFragment = this;
                imageView.startAnimation(animation);
                thanksAbstractFragment.txtTitle.startAnimation(animation2);
                thanksAbstractFragment.txtSubTitle.startAnimation(animation3);
                return;
            }
        });
    }

    private void adjustViewsInPrimaryScreen() {
        if (thanksAbstractFragment2.getActivity() != null && ((SurveyActivity)thanksAbstractFragment2.getActivity()).getViewState() != null && thanksAbstractFragment2.brandingImage != null && ((SurveyActivity)thanksAbstractFragment2.getActivity()).getViewState() == ViewType.PRIMARY) {
            ThanksAbstractFragment thanksAbstractFragment = thanksAbstractFragment2;
            ThanksAbstractFragment thanksAbstractFragment2 = (LinearLayout.LayoutParams)thanksAbstractFragment.brandingImage.getLayoutParams();
            thanksAbstractFragment2.setMargins(0, 0, 0, 16);
            thanksAbstractFragment.brandingImage.setLayoutParams((ViewGroup.LayoutParams)thanksAbstractFragment2);
        }
    }

    @Nullable
    private Survey getSurvey() {
        if (this.getArguments() != null) {
            return (Survey)this.getArguments().getSerializable("key_survey");
        }
        return null;
    }

    protected int getLayout() {
        return R.layout.instabug_survey_fragment_thanks_dialog;
    }

    public void onCreate(@Nullable Bundle object) {
        ThanksFragmentPresenter thanksFragmentPresenter;
        super.onCreate(object);
        object = thanksFragmentPresenter;
        thanksFragmentPresenter = new ThanksFragmentPresenter(this);
        this.presenter = object;
    }

    protected void initViews(View view2, @Nullable Bundle object) {
        TextView textView;
        TextView textView2;
        object = (ImageView)this.findViewById(R.id.instabug_img_thanks);
        this.brandingImage = object;
        this.txtTitle = textView2 = (TextView)this.findViewById(R.id.txt_thanks_title);
        this.txtSubTitle = textView = (TextView)this.findViewById(R.id.txtSubTitle);
        if (textView2 != null && object != null && textView != null) {
            textView = (ImageView)this.findViewById(R.id.survey_partial_close_btn);
            if (textView != null) {
                if (AccessibilityUtils.isTalkbackEnabled()) {
                    textView.setVisibility(0);
                    if (Build.VERSION.SDK_INT >= 22) {
                        TextView textView3 = textView;
                        textView3.setAccessibilityTraversalAfter(textView3.getRootView().getId());
                    }
                    TextView textView4 = textView;
                    ViewCompat.setImportantForAccessibility((View)textView4, (int)1);
                    textView4.setOnClickListener(view -> {
                        if ((this = (SurveyActivity)this.getActivity()) != null) {
                            this.finishSurvey(false);
                        }
                    });
                } else {
                    textView.setVisibility(8);
                }
            }
            this.setTitle();
            this.poweredByFooter = (LinearLayout)this.findViewById(R.id.instabug_pbi_container);
            if (SurveysSettings.isCustomizationEnabled() && this.getSurvey() != null && this.getSurvey().getType() == 2) {
                if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                    textView2.setTextColor(-16777216);
                    if (this.getContext() != null && (textView2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_suvey_vz_custom_thanks_background)) != null) {
                        object.setBackgroundDrawable(Colorizer.getTintedDrawable((int)-16777216, (Drawable)textView2));
                    }
                } else {
                    textView2.setTextColor(-1);
                    if (this.getContext() != null && (textView2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_suvey_vz_custom_thanks_background)) != null) {
                        object.setBackgroundDrawable(Colorizer.getTintedDrawable((int)-1, (Drawable)textView2));
                    }
                }
                object.setColorFilter(Color.parseColor((String)"#f5bf56"));
            } else {
                this.setMessage();
                if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                    textView2.setTextColor(this.getThanksTitleTextColorForLightTheme());
                } else {
                    textView2.setTextColor(ContextCompat.getColor((Context)this.requireContext(), (int)17170443));
                }
                object.setColorFilter(this.getBrandingImageColorFilter());
                if (this.getContext() != null && (textView2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ibg_survey_ic_thanks_background)) != null) {
                    object.setBackgroundDrawable(this.getBrandingImageBackgroundDrawable((Drawable)textView2));
                }
            }
            object = this.presenter;
            if (object != null) {
                ((ThanksFragmentPresenter)((Object)object)).handlePoweredByFooter();
            }
            this.startIntoAnimation();
            this.adjustViewsInPrimaryScreen();
            if (AccessibilityUtils.isTalkbackEnabled() && this.txtTitle != null && this.txtSubTitle != null) {
                StringBuilder stringBuilder;
                object = stringBuilder;
                stringBuilder = new StringBuilder();
                if (this.txtTitle.getText() != null) {
                    ((StringBuilder)object).append(this.txtTitle.getText()).append("\n");
                }
                if (this.txtSubTitle.getText() != null) {
                    ((StringBuilder)object).append(this.txtSubTitle.getText());
                }
                if (((StringBuilder)object).length() > 0) {
                    view2.setContentDescription((CharSequence)object);
                }
            }
            return;
        }
    }

    protected int getBrandingImageColorFilter() {
        return InstabugCore.getPrimaryColor();
    }

    protected Drawable getBrandingImageBackgroundDrawable(Drawable drawable2) {
        return Colorizer.getPrimaryColorTintedDrawable((Drawable)drawable2);
    }

    protected int getThanksTitleTextColorForLightTheme() {
        return InstabugCore.getPrimaryColor();
    }

    @Override
    public void handlePoweredByFooter() {
        LinearLayout linearLayout;
        if (this.getContext() != null && (linearLayout = this.poweredByFooter) != null) {
            InstabugCore.handlePbiFooter((View)linearLayout);
            InstabugCore.handlePbiFooterThemeColor((View)this.poweredByFooter, (int)R.color.pbi_footer_color_dark, (int)R.color.pbi_footer_color_light);
        }
    }

    @Override
    public String getLocalizedString(@StringRes int n) {
        return LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)this.getContext()), (int)n, (Context)this.getContext());
    }
}

