/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey.rateus;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import com.instabug.survey.ui.survey.QuestionAbstractFragment;
import com.instabug.survey.ui.survey.QuestionFragment;
import com.instabug.survey.ui.survey.SurveyFragmentCallbacks;
import com.instabug.survey.ui.survey.rateus.RateUsFragment;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public abstract class RateUsAbstractFragment
extends QuestionFragment {
    @Nullable
    private TextView questionTitleTextView;
    @Nullable
    private ImageView brandingImage;

    public static RateUsFragment newInstance(Survey survey, SurveyFragmentCallbacks surveyFragmentCallbacks) {
        RateUsFragment rateUsFragment = new RateUsFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("question", (Serializable)survey.getQuestions().get(0));
        rateUsFragment.setArguments(bundle);
        rateUsFragment.setSurveyFragmentCallbacks(surveyFragmentCallbacks);
        return rateUsFragment;
    }

    private void startIntoAnimation() {
        if (this.getContext() == null) {
            return;
        }
        RateUsAbstractFragment rateUsAbstractFragment = this;
        Animation animation = AnimationUtils.loadAnimation((Context)rateUsAbstractFragment.getContext(), (int)R.anim.ib_srv_anim_fade_in_scale);
        Animation animation2 = AnimationUtils.loadAnimation((Context)rateUsAbstractFragment.getContext(), (int)R.anim.ib_srv_anim_fly_in);
        Animation animation3 = AnimationUtils.loadAnimation((Context)rateUsAbstractFragment.getContext(), (int)R.anim.ib_srv_anim_fly_in);
        animation2.setStartOffset(300L);
        animation3.setStartOffset(400L);
        TextView textView = rateUsAbstractFragment.questionTitleTextView;
        if (textView != null) {
            textView.getViewTreeObserver().addOnGlobalLayoutListener(() -> {
                ImageView imageView = this.brandingImage;
                if (imageView != null) {
                    imageView.startAnimation(animation);
                }
                if ((animation = this.questionTitleTextView) != null) {
                    animation.startAnimation(animation2);
                }
                if ((this = this.questionTextView) != null) {
                    this.startAnimation(animation3);
                }
            });
        }
    }

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        RateUsAbstractFragment rateUsAbstractFragment = this;
        super.onCreate(bundle);
        rateUsAbstractFragment.setRetainInstance(true);
        if (rateUsAbstractFragment.getArguments() != null) {
            this.question = (Question)this.getArguments().getSerializable("question");
        }
    }

    @Override
    @CallSuper
    protected void initViews(View view, @Nullable Bundle bundle) {
        super.initViews(view, bundle);
        this.questionTitleTextView = (TextView)view.findViewById(R.id.txt_rate_us_title);
        this.questionTextView = (TextView)view.findViewById(R.id.txt_rate_us_question);
        view = (ImageView)view.findViewById(R.id.instabug_img_thanks);
        this.brandingImage = view;
        if (view != null) {
            view.setColorFilter(this.getBrandingImageColorFilter());
            if (this.getContext() != null && (bundle = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ibg_survey_ic_thanks_background)) != null) {
                view.setBackgroundDrawable(this.getBrandingImageBackgroundDrawable((Drawable)bundle));
            }
        }
        if ((view = this.questionTitleTextView) != null) {
            view.setTextColor(this.getQuestionTitleTextColor());
        }
        this.startIntoAnimation();
    }

    protected int getBrandingImageColorFilter() {
        return InstabugCore.getPrimaryColor();
    }

    protected Drawable getBrandingImageBackgroundDrawable(Drawable drawable2) {
        return Colorizer.getPrimaryColorTintedDrawable((Drawable)drawable2);
    }

    protected int getQuestionTitleTextColor() {
        return InstabugCore.getPrimaryColor();
    }

    @Override
    @Nullable
    public String getAnswer() {
        Question question = ((QuestionAbstractFragment)((Object)question)).question;
        if (question == null) {
            return null;
        }
        return question.getAnswer();
    }

    public void showRateUsQuestion() {
        Survey survey = this.survey;
        if (survey != null && this.questionTextView != null && this.question != null) {
            if (survey.getThankYouTitle() != null) {
                survey = this.questionTitleTextView;
                if (survey != null) {
                    survey.setText(this.survey.getThankYouTitle());
                }
            } else {
                survey = this.questionTitleTextView;
                if (survey != null) {
                    survey.setText(R.string.instabug_custom_survey_thanks_title);
                }
            }
            if (this.survey.getThankYouMessage() != null) {
                this.questionTextView.setText((CharSequence)this.survey.getThankYouMessage());
            } else if (this.question.getTitle() != null) {
                this.questionTextView.setText((CharSequence)this.question.getTitle());
            }
            return;
        }
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        if (AccessibilityUtils.isTalkbackEnabled() && (this = this.findViewById(R.id.thanks_container_layout)) != null) {
            this.requestFocus();
        }
    }

    protected int getLayout() {
        return R.layout.survey_rate_us_fragment;
    }
}

