/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey.mcq;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.util.ResourcesUtils;
import com.instabug.survey.R;
import com.instabug.survey.models.Question;

public abstract class SurveyMCQGridAbstractAdapter
extends BaseAdapter {
    private final LayoutInflater inflater;
    private AnswerOnClickListener onClickListener;
    private Question question;
    private int selectedPos = -1;
    protected Context context;

    public SurveyMCQGridAbstractAdapter(Activity activity, Question question, AnswerOnClickListener answerOnClickListener) {
        this.context = activity;
        this.inflater = LayoutInflater.from((Context)activity);
        this.question = question;
        this.setDefaultSelected(question);
        this.onClickListener = answerOnClickListener;
    }

    private void setDefaultSelected(Question question) {
        if (question.getOptionalAnswers() == null) {
            return;
        }
        for (int i = 0; i < question.getOptionalAnswers().size(); ++i) {
            if (question.getAnswer() == null || !question.getAnswer().equals(question.getOptionalAnswers().get(i))) continue;
            this.selectedPos = i;
            break;
        }
    }

    private void setAccessibilityDelegate(final int n, @NonNull LinearLayout object, final boolean bl) {
        AccessibilityDelegateCompat accessibilityDelegateCompat;
        LinearLayout linearLayout = object;
        object = accessibilityDelegateCompat;
        accessibilityDelegateCompat = new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                view = view.getResources();
                1 v1 = this;
                int n3 = v1.n + 1;
                String string2 = ResourcesUtils.getSelectedText((Resources)view, (boolean)v1.bl);
                int n2 = n;
                String string3 = SurveyMCQGridAbstractAdapter.this.getItemDescription((Resources)view, n3, string2, n2);
                accessibilityNodeInfoCompat2.setImportantForAccessibility(true);
                accessibilityNodeInfoCompat2.setText((CharSequence)string3);
                accessibilityNodeInfoCompat2.addAction(new AccessibilityNodeInfoCompat.AccessibilityActionCompat(16, (CharSequence)view.getString(R.string.ib_action_select)));
            }
        };
        ViewCompat.setAccessibilityDelegate((View)linearLayout, (AccessibilityDelegateCompat)object);
    }

    private String getItemDescription(Resources object, int n, String string2, int n2) {
        Resources resources = object;
        int n3 = R.string.ib_msq_item_description;
        object = n;
        Integer n4 = this.getCount();
        String string3 = this.getItem(n2);
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = n4;
        objectArray[2] = string3;
        objectArray[3] = string2;
        return resources.getString(n3, objectArray2);
    }

    private void handleSelectedHolderColors(MCQViewHolder mCQViewHolder) {
        LinearLayout linearLayout;
        if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
            linearLayout = mCQViewHolder.item;
            if (linearLayout != null) {
                DrawableUtils.setColor((View)linearLayout, (int)ColorUtils.setAlphaComponent((int)this.getSelectedItemBgColor(mCQViewHolder), (int)25));
            }
        } else {
            linearLayout = mCQViewHolder.item;
            if (linearLayout != null) {
                DrawableUtils.setColor((View)linearLayout, (int)ColorUtils.setAlphaComponent((int)this.getSelectedItemBgColor(mCQViewHolder), (int)50));
            }
        }
        if ((linearLayout = mCQViewHolder.optionalAnswer) != null) {
            linearLayout.setTextColor(this.getSelectedTextColor(mCQViewHolder));
        }
        this.handleSelectedIconImage(mCQViewHolder);
    }

    private void handleUnselectedHolderColors(MCQViewHolder mCQViewHolder) {
        TextView textView;
        LinearLayout linearLayout = mCQViewHolder.item;
        if (linearLayout != null) {
            DrawableUtils.setColor((View)linearLayout, (int)this.getUnselectedItemBgColor(mCQViewHolder));
        }
        if ((linearLayout = this.context) != null && (textView = mCQViewHolder.optionalAnswer) != null) {
            textView.setTextColor(AttrResolver.resolveAttributeColor((Context)linearLayout, (int)R.attr.instabug_survey_mcq_text_color));
        }
        this.handleUnselectedIconImage(mCQViewHolder);
    }

    private View.OnClickListener registerOnClickListener(String string2, int n) {
        return view -> {
            SurveyMCQGridAbstractAdapter surveyMCQGridAbstractAdapter = this;
            surveyMCQGridAbstractAdapter.setSelected(n);
            AccessibilityUtils.sendTextEvent((String)(string2 + " " + view.getResources().getString(R.string.ib_selected)));
            surveyMCQGridAbstractAdapter.onClickListener.onAnswerClicked(view, string2);
        };
    }

    private void setSelected(int n) {
        this.selectedPos = n;
        this.notifyDataSetChanged();
    }

    public int getCount() {
        Question question = this.question;
        return question != null && question.getOptionalAnswers() != null ? this.question.getOptionalAnswers().size() : 0;
    }

    public String getItem(int n) {
        if (this.question.getOptionalAnswers() == null) {
            return "null";
        }
        return this.question.getOptionalAnswers().get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    @SuppressLint(value={"InflateParams"})
    public View getView(int n, View object, ViewGroup object2) {
        boolean bl;
        TextView textView;
        if (object == null) {
            MCQViewHolder mCQViewHolder;
            object = mCQViewHolder;
            mCQViewHolder = new MCQViewHolder();
            object2 = this.inflater.inflate(R.layout.instabug_survey_mcq_item, null);
            object.item = (LinearLayout)object2.findViewById(R.id.mcq_item);
            object.optionalAnswer = (TextView)object2.findViewById(R.id.survey_optional_answer_textview);
            object.mcqSelectorIcon = (ImageView)object2.findViewById(R.id.selector_img);
            object2.setTag(object);
        } else {
            Object object3 = object2 = (MCQViewHolder)object.getTag();
            object2 = object;
            object = object3;
        }
        if (this.question.getOptionalAnswers() != null && (textView = object.optionalAnswer) != null) {
            textView.setText((CharSequence)this.question.getOptionalAnswers().get(n));
        }
        if (bl = n == this.selectedPos) {
            this.handleSelectedHolderColors((MCQViewHolder)object);
        } else {
            this.handleUnselectedHolderColors((MCQViewHolder)object);
        }
        if (this.onClickListener != null && this.question.getOptionalAnswers() != null) {
            TextView textView2;
            LinearLayout linearLayout = object.item;
            if (linearLayout != null) {
                SurveyMCQGridAbstractAdapter surveyMCQGridAbstractAdapter = this;
                linearLayout.setOnClickListener(surveyMCQGridAbstractAdapter.registerOnClickListener(surveyMCQGridAbstractAdapter.question.getOptionalAnswers().get(n), n));
                this.setAccessibilityDelegate(n, object.item, bl);
            }
            if ((textView2 = object.optionalAnswer) != null) {
                SurveyMCQGridAbstractAdapter surveyMCQGridAbstractAdapter = this;
                textView2.setOnClickListener(surveyMCQGridAbstractAdapter.registerOnClickListener(surveyMCQGridAbstractAdapter.question.getOptionalAnswers().get(n), n));
                ViewCompat.setImportantForAccessibility((View)object.optionalAnswer, (int)2);
            }
            if ((textView2 = object.mcqSelectorIcon) != null) {
                SurveyMCQGridAbstractAdapter surveyMCQGridAbstractAdapter = this;
                textView2.setOnClickListener(surveyMCQGridAbstractAdapter.registerOnClickListener(surveyMCQGridAbstractAdapter.question.getOptionalAnswers().get(n), n));
                ViewCompat.setImportantForAccessibility((View)object.mcqSelectorIcon, (int)2);
            }
        }
        return object2;
    }

    protected abstract int getSelectedItemBgColor(MCQViewHolder var1);

    protected abstract int getSelectedTextColor(MCQViewHolder var1);

    protected abstract void handleSelectedIconImage(MCQViewHolder var1);

    protected abstract int getUnselectedItemBgColor(MCQViewHolder var1);

    protected abstract void handleUnselectedIconImage(MCQViewHolder var1);

    @Nullable
    public String getCurrentAnswer() {
        int n = this.selectedPos;
        if (n == -1) {
            return null;
        }
        return this.getItem(n);
    }

    public void setAnswer(@Nullable String string2) {
        if (string2 != null && !string2.isEmpty()) {
            for (int i = 0; i < this.getCount(); ++i) {
                if (!string2.equalsIgnoreCase(this.getItem(i))) continue;
                this.selectedPos = i;
                break;
            }
        }
    }

    public static interface AnswerOnClickListener {
        public void onAnswerClicked(View var1, String var2);
    }

    protected static class MCQViewHolder {
        @Nullable
        LinearLayout item;
        @Nullable
        TextView optionalAnswer;
        @Nullable
        ImageView mcqSelectorIcon;

        protected MCQViewHolder() {
        }
    }
}

