/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.popup;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatImageView;
import com.instabug.library.Feature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.survey.R;
import java.lang.ref.WeakReference;

public abstract class CustomQuestionDialog {
    @Nullable
    private static void show(@NonNull Activity activity, @LayoutRes int n, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable CustomDialogListener customDialogListener) {
        if (activity.isFinishing()) {
            return;
        }
        AlertDialog alertDialog = new AlertDialog.Builder((Context)activity, 0x1030010).create();
        View view = activity.getLayoutInflater().inflate(n, null);
        AlertDialog alertDialog2 = alertDialog;
        alertDialog2.setView(view);
        alertDialog2.setCancelable(false);
        TextView textView = (TextView)view.findViewById(R.id.instabug_text_view_question);
        Button button = (Button)view.findViewById(R.id.ib_survey_btn_yes);
        View view2 = view;
        Button button2 = (Button)view2.findViewById(R.id.ib_survey_btn_no);
        AppCompatImageView appCompatImageView = (AppCompatImageView)view2.findViewById(R.id.ib_survey_custom_dialog_illustration);
        ImageView imageView = (ImageView)view2.findViewById(R.id.survey_partial_close_btn);
        if (button != null && button2 != null && appCompatImageView != null) {
            CustomQuestionDialog.applyTheme(button, button2, appCompatImageView);
        }
        CustomQuestionDialog.setTexts(textView, string2, button, string3, button2, string4);
        CustomQuestionDialog.handleOptionalCloseButtonAction(activity, view);
        CustomQuestionDialog.setListeners(button, button2, imageView, alertDialog, customDialogListener);
        InstabugCore.handlePbiFooter((View)view);
        if (InstabugCore.getFeatureState((String)"WHITE_LABELING") == Feature.State.ENABLED) {
            InstabugCore.handlePbiFooterThemeColor((View)view, (int)R.color.pbi_footer_color_dark, (int)R.color.pbi_footer_color_light);
        }
        alertDialog.show();
    }

    private static void setListeners(@Nullable Button object, @Nullable Button button, @Nullable ImageView imageView, final AlertDialog alertDialog, final @Nullable CustomDialogListener customDialogListener) {
        View.OnClickListener onClickListener;
        View.OnClickListener onClickListener2;
        View.OnClickListener onClickListener3;
        Button button2 = object;
        object = onClickListener3;
        onClickListener3 = new View.OnClickListener(){

            public void onClick(View view) {
                1 v0 = customDialogListener2;
                v0.alertDialog.dismiss();
                CustomDialogListener customDialogListener2 = v0.customDialogListener;
                if (customDialogListener2 != null) {
                    customDialogListener2.onPositiveActionCalled();
                }
            }
        };
        CustomQuestionDialog.setClickListener((View)button2, (View.OnClickListener)object);
        object = onClickListener2;
        onClickListener2 = new View.OnClickListener(){

            public void onClick(View view) {
                2 v0 = customDialogListener2;
                v0.alertDialog.dismiss();
                CustomDialogListener customDialogListener2 = v0.customDialogListener;
                if (customDialogListener2 != null) {
                    customDialogListener2.onNegativeActionCalled();
                }
            }
        };
        CustomQuestionDialog.setClickListener((View)button, (View.OnClickListener)object);
        object = onClickListener;
        onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                CustomDialogListener customDialogListener2 = customDialogListener2.customDialogListener;
                if (customDialogListener2 != null) {
                    customDialogListener2.onDismissActionCalled();
                }
            }
        };
        CustomQuestionDialog.setClickListener((View)imageView, (View.OnClickListener)object);
    }

    private static void setClickListener(@Nullable View view, View.OnClickListener onClickListener) {
        if (view != null) {
            view.setOnClickListener(onClickListener);
        }
    }

    private static void setTexts(@Nullable TextView textView, @Nullable String string2, @Nullable Button button, @Nullable String string3, @Nullable Button button2, @Nullable String string4) {
        if (textView != null && string2 != null) {
            textView.setText((CharSequence)string2);
        }
        if (button != null && string3 != null) {
            button.setText((CharSequence)string3);
        }
        if (button2 != null && string4 != null) {
            button2.setText((CharSequence)string4);
        }
    }

    private static void applyTheme(Button button, Button button2, AppCompatImageView appCompatImageView) {
        if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
            button.setTextColor(-1);
            button2.setTextColor(-16777216);
            button.setBackgroundColor(-16777216);
            button2.setBackgroundResource(R.drawable.ib_survey_bg_apprating_negative);
            if (appCompatImageView != null) {
                appCompatImageView.setImageResource(R.drawable.ib_ic_survey_apprating_light);
            }
        } else {
            button.setTextColor(-16777216);
            button2.setTextColor(-1);
            button.setBackgroundColor(-1);
            button2.setBackgroundResource(R.drawable.ib_survey_bg_apprating_negative_dark);
            if (appCompatImageView != null) {
                appCompatImageView.setImageResource(R.drawable.ib_ic_survey_apprating_dark);
            }
        }
    }

    private static void handleOptionalCloseButtonAction(final Activity activity, View object) {
        if ((object = (ImageView)object.findViewById(R.id.survey_partial_close_btn)) != null) {
            View.OnClickListener onClickListener;
            if (Build.VERSION.SDK_INT >= 22 && AccessibilityUtils.isTalkbackEnabled()) {
                View view = object;
                view.setAccessibilityTraversalAfter(view.getRootView().getId());
            }
            View view = object;
            object = onClickListener;
            onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    activity.finish();
                }
            };
            view.setOnClickListener((View.OnClickListener)object);
        }
    }

    static interface CustomDialogListener {
        public void onPositiveActionCalled();

        public void onNegativeActionCalled();

        public void onDismissActionCalled();
    }

    public static class Builder {
        private final WeakReference<Activity> activity;
        @Nullable
        private String message;
        @LayoutRes
        private int layoutRes;
        @Nullable
        private String negativeCTA;
        @Nullable
        private String positiveCTA;
        @Nullable
        private CustomDialogListener dialogListener;

        public Builder(Activity activity) {
            WeakReference<Activity> weakReference;
            WeakReference<Activity> weakReference2 = weakReference;
            weakReference = new WeakReference<Activity>(activity);
            v1.activity = weakReference2;
        }

        public Builder setMessage(@Nullable String string2) {
            this.message = string2;
            return this;
        }

        public Builder setPositiveCTA(String string2) {
            this.positiveCTA = string2;
            return this;
        }

        public Builder setNegativeCTA(String string2) {
            this.negativeCTA = string2;
            return this;
        }

        public Builder setLayoutRes(@LayoutRes int n) {
            this.layoutRes = n;
            return this;
        }

        public Builder setDialogListener(CustomDialogListener customDialogListener) {
            this.dialogListener = customDialogListener;
            return this;
        }

        public void build() {
            Object object = (Activity)this.activity.get();
            if (object != null) {
                Activity activity = object;
                Builder builder = this;
                int n = builder.layoutRes;
                object = builder.message;
                String string2 = builder.positiveCTA;
                String string3 = builder.negativeCTA;
                CustomDialogListener customDialogListener = builder.dialogListener;
                CustomQuestionDialog.show(activity, n, (String)object, string2, string3, customDialogListener);
            }
        }
    }
}

