/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.custom;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.survey.R;
import com.instabug.survey.ui.custom.CustomExploreByTouchHelper;
import com.instabug.survey.ui.custom.RatingVirtualViewsProvider;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public abstract class RatingAbstractView
extends View {
    @ColorInt
    private int borderColor;
    @ColorInt
    private int fillColor;
    @ColorInt
    private int backgroundColor;
    @ColorInt
    private int starBackgroundColor;
    @ColorInt
    private int pressedBorderColor;
    @ColorInt
    private int pressedFillColor;
    @ColorInt
    private int pressedBackgroundColor;
    @ColorInt
    private int pressedStarBackgroundColor;
    private float stepSize;
    private float rating;
    @NonNull
    private Gravity gravity;
    private float starBorderWidth;
    private float starCornerRadius;
    private boolean drawBorderEnabled;
    private float currentStarSize;
    @Nullable
    private OnRatingBarChangeListener ratingListener;
    @Nullable
    private View.OnClickListener clickListener;
    private boolean touchInProgress;
    @Nullable
    private float[] starVertex;
    @Nullable
    private RectF starsDrawingSpace;
    @Nullable
    private RectF starsTouchSpace;
    @Nullable
    private Canvas internalCanvas;
    @Nullable
    private Bitmap internalBitmap;
    private Path starPath;
    private Paint paintStarOutline;
    private CornerPathEffect cornerPathEffect;
    private Paint paintStarBorder;
    private Paint paintStarBackground;
    private Paint paintStarFill;
    private float defaultStarSize;
    private int numberOfStars;
    private float desiredStarSize;
    private float maxStarSize;
    private float starsSeparation;
    private final Rect[] starsRect;

    public RatingAbstractView(Context context) {
        RatingAbstractView ratingAbstractView = this;
        super(context);
        ratingAbstractView.numberOfStars = 5;
        ratingAbstractView.desiredStarSize = 2.1474836E9f;
        ratingAbstractView.maxStarSize = 2.1474836E9f;
        ratingAbstractView.starsSeparation = (int)ratingAbstractView.valueToPixels(4.0f, 0);
        ratingAbstractView.starsRect = new Rect[5];
        ratingAbstractView.initView();
    }

    public RatingAbstractView(Context context, AttributeSet attributeSet) {
        RatingAbstractView ratingAbstractView = this;
        super(context, attributeSet);
        ratingAbstractView.numberOfStars = 5;
        ratingAbstractView.desiredStarSize = 2.1474836E9f;
        ratingAbstractView.maxStarSize = 2.1474836E9f;
        ratingAbstractView.starsSeparation = (int)ratingAbstractView.valueToPixels(4.0f, 0);
        ratingAbstractView.starsRect = new Rect[5];
        ratingAbstractView.init();
        ratingAbstractView.initView();
    }

    public RatingAbstractView(Context context, AttributeSet attributeSet, int n) {
        RatingAbstractView ratingAbstractView = this;
        super(context, attributeSet, n);
        ratingAbstractView.numberOfStars = 5;
        ratingAbstractView.desiredStarSize = 2.1474836E9f;
        ratingAbstractView.maxStarSize = 2.1474836E9f;
        ratingAbstractView.starsSeparation = (int)ratingAbstractView.valueToPixels(4.0f, 0);
        ratingAbstractView.starsRect = new Rect[5];
        ratingAbstractView.init();
        ratingAbstractView.initView();
    }

    private void initView() {
        CustomExploreByTouchHelper customExploreByTouchHelper;
        Paint paint;
        Paint paint2;
        Paint paint3;
        Paint paint4;
        Paint paint5;
        CornerPathEffect cornerPathEffect;
        Path path;
        Object object = path;
        path = new Path();
        this.starPath = object;
        object = cornerPathEffect;
        cornerPathEffect = new CornerPathEffect(this.starCornerRadius);
        this.cornerPathEffect = object;
        object = paint5;
        paint5 = new Paint(5);
        this.paintStarOutline = object;
        object = Paint.Style.FILL_AND_STROKE;
        paint5.setStyle((Paint.Style)object);
        this.paintStarOutline.setAntiAlias(true);
        this.paintStarOutline.setDither(true);
        Paint.Join join = Paint.Join.ROUND;
        this.paintStarOutline.setStrokeJoin(join);
        Paint.Cap cap = Paint.Cap.ROUND;
        this.paintStarOutline.setStrokeCap(cap);
        this.paintStarOutline.setColor(-16777216);
        this.paintStarOutline.setPathEffect((PathEffect)this.cornerPathEffect);
        this.paintStarBorder = paint4 = paint3;
        new Paint(5).setStyle(Paint.Style.STROKE);
        this.paintStarBorder.setStrokeJoin(join);
        this.paintStarBorder.setStrokeCap(cap);
        this.paintStarBorder.setStrokeWidth(this.starBorderWidth);
        this.paintStarBorder.setPathEffect((PathEffect)this.cornerPathEffect);
        paint4 = paint2;
        paint4(5);
        this.paintStarBackground = paint4;
        paint2.setStyle((Paint.Style)object);
        this.paintStarBackground.setAntiAlias(true);
        this.paintStarBackground.setDither(true);
        this.paintStarBackground.setStrokeJoin(join);
        this.paintStarBackground.setStrokeCap(cap);
        paint4 = paint;
        paint4(5);
        this.paintStarFill = paint4;
        paint.setStyle((Paint.Style)object);
        this.paintStarFill.setAntiAlias(true);
        this.paintStarFill.setDither(true);
        this.paintStarFill.setStrokeJoin(join);
        this.paintStarFill.setStrokeCap(cap);
        object = this.getResources().getDisplayMetrics();
        this.defaultStarSize = TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)object);
        object = customExploreByTouchHelper;
        customExploreByTouchHelper = new CustomExploreByTouchHelper(new RatingVirtualViewsProvider(this));
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)object);
        this.setOnHoverListener((view, motionEvent) -> customExploreByTouchHelper.dispatchHoverEvent(motionEvent));
    }

    private void init() {
        this.borderColor = this.getResources().getColor(R.color.survey_rate_star_border);
        this.fillColor = this.getResources().getColor(R.color.survey_rate_selected);
        int n = InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight ? this.getResources().getColor(R.color.survey_rate_unselected_light) : this.getResources().getColor(R.color.survey_rate_unselected_dark);
        this.starBackgroundColor = n;
        this.backgroundColor = 0;
        this.pressedBorderColor = this.borderColor;
        this.pressedFillColor = this.fillColor;
        this.pressedStarBackgroundColor = n;
        this.pressedBackgroundColor = 0;
        this.numberOfStars = 5;
        this.starsSeparation = (int)this.valueToPixels(16.0f, 0);
        float f = InstabugDeviceProperties.isTablet((Context)this.getContext()) ? 80.0f : 52.0f;
        this.maxStarSize = (int)this.valueToPixels(f, 0);
        this.desiredStarSize = 2.1474836E9f;
        this.stepSize = 1.0f;
        this.starBorderWidth = this.getStarBorderWidth();
        this.starCornerRadius = this.getStarCornerRadius();
        this.rating = 0.0f;
        this.drawBorderEnabled = this.shouldDrawBorders();
        this.gravity = Gravity.fromId(Gravity.Left.id);
    }

    private float calculateBestStarSize(int n, int n2) {
        float f = this.maxStarSize;
        if (f != 2.1474836E9f) {
            int n3 = this.numberOfStars;
            float f2 = this.starsSeparation;
            int n4 = this.numberOfStars;
            float f3 = this.starsSeparation;
            float f4 = this.calculateTotalHeight(this.maxStarSize, n4, f3, true);
            if (!((float)this.calculateTotalWidth(f, n3, f2, true) >= (float)n) && !(f4 >= (float)n2)) {
                return this.maxStarSize;
            }
            float f5 = n - this.getPaddingLeft() - this.getPaddingRight();
            n = this.numberOfStars;
            return Math.min((f5 - this.starsSeparation * (float)(n - 1)) / (float)n, (float)(n2 - this.getPaddingTop() - this.getPaddingBottom()));
        }
        float f6 = n - this.getPaddingLeft() - this.getPaddingRight();
        n = this.numberOfStars;
        return Math.min((f6 - this.starsSeparation * (float)(n - 1)) / (float)n, (float)(n2 - this.getPaddingTop() - this.getPaddingBottom()));
    }

    private void performStarSizeAssociatedCalculations(int n, int n2) {
        RectF rectF;
        RectF rectF2;
        int n3 = n;
        n = this.numberOfStars;
        float f = this.starsSeparation;
        float f2 = this.calculateTotalWidth(this.currentStarSize, n, f, false);
        int n4 = this.numberOfStars;
        float f3 = this.starsSeparation;
        float f4 = this.calculateTotalHeight(this.currentStarSize, n4, f3, false);
        f3 = (float)(n3 - this.getPaddingLeft() - this.getPaddingRight()) / 2.0f - f2 / 2.0f + (float)this.getPaddingLeft();
        float f5 = (float)(n2 - this.getPaddingTop() - this.getPaddingBottom()) / 2.0f - f4 / 2.0f + (float)this.getPaddingTop();
        RectF rectF3 = rectF2;
        f2 = f3 + f2;
        f4 = f5 + f4;
        this.starsDrawingSpace = rectF3;
        f2 = new RectF(f3, f5, f2, f4).width() * 0.05f;
        RectF rectF4 = rectF;
        RectF rectF5 = this.starsDrawingSpace;
        f3 = rectF5.left - f2;
        f5 = rectF5.top;
        f2 = rectF5.right + f2;
        float f6 = rectF5.bottom;
        rectF = new RectF(f3, f5, f2, f6);
        this.starsTouchSpace = rectF4;
        f2 = this.currentStarSize;
        float f7 = f2 * 0.2f;
        f3 = f2 * 0.35f;
        f5 = f2 * 0.5f;
        f6 = f2 * 0.05f;
        float f8 = f2 * 0.03f;
        float f9 = f2 * 0.38f;
        float f10 = f2 * 0.32f;
        float f11 = f10;
        float f12 = f2;
        f2 = f12 * 0.6f;
        float f13 = f12 * 0.27f;
        float f14 = this.getPointsLowerDeviation();
        float f15 = this.getPointsUpperDeviation();
        float f16 = this.getLowerInnerPointsYUpperDeviation();
        float f17 = (f8 + f3) * f14;
        float f18 = f9 * f14;
        float f19 = f14;
        float f20 = this.currentStarSize;
        float f21 = f14 = f20;
        float f22 = f13;
        float f23 = f14;
        float f24 = f2;
        f2 = (f14 - f8 - f3) * f15;
        f3 = f14 - f8;
        f11 = (f14 - f11) * f15;
        f13 = f24 * f16;
        f14 -= f7;
        f16 = f23 - f6;
        f15 = (f21 - f22) * f15;
        float f25 = f20 - f6;
        float f26 = f10 * f19;
        float[] fArray = new float[20];
        float[] fArray2 = fArray;
        fArray[0] = f8;
        fArray2[1] = f9;
        fArray2[2] = f17;
        fArray2[3] = f18;
        fArray2[4] = f5;
        fArray2[5] = f6;
        fArray2[6] = f2;
        fArray2[7] = f18;
        fArray2[8] = f3;
        fArray2[9] = f9;
        fArray2[10] = f11;
        fArray2[11] = f13;
        fArray2[12] = f14;
        fArray2[13] = f16;
        fArray2[14] = f5;
        fArray2[15] = f15;
        fArray2[16] = f7;
        fArray2[17] = f25;
        fArray2[18] = f26;
        fArray2[19] = f13;
        this.starVertex = fArray2;
    }

    private int calculateTotalWidth(float f, int n, float f2, boolean bl) {
        int n2 = Math.round(f * (float)n + f2 * (float)(n - 1));
        int n3 = bl ? this.getPaddingLeft() + this.getPaddingRight() : 0;
        return n2 + n3;
    }

    private int calculateTotalHeight(float f, int n, float f2, boolean bl) {
        int n2 = Math.round(f);
        int n3 = bl ? this.getPaddingTop() + this.getPaddingBottom() : 0;
        return n2 + n3;
    }

    private void generateInternalCanvas(int n, int n2) {
        Bitmap bitmap = this.internalBitmap;
        if (bitmap != null) {
            bitmap.recycle();
        }
        if (n > 0 && n2 > 0) {
            Bitmap bitmap2;
            this.internalBitmap = bitmap2 = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (bitmap2 != null) {
                bitmap2.eraseColor(0);
                this.internalCanvas = new Canvas(this.internalBitmap);
            }
        }
    }

    private void setupColorsInPaint() {
        if (this.touchInProgress) {
            this.paintStarBorder.setColor(this.pressedBorderColor);
            this.paintStarFill.setColor(this.pressedFillColor);
            if (this.pressedFillColor != 0) {
                this.paintStarFill.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
            } else {
                this.paintStarFill.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            }
            this.paintStarBackground.setColor(this.pressedStarBackgroundColor);
            if (this.pressedStarBackgroundColor != 0) {
                this.paintStarBackground.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
            } else {
                this.paintStarBackground.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            }
        } else {
            this.paintStarBorder.setColor(this.borderColor);
            this.paintStarFill.setColor(this.fillColor);
            if (this.fillColor != 0) {
                this.paintStarFill.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
            } else {
                this.paintStarFill.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            }
            this.paintStarBackground.setColor(this.starBackgroundColor);
            if (this.starBackgroundColor != 0) {
                this.paintStarBackground.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
            } else {
                this.paintStarBackground.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            }
        }
    }

    private void drawFromLeftToRight(Canvas canvas) {
        RatingAbstractView ratingAbstractView = this;
        float f = ratingAbstractView.rating;
        RectF rectF = ratingAbstractView.starsDrawingSpace;
        if (rectF != null) {
            RectF rectF2 = rectF;
            float f2 = rectF2.left;
            float f3 = rectF2.top;
            for (int i = 0; i < this.numberOfStars; ++i) {
                if (f >= 1.0f) {
                    Gravity gravity = Gravity.Left;
                    this.drawStar(canvas, f2, f3, 1.0f, gravity);
                    f -= 1.0f;
                } else {
                    RatingAbstractView ratingAbstractView2 = this;
                    Gravity gravity = Gravity.Left;
                    ratingAbstractView2.drawStar(canvas, f2, f3, f, gravity);
                    if (ratingAbstractView2.drawBorderEnabled) {
                        RatingAbstractView ratingAbstractView3 = this;
                        Path path = ratingAbstractView3.starPath;
                        canvas.drawPath(path, ratingAbstractView3.paintStarBorder);
                    }
                    f = 0.0f;
                }
                f2 += this.starsSeparation + this.currentStarSize;
            }
        }
    }

    private void drawFromRightToLeft(Canvas canvas) {
        RatingAbstractView ratingAbstractView = this;
        float f = ratingAbstractView.rating;
        RectF rectF = ratingAbstractView.starsDrawingSpace;
        if (rectF != null) {
            RectF rectF2 = rectF;
            float f2 = rectF2.right - this.currentStarSize;
            float f3 = rectF2.top;
            for (int i = 0; i < this.numberOfStars; ++i) {
                if (f >= 1.0f) {
                    Gravity gravity = Gravity.Right;
                    this.drawStar(canvas, f2, f3, 1.0f, gravity);
                    f -= 1.0f;
                } else {
                    RatingAbstractView ratingAbstractView2 = this;
                    Gravity gravity = Gravity.Right;
                    ratingAbstractView2.drawStar(canvas, f2, f3, f, gravity);
                    if (ratingAbstractView2.drawBorderEnabled) {
                        RatingAbstractView ratingAbstractView3 = this;
                        Path path = ratingAbstractView3.starPath;
                        canvas.drawPath(path, ratingAbstractView3.paintStarBorder);
                    }
                    f = 0.0f;
                }
                f2 -= this.starsSeparation + this.currentStarSize;
            }
        }
    }

    private void drawStar(Canvas canvas, float f, float f2, float f3, Gravity gravity) {
        RatingAbstractView ratingAbstractView = this;
        f3 = ratingAbstractView.currentStarSize * f3;
        if (ratingAbstractView.starVertex == null) {
            return;
        }
        RatingAbstractView ratingAbstractView2 = this;
        ratingAbstractView2.starPath.reset();
        float f4 = f + this.starVertex[0];
        ratingAbstractView2.starPath.moveTo(f4, f2 + this.starVertex[1]);
        int n = 2;
        while (true) {
            float[] fArray = this.starVertex;
            if (n >= this.starVertex.length) break;
            float f5 = f + fArray[n];
            this.starPath.lineTo(f5, f2 + fArray[n + 1]);
            n += 2;
        }
        Gravity gravity2 = gravity;
        RatingAbstractView ratingAbstractView3 = this;
        ratingAbstractView3.starPath.close();
        gravity = ratingAbstractView3.starPath;
        canvas.drawPath((Path)gravity, ratingAbstractView3.paintStarOutline);
        if (gravity2 == Gravity.Left) {
            float f6 = f;
            float f7 = f;
            float f8 = f + f3;
            float f9 = this.currentStarSize;
            f = f8 + f9 * 0.02f;
            f9 = f2 + f9;
            Paint paint = this.paintStarFill;
            canvas.drawRect(f7, f2, f, f9, paint);
            f9 = this.currentStarSize;
            f = f6 + f9;
            f9 = f2 + f9;
            paint = this.paintStarBackground;
            canvas.drawRect(f8, f2, f, f9, paint);
        } else {
            float f10 = f;
            float f11 = f;
            float f12 = f;
            float f13 = this.currentStarSize;
            float f14 = f12 + f13 - (f3 + f13 * 0.02f);
            f = f12 + f13;
            f13 = f2 + f13;
            gravity = this.paintStarFill;
            canvas.drawRect(f14, f2, f, f13, (Paint)gravity);
            f13 = this.currentStarSize;
            f14 = f11 + f13 - f3;
            f13 = f2 + f13;
            Paint paint = this.paintStarBackground;
            canvas.drawRect(f10, f2, f14, f13, paint);
        }
    }

    private void setNewRatingFromTouch(float f, float f2) {
        float f3;
        float f4;
        RectF rectF;
        if (this.gravity != Gravity.Left) {
            f = (float)this.getWidth() - f;
        }
        if ((rectF = this.starsDrawingSpace) == null) {
            return;
        }
        float f5 = rectF.left;
        if (f < f4) {
            this.rating = 0.0f;
            return;
        }
        if (f > rectF.right) {
            this.rating = this.numberOfStars;
            return;
        }
        f -= f5;
        this.rating = f = (float)this.numberOfStars / rectF.width() * f;
        float f6 = this.stepSize;
        f5 = f % f6;
        if (f3 < f6 / 4.0f) {
            float f7;
            RatingAbstractView ratingAbstractView = this;
            ratingAbstractView.rating = f7 = f - f5;
            ratingAbstractView.rating = Math.max(0.0f, f7);
        } else {
            float f8;
            this.rating = f8 = f - f5 + f6;
            this.rating = Math.min((float)this.numberOfStars, f8);
        }
    }

    private float normalizeRating(float f) {
        Object object;
        if (f < 0.0f) {
            object = Float.valueOf(f);
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            Log.w((String)"RatingView", (String)String.format("Assigned rating is less than 0 (%f < 0), I will set it to exactly 0", objectArray2));
            return 0.0f;
        }
        if (f > (float)object.numberOfStars) {
            Object object2 = object;
            object = Float.valueOf(f);
            Integer n = object2.numberOfStars;
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray[0] = object;
            objectArray[1] = n;
            Log.w((String)"RatingView", (String)String.format("Assigned rating is greater than numberOfStars (%f > %d), I will set it to exactly numberOfStars", objectArray3));
            return object2.numberOfStars;
        }
        return f;
    }

    protected abstract float getStarBorderWidth();

    protected abstract float getStarCornerRadius();

    protected abstract boolean shouldDrawBorders();

    protected void onMeasure(int n, int n2) {
        float f;
        int n3 = View.MeasureSpec.getMode((int)n);
        int n4 = n2;
        n = View.MeasureSpec.getSize((int)n);
        n2 = View.MeasureSpec.getMode((int)n4);
        int n5 = View.MeasureSpec.getSize((int)n4);
        if (n3 != 0x40000000) {
            if (n3 == Integer.MIN_VALUE) {
                float f2 = this.desiredStarSize;
                if (f2 != 2.1474836E9f) {
                    int n6 = this.numberOfStars;
                    f = this.starsSeparation;
                    n = Math.min(this.calculateTotalWidth(f2, n6, f, true), n);
                } else {
                    f2 = this.maxStarSize;
                    if (f2 != 2.1474836E9f) {
                        int n7 = this.numberOfStars;
                        f = this.starsSeparation;
                        n = Math.min(this.calculateTotalWidth(f2, n7, f, true), n);
                    } else {
                        int n8 = this.numberOfStars;
                        float f3 = this.starsSeparation;
                        n = Math.min(this.calculateTotalWidth(this.defaultStarSize, n8, f3, true), n);
                    }
                }
            } else {
                float f4 = this.desiredStarSize;
                if (f4 != 2.1474836E9f) {
                    n3 = this.numberOfStars;
                    float f5 = this.starsSeparation;
                    n = this.calculateTotalWidth(f4, n3, f5, true);
                } else {
                    f4 = this.maxStarSize;
                    if (f4 != 2.1474836E9f) {
                        n3 = this.numberOfStars;
                        float f6 = this.starsSeparation;
                        n = this.calculateTotalWidth(f4, n3, f6, true);
                    } else {
                        n = this.numberOfStars;
                        float f7 = this.starsSeparation;
                        n = this.calculateTotalWidth(this.defaultStarSize, n, f7, true);
                    }
                }
            }
        }
        float f8 = this.starsSeparation;
        int n9 = this.numberOfStars;
        f = ((float)(n - this.getPaddingLeft() - this.getPaddingRight()) - f8 * (float)(n9 - 1)) / (float)n9;
        if (n2 != 0x40000000) {
            float f9;
            float f10;
            n5 = n2 == Integer.MIN_VALUE ? ((f10 = this.desiredStarSize) != 2.1474836E9f ? Math.min(this.calculateTotalHeight(f10, n9, f8, true), n5) : ((f10 = this.maxStarSize) != 2.1474836E9f ? Math.min(this.calculateTotalHeight(f10, n9, f8, true), n5) : Math.min(this.calculateTotalHeight(f, n9, f8, true), n5))) : ((f9 = this.desiredStarSize) != 2.1474836E9f ? this.calculateTotalHeight(f9, n9, f8, true) : ((f9 = this.maxStarSize) != 2.1474836E9f ? this.calculateTotalHeight(f9, n9, f8, true) : this.calculateTotalHeight(f, n9, f8, true)));
        }
        this.setMeasuredDimension(n, n5);
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        void var5_7;
        void var4_6;
        void f;
        int n5;
        RatingAbstractView ratingAbstractView = this;
        super.onLayout(bl, n5, (int)f, (int)var4_6, (int)var5_7);
        int n6 = ratingAbstractView.getWidth();
        n5 = ratingAbstractView.getHeight();
        float f2 = ratingAbstractView.desiredStarSize;
        this.currentStarSize = f2 == 2.1474836E9f ? this.calculateBestStarSize(n6, n5) : f2;
        this.performStarSizeAssociatedCalculations(n6, n5);
    }

    protected abstract float getLowerInnerPointsYUpperDeviation();

    protected abstract float getPointsLowerDeviation();

    protected abstract float getPointsUpperDeviation();

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        RatingAbstractView ratingAbstractView = this;
        super.onSizeChanged(n, n2, n3, n4);
        ratingAbstractView.generateInternalCanvas(n, n2);
    }

    protected void onDraw(Canvas canvas) {
        RatingAbstractView ratingAbstractView = ratingAbstractView5;
        super.onDraw(canvas);
        int n = ratingAbstractView.getHeight();
        if (ratingAbstractView.getWidth() != 0 && n != 0) {
            Canvas canvas2 = ratingAbstractView5.internalCanvas;
            if (canvas2 == null) {
                return;
            }
            RatingAbstractView ratingAbstractView2 = ratingAbstractView5;
            canvas2.drawColor(0, PorterDuff.Mode.CLEAR);
            ratingAbstractView2.setupColorsInPaint();
            if (ratingAbstractView2.gravity == Gravity.Left) {
                RatingAbstractView ratingAbstractView3 = ratingAbstractView5;
                ratingAbstractView3.drawFromLeftToRight(ratingAbstractView3.internalCanvas);
            } else {
                RatingAbstractView ratingAbstractView4 = ratingAbstractView5;
                ratingAbstractView4.drawFromRightToLeft(ratingAbstractView4.internalCanvas);
            }
            if (ratingAbstractView5.touchInProgress) {
                canvas.drawColor(ratingAbstractView5.pressedBackgroundColor);
            } else {
                canvas.drawColor(ratingAbstractView5.backgroundColor);
            }
            RatingAbstractView ratingAbstractView5 = ratingAbstractView5.internalBitmap;
            if (ratingAbstractView5 != null) {
                canvas.drawBitmap((Bitmap)ratingAbstractView5, 0.0f, 0.0f, null);
            }
            return;
        }
    }

    public boolean onTouchEvent(MotionEvent object) {
        block9: {
            switch (object.getAction() & 0xFF) {
                default: {
                    break;
                }
                case 3: {
                    object = this.ratingListener;
                    if (object != null) {
                        object.onRatingChanged(this, this.rating, true);
                    }
                    this.touchInProgress = false;
                    break;
                }
                case 1: {
                    RatingAbstractView ratingAbstractView = this;
                    MotionEvent motionEvent = object;
                    float f = motionEvent.getX();
                    ratingAbstractView.setNewRatingFromTouch(f, motionEvent.getY());
                    Object object2 = ratingAbstractView.clickListener;
                    if (object2 != null) {
                        object2.onClick((View)this);
                    }
                    if ((object2 = this.ratingListener) != null) {
                        object2.onRatingChanged(this, this.rating, true);
                    }
                    this.touchInProgress = false;
                    break;
                }
                case 0: 
                case 2: {
                    RectF rectF = this.starsTouchSpace;
                    if (rectF == null) break block9;
                    Object object3 = object;
                    float f = object3.getX();
                    if (!rectF.contains(f, object3.getY())) break block9;
                    Object object4 = object;
                    this.touchInProgress = true;
                    float f2 = object4.getX();
                    this.setNewRatingFromTouch(f2, object4.getY());
                }
            }
            this.invalidate();
            return true;
        }
        if (this.touchInProgress && (object = this.ratingListener) != null) {
            object.onRatingChanged(this, this.rating, true);
        }
        this.touchInProgress = false;
        return false;
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (parcelable != null) {
            SavedState.access$002(new SavedState(parcelable), this.getRating());
        }
        return null;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable != null) {
            RatingAbstractView ratingAbstractView = object;
            Object object = (SavedState)parcelable;
            super.onRestoreInstanceState(object.getSuperState());
            ratingAbstractView.setRating(((SavedState)((Object)object)).rating, false);
        }
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float f, boolean bl) {
        OnRatingBarChangeListener onRatingBarChangeListener;
        RatingAbstractView ratingAbstractView = this;
        ratingAbstractView.rating = ratingAbstractView.normalizeRating(f);
        ratingAbstractView.invalidate();
        if (bl && (onRatingBarChangeListener = this.ratingListener) != null) {
            onRatingBarChangeListener.onRatingChanged(this, f, false);
        }
    }

    @ColorInt
    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(@ColorInt int n) {
        this.fillColor = n;
        this.invalidate();
    }

    public Gravity getGravity() {
        return this.gravity;
    }

    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
        this.invalidate();
    }

    protected float valueToPixels(float f, @Dimension int n) {
        RatingAbstractView ratingAbstractView;
        if (n != 0) {
            if (n != 2) {
                return f;
            }
            ratingAbstractView = ratingAbstractView.getResources().getDisplayMetrics();
            return TypedValue.applyDimension((int)2, (float)f, (DisplayMetrics)ratingAbstractView);
        }
        ratingAbstractView = ratingAbstractView.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)ratingAbstractView);
    }

    public void setOnClickListener(@Nullable View.OnClickListener onClickListener) {
        this.clickListener = onClickListener;
    }

    public void setOnRatingBarChangeListener(OnRatingBarChangeListener onRatingBarChangeListener) {
        this.ratingListener = onRatingBarChangeListener;
    }

    public int childPositionAt(float f, float f2) {
        Rect rect;
        for (int i = 0; i < ((Rect[])(rect = this.starsRect)).length; ++i) {
            int n;
            if ((rect = rect[i]) == null || !rect.contains(n = (int)f, (int)f2)) continue;
            return i + 1;
        }
        return Integer.MIN_VALUE;
    }

    @Nullable
    public Rect childBoundsAtPosition(int n) {
        Rect rect;
        int n2 = n > 0 ? n - 1 : n;
        RectF rectF = this.starsDrawingSpace;
        if (rectF == null) {
            return null;
        }
        RectF rectF2 = rectF;
        float f = rectF2.left + (float)n2 * (this.starsSeparation + this.currentStarSize);
        float f2 = rectF2.top;
        Rect rect2 = rect;
        rect2();
        rect2.top = (int)f2;
        rect2.left = (int)f;
        float f3 = this.currentStarSize;
        rect2.bottom = (int)(f2 + f3);
        rect2.right = (int)(f + f3);
        int n3 = n - 1;
        this.starsRect[n3] = rect2;
        return rect;
    }

    public static enum Gravity {
        Left(0),
        Right(1);

        int id;

        private Gravity(int n2) {
            this.id = n2;
        }

        static Gravity fromId(int n) {
            for (Gravity gravity : Gravity.values()) {
                if (gravity.id != n) continue;
                return gravity;
            }
            Log.w((String)"RatingView", (String)String.format("Gravity chosen is neither 'left' nor 'right', I will set it to Left", new Object[0]));
            return Left;
        }
    }

    public static interface OnRatingBarChangeListener {
        public void onRatingChanged(RatingAbstractView var1, float var2, boolean var3);
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        private float rating = 0.0f;

        protected SavedState(Parcel parcel) {
            super(parcel);
            this.rating = parcel.readFloat();
        }

        protected SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        static /* synthetic */ float access$002(SavedState savedState, float f) {
            savedState.rating = f;
            return f;
        }

        public void writeToParcel(Parcel parcel, int n) {
            SavedState savedState = this;
            super.writeToParcel(parcel, n);
            parcel.writeFloat(savedState.rating);
        }
    }
}

