/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.custom;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.R;
import com.instabug.survey.ui.custom.NpsAbstractView;

public class NpsView
extends NpsAbstractView {
    @Nullable
    private Typeface customTypeface;

    public NpsView(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        try {
            this.customTypeface = ResourcesCompat.getFont((Context)context, (int)R.font.instabug_custom_font);
        }
        catch (Resources.NotFoundException notFoundException) {
            InstabugSDKLogger.d((String)"IBG-Surveys", (String)"NPS: font typeface not overridden");
        }
    }

    public NpsView(Context context, @Nullable AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        try {
            this.customTypeface = ResourcesCompat.getFont((Context)context, (int)R.font.instabug_custom_font);
        }
        catch (Resources.NotFoundException notFoundException) {
            InstabugSDKLogger.d((String)"IBG-Surveys", (String)"NPS: font typeface not overridden");
        }
    }

    public NpsView(Context context, @Nullable AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        try {
            this.customTypeface = ResourcesCompat.getFont((Context)context, (int)R.font.instabug_custom_font);
        }
        catch (Resources.NotFoundException notFoundException) {
            InstabugSDKLogger.d((String)"IBG-Surveys", (String)"NPS: font typeface not overridden");
        }
    }

    @Override
    protected boolean shouldHaveBorder() {
        return true;
    }

    @Override
    protected boolean shouldDrawSelectionShape() {
        return true;
    }

    @Override
    protected void calculateNpsRects() {
        int n;
        NpsView npsView = this;
        npsView.npsRects.clear();
        int n2 = this.selectedViewEdgeSize;
        npsView.rectLine = (npsView.getWidth() - n2 * 2) / this.count;
        int n3 = 0;
        int n4 = npsView.height;
        int n5 = n = 0;
        n = n2;
        for (int i = v33553; i < this.count; ++i) {
            Rect rect;
            NpsView npsView2 = this;
            Rect rect2 = rect;
            rect = new Rect(n, n3, n2 += this.rectLine, n4);
            npsView2.npsRects.add(rect2);
            n += npsView2.rectLine;
        }
    }

    @Override
    protected void drawRectOfTheCircles(Canvas canvas) {
        this.borderPath.rewind();
        this.borderPath.moveTo((float)this.selectedViewEdgeSize, (float)((int)Math.floor((double)this.heightWithPaddingBottom / 1.7)));
        this.borderPath.lineTo((float)this.selectedViewEdgeSize, (float)this.heightWithPaddingBottom);
        this.borderPath.lineTo((float)(this.getWidth() - this.selectedViewEdgeSize), (float)this.heightWithPaddingBottom);
        this.borderPath.lineTo((float)(this.getWidth() - this.selectedViewEdgeSize), (float)((int)Math.floor((double)this.heightWithPaddingBottom / 1.7)));
        this.borderPath.close();
        this.paintBorder.setStyle(Paint.Style.FILL);
        this.paintBorder.setColor(this.getCirclesRectColor());
        this.paintBorder.setPathEffect((PathEffect)this.rectCornerPathEffect);
        canvas.drawPath(this.borderPath, this.paintBorder);
    }

    @Override
    protected void drawNumbers(Canvas canvas) {
        Typeface typeface;
        int n = (this.getWidth() - this.selectedViewEdgeSize * 2) / this.count;
        int n2 = (int)((float)Math.round((double)this.heightWithPaddingBottom / 1.3) + NpsAbstractView.dpToPixel(this.getContext(), 8.0f));
        this.paintText.setColor(this.getNumbersColor());
        this.paintText.setTextSize(this.numbersTextSize);
        this.paintText.setStyle(Paint.Style.FILL);
        this.paintText.setFakeBoldText(true);
        if (InstabugCore.isFeatureEnabled((String)"CUSTOM_FONT") && (typeface = this.customTypeface) != null) {
            this.paintText.setTypeface(typeface);
        } else {
            this.paintText.setTypeface(Typeface.defaultFromStyle((int)0));
        }
        float f = this.paintText.measureText("9", 0, 1);
        int n3 = (int)((float)(n / 2 + this.selectedViewEdgeSize) - (f /= 2.0f));
        if (this.isRtl) {
            for (int i = this.count - 1; i >= 0; --i) {
                if (i == 10) {
                    n3 = (int)((float)((int)((float)n3 + f)) - this.paintText.measureText("10", 0, 2) / 2.0f);
                }
                String string2 = String.valueOf(i);
                float f2 = n3;
                float f3 = n2;
                Paint paint = this.paintText;
                canvas.drawText(string2, f2, f3, paint);
                n3 += n;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (i == 10) {
                    n3 = (int)((float)((int)((float)n3 + f)) - this.paintText.measureText("10", 0, 2) / 2.0f);
                }
                String string3 = String.valueOf(i);
                float f4 = n3;
                float f5 = n2;
                Paint paint = this.paintText;
                canvas.drawText(string3, f4, f5, paint);
                n3 += n;
            }
        }
    }

    @Override
    protected void drawScoreIndicator(Canvas canvas) {
        if (npsView.selected != -1) {
            npsView.scoreIndicatorPath.reset();
            npsView.paintSelectionShape.setColor(npsView.getIndicatorViewBackgroundColor());
            int n = npsView.npsRects.get((int)npsView.selected).left;
            int n2 = npsView.npsRects.get((int)npsView.selected).right;
            int n3 = npsView.rectLine;
            int n4 = npsView.selectedRect;
            if (n3 > n4) {
                int n5 = n2;
                int n6 = n;
                n = (n3 - n4) / 2;
                n2 = n6 + n;
                n = n5 - n;
                int n7 = n2;
                n2 = n;
                n = n7;
            }
            float f = n;
            npsView.scoreIndicatorPath.moveTo(f, (float)npsView.heightWithPaddingBottom / 1.7f);
            npsView.scoreIndicatorPath.lineTo(f, (float)npsView.heightWithPaddingBottom);
            f = n2;
            npsView.scoreIndicatorPath.lineTo(f, (float)npsView.heightWithPaddingBottom);
            npsView.scoreIndicatorPath.lineTo(f, (float)npsView.heightWithPaddingBottom / 1.7f);
            npsView.scoreIndicatorPath.close();
            canvas.drawPath(npsView.scoreIndicatorPath, npsView.paintSelectionShape);
            f = (float)npsView.heightWithPaddingBottom / 1.3f;
            float f2 = NpsAbstractView.dpToPixel(npsView.getContext(), 4.0f);
            if ((float)(npsView.npsRects.get((int)npsView.selected).right - npsView.npsRects.get((int)npsView.selected).left) > (float)npsView.heightWithPaddingBottom / 1.7f) {
                f2 /= 1.5f;
            }
            npsView.paintSelectionShapeCircle.setColor(npsView.getIndicatorViewCircleColor());
            float f3 = n + (n2 - n) / 2;
            float f4 = f + NpsAbstractView.dpToPixel(npsView.getContext(), 4.0f);
            NpsView npsView = npsView.paintSelectionShapeCircle;
            canvas.drawCircle(f3, f4, f2, (Paint)npsView);
        }
    }
}

