/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui;

import android.app.Activity;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.TimeUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.cache.SurveysCacheManager;
import com.instabug.survey.common.LayoutUtils;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import com.instabug.survey.network.service.InstabugSurveysSubmitterJob;
import com.instabug.survey.network.util.SubmittingSurveysUtil;
import com.instabug.survey.settings.PersistableSettings;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.ui.SurveyActivityContract$View;
import com.instabug.survey.ui.ViewType;
import com.instabug.survey.ui.survey.SurveyAbstractFragment;
import java.lang.ref.Reference;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class SurveyPresenter
extends BasePresenter<SurveyActivityContract$View> {
    @Nullable
    private ViewType state;

    public SurveyPresenter(SurveyActivityContract$View surveyActivityContract$View) {
        super((BaseContract.View)surveyActivityContract$View);
    }

    private boolean showThanksForAppRatingSurvey(Survey survey) {
        return !survey.isGooglePlayAppRating() && !TextUtils.isEmpty((CharSequence)survey.getQuestions().get(2).getAnswer());
    }

    private void handleOnFinishCallback(Survey survey, String string2) {
        Object object = SurveysSettings.getOnFinishCallback();
        if (object != null) {
            SurveyPresenter surveyPresenter = object;
            Survey survey2 = survey;
            String string3 = string2;
            object = Long.toString(survey.getId());
            survey = SubmittingSurveysUtil.getSurveyAsResponse(survey2, string3);
            try {
                surveyPresenter.onFinish((String)object, string2, (JSONObject)survey);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Something went wrong during parsing Survey object in onFinishCallback", (Throwable)jSONException);
            }
        }
    }

    public void setLayoutHeightSecondary(ViewType viewType, boolean bl) {
        FragmentActivity fragmentActivity;
        ((SurveyPresenter)((Object)object)).state = viewType;
        Object object = ((BasePresenter)object).view;
        if (object != null && (object = (SurveyActivityContract$View)((Reference)object).get()) != null && object.getViewContext() != null && (fragmentActivity = (FragmentActivity)object.getViewContext()) != null) {
            int n = LayoutUtils.getLayoutHeight((Activity)fragmentActivity, viewType);
            if (bl) {
                object.setFrameLayoutHeightWithAnimation(n);
            } else {
                object.setFrameLayoutHeightTo(n);
            }
        }
    }

    @Nullable
    public ViewType getState() {
        return this.state;
    }

    public void handleOnBackPressedLogic() {
        if (((BasePresenter)this).view.get() != null && (this = (SurveyActivityContract$View)((BasePresenter)this).view.get()) != null && this.getViewContext() != null && (this = (FragmentActivity)this.getViewContext()) != null && this.getSupportFragmentManager().getFragments().size() > 0) {
            for (Fragment fragment : this.getSupportFragmentManager().getFragments()) {
                if (!(fragment instanceof SurveyAbstractFragment)) continue;
                ((SurveyAbstractFragment)fragment).onBackPressed();
                break;
            }
        }
    }

    public void submitSurvey(final Survey survey) {
        SurveyActivityContract$View surveyActivityContract$View;
        if (survey == null) {
            return;
        }
        Survey survey2 = survey;
        survey2.setSubmitted();
        survey2.setSessionID(InstabugCore.getLatestSessionReplayId());
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                SurveysCacheManager.update(survey);
            }
        });
        if (PersistableSettings.getInstance() != null) {
            PersistableSettings.getInstance().setLastSurveyTime(TimeUtils.currentTimeMillis());
        }
        SurveyPresenter surveyPresenter = this;
        surveyPresenter.handleOnFinishCallback(survey, "SUBMITTED");
        if (surveyPresenter.view.get() != null && (surveyActivityContract$View = (SurveyActivityContract$View)this.view.get()) != null && surveyActivityContract$View.getViewContext() != null) {
            InstabugSurveysSubmitterJob.getInstance().start();
            if (survey.isNPSSurvey()) {
                boolean bl = survey.isAppStoreRatingEnabled() && SurveysSettings.isAppLive();
                surveyActivityContract$View.finishNPSSurvey(bl);
                return;
            }
            if (survey.isStoreRatingSurvey()) {
                surveyActivityContract$View.finishSurvey(this.showThanksForAppRatingSurvey(survey));
                return;
            }
            surveyActivityContract$View.finishSurvey(true);
        }
    }

    public void dismissSurvey(Survey survey) {
        if (survey != null) {
            Survey survey2 = survey;
            survey2.setDismissed();
            if (survey2.isCancelled() && survey.getSessionCounter() >= SurveysSettings.getSurveysReshowSessionCount()) {
                if (survey.isOptInSurvey()) {
                    Survey survey3 = survey;
                    survey3.setShouldShowAgain(true);
                    survey3.resetSessionsCounter();
                } else if (survey.getSessionCounter() != 0) {
                    survey.setShouldShowAgain(false);
                }
            }
            Survey survey4 = survey;
            ((SurveyPresenter)((Object)this)).handleOnFinishCallback(survey, ((SurveyPresenter)((Object)this)).getSurveyState(survey));
            survey4.setSessionID(InstabugCore.getLatestSessionReplayId());
            SurveysCacheManager.update(survey4);
            if (PersistableSettings.getInstance() != null) {
                PersistableSettings.getInstance().setLastSurveyTime(TimeUtils.currentTimeMillis());
            }
            if (((BasePresenter)this).view.get() != null && (this = (SurveyActivityContract$View)((BasePresenter)this).view.get()) != null && this.getViewContext() != null) {
                InstabugSurveysSubmitterJob.getInstance().start();
                this.finishSurvey(false);
            }
        }
    }

    @VisibleForTesting
    public String getSurveyState(Survey survey) {
        if (survey.getType() != 0 && survey.getType() != 1) {
            ArrayList<Question> arrayList = survey.getQuestions();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = ((Question)arrayList.get(i)).getAnswer();
                if (string2 != null && !string2.equals("")) {
                    continue;
                }
                if (i == 0) {
                    return "DISMISSED";
                }
                return "ENDED";
            }
            return "SUBMITTED";
        }
        return "DISMISSED";
    }

    public boolean shouldShowWelcomeScreen() {
        return SurveysSettings.shouldShowSurveysWelcomeScreen();
    }
}

