/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BaseFragmentActivity;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StatusBarUtils;
import com.instabug.survey.R;
import com.instabug.survey.SurveyPlugin;
import com.instabug.survey.SurveysManager;
import com.instabug.survey.common.AutoShowingManager;
import com.instabug.survey.models.Survey;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.ui.SurveyActivityCallback;
import com.instabug.survey.ui.SurveyActivityContract$View;
import com.instabug.survey.ui.SurveyNavigator;
import com.instabug.survey.ui.SurveyPresenter;
import com.instabug.survey.ui.ViewType;
import com.instabug.survey.ui.gestures.GestureListener;
import com.instabug.survey.ui.survey.QuestionAbstractFragment;
import com.instabug.survey.ui.survey.SurveyAbstractFragment;
import com.instabug.survey.ui.survey.rateus.RateUsFragment;
import com.instabug.survey.ui.survey.thankspage.ThanksAbstractFragment;
import com.instabug.survey.ui.survey.welcomepage.WelcomeAbstractFragment;
import com.instabug.survey.utils.SurveysUtils;
import com.instabug.survey.utils.ThemeResolver;
import com.instabug.survey.utils.ViewUtilsKt;

public abstract class SurveyAbstractActivity
extends BaseFragmentActivity<SurveyPresenter>
implements SurveyActivityContract$View,
_InstabugActivity,
SurveyActivityCallback {
    protected int currentQuestionPosition = -1;
    boolean isResumed = false;
    @Nullable
    private Handler handler;
    protected FrameLayout fragmentContainer;
    protected RelativeLayout activityContainer;
    @Nullable
    protected Survey survey;
    @Nullable
    private GestureDetector gestureDetector;
    @Nullable
    private Handler finishDelayHandler;
    @Nullable
    private Runnable finishDelayRunnable;

    private void showWelcomeMsgFragment(Survey survey) {
        this.navigateToFragment((Fragment)WelcomeAbstractFragment.newInstance(survey));
    }

    private void handledAutoDismissingIfResumed() {
        Fragment fragment = this.getSupportFragmentManager().findFragmentById(R.id.instabug_fragment_container);
        if (fragment instanceof SurveyAbstractFragment) {
            for (Fragment fragment2 : fragment.getChildFragmentManager().getFragments()) {
                if (!(fragment2 instanceof RateUsFragment) || !fragment2.isVisible()) continue;
                if (this.survey == null) {
                    this.hideFragmentImmediately(fragment);
                    break;
                }
                if (SurveysSettings.isAppLive() && this.survey.isAppStoreRatingEnabled()) break;
                this.hideFragmentAfterDelay(fragment);
                break;
            }
        }
        if (this.getSupportFragmentManager() != null && this.getSupportFragmentManager().findFragmentByTag("THANKS_FRAGMENT") != null) {
            SurveyAbstractActivity surveyAbstractActivity = this;
            surveyAbstractActivity.hideFragmentImmediately(surveyAbstractActivity.getSupportFragmentManager().findFragmentByTag("THANKS_FRAGMENT"));
        }
    }

    private void hideFragmentImmediately(Fragment fragment) {
        if (fragment != null) {
            this.getSupportFragmentManager().beginTransaction().setCustomAnimations(0, R.anim.instabug_anim_flyout_to_bottom).remove(fragment).commitAllowingStateLoss();
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    SurveyAbstractActivity.this.finish();
                    SurveysUtils.executeRunnableAfterShowingSurvey();
                }
            }, 400L);
        }
    }

    private void hideFragmentAfterDelay(final Fragment fragment) {
        Runnable runnable;
        Handler handler;
        Object object = handler;
        object();
        this.handler = object;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SurveyAbstractActivity.this.hideFragmentImmediately(fragment);
                }
                catch (Exception exception) {
                    4 v0 = this;
                    v0.SurveyAbstractActivity.this.getSupportFragmentManager().popBackStack();
                    v0.SurveyAbstractActivity.this.finish();
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Fragment couldn't save it's state due to: " + exception.getMessage()));
                }
            }
        };
        handler.postDelayed((Runnable)object, 3000L);
    }

    protected void onSaveInstanceState(Bundle bundle) {
        block4: {
            SurveyAbstractActivity surveyAbstractActivity = this;
            super.onSaveInstanceState(bundle);
            BaseContract.Presenter presenter = surveyAbstractActivity.presenter;
            if (presenter == null) break block4;
            if (((SurveyPresenter)presenter).getState() == null) break block4;
            try {
                bundle.putInt("viewType", ((SurveyPresenter)this.presenter).getState().getValue());
            }
            catch (IllegalStateException illegalStateException) {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Something went wrong while saving survey state", (Throwable)illegalStateException);
            }
        }
    }

    public void onCreate(final @Nullable Bundle bundle) {
        RelativeLayout relativeLayout;
        SurveyAbstractActivity surveyAbstractActivity = this;
        super.onCreate(bundle);
        surveyAbstractActivity.setTheme(ThemeResolver.resolveTheme(InstabugCore.getTheme()));
        StatusBarUtils.setStatusBarForDialog((Activity)surveyAbstractActivity);
        surveyAbstractActivity.fragmentContainer = (FrameLayout)surveyAbstractActivity.findViewById(R.id.instabug_fragment_container);
        surveyAbstractActivity.activityContainer = relativeLayout = (RelativeLayout)surveyAbstractActivity.findViewById(R.id.survey_activity_container);
        if (Build.VERSION.SDK_INT > 34) {
            ViewUtilsKt.addSystemWindowInsetToPadding((View)relativeLayout, true, true, true, true);
        }
        this.presenter = new SurveyPresenter(this);
        if (this.getIntent() != null) {
            this.survey = (Survey)this.getIntent().getSerializableExtra("survey");
        }
        if (this.survey != null) {
            SurveyAbstractActivity surveyAbstractActivity2 = this;
            surveyAbstractActivity2.handleFrameLayoutHeight(bundle);
            surveyAbstractActivity2.fragmentContainer.postDelayed(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Exception exception2;
                    block9: {
                        Object object;
                        block8: {
                            if (InstabugCore.getStartedActivitiesCount() <= 1) {
                                InstabugSDKLogger.d((String)"IBG-Surveys", (String)"Survey Error: StartedActivitiesCount <= 1");
                                SurveyAbstractActivity.this.finish();
                                return;
                            }
                            try {
                                if (SurveyAbstractActivity.this.isFinishing()) return;
                                object = SurveyAbstractActivity.this;
                                if (!((SurveyAbstractActivity)object).isResumed) break block8;
                                if (bundle != null) return;
                                if (((SurveyAbstractActivity)object).presenter != null && ((SurveyPresenter)SurveyAbstractActivity.this.presenter).shouldShowWelcomeScreen() && (object = SurveyAbstractActivity.this.survey) != null && ((Survey)object).getType() != 2) {
                                    SurveyAbstractActivity surveyAbstractActivity = SurveyAbstractActivity.this;
                                    surveyAbstractActivity.showWelcomeMsgFragment(surveyAbstractActivity.survey);
                                    return;
                                }
                                object = SurveyAbstractActivity.this;
                            }
                            catch (Exception exception2) {}
                            Survey survey = ((SurveyAbstractActivity)object).survey;
                            if (survey == null) return;
                            SurveyNavigator.navigateToSurvey(object.getSupportFragmentManager(), survey);
                            return;
                            break block9;
                        }
                        object.finish();
                        return;
                    }
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Survey has not been shown due to this error: " + exception2.getMessage()));
                    SurveyAbstractActivity.this.finish();
                }
            }, 500L);
            return;
        }
        InstabugSDKLogger.w((String)"IBG-Surveys", (String)"survey activity will be finished the survey is null");
        this.finish();
    }

    protected abstract void handleFrameLayoutHeight(@Nullable Bundle var1);

    protected void navigateToFragment(Fragment fragment) {
        int n = R.anim.instabug_anim_flyout_to_bottom;
        this.navigateToFragment(fragment, R.anim.instabug_anim_flyin_from_bottom, n);
    }

    protected void navigateToFragment(Fragment fragment, int n, int n2) {
        this.getSupportFragmentManager().beginTransaction().setCustomAnimations(n, n2).replace(R.id.instabug_fragment_container, fragment).commitAllowingStateLoss();
    }

    protected void onResume() {
        SurveyAbstractActivity surveyAbstractActivity = this;
        super.onResume();
        InstabugCore.setPluginState(SurveyPlugin.class, (int)1);
        surveyAbstractActivity.isResumed = true;
        surveyAbstractActivity.handledAutoDismissingIfResumed();
        AutoShowingManager.getInstance().setSurveyShown(true);
    }

    protected void onPause() {
        SurveyAbstractActivity surveyAbstractActivity = this;
        surveyAbstractActivity.isResumed = false;
        super.onPause();
        surveyAbstractActivity.overridePendingTransition(0, 0);
    }

    protected int getLayout() {
        return R.layout.instabug_survey_activity;
    }

    protected void initViews() {
    }

    @Override
    public void finishSurvey(boolean bl) {
        Handler handler;
        if (this.getSupportFragmentManager() == null) {
            return;
        }
        Object object = this.getSupportFragmentManager().findFragmentById(R.id.instabug_fragment_container);
        if (object != null) {
            this.getSupportFragmentManager().beginTransaction().setCustomAnimations(0, R.anim.instabug_anim_flyout_to_bottom).remove(object).commitAllowingStateLoss();
        }
        Handler handler2 = handler;
        handler = new Handler();
        if (bl) {
            this.getSupportFragmentManager().beginTransaction().setCustomAnimations(0, 0).replace(R.id.instabug_fragment_container, (Fragment)ThanksAbstractFragment.newInstance(this.survey), "THANKS_FRAGMENT").commitAllowingStateLoss();
            if (!AccessibilityUtils.isTalkbackEnabled()) {
                object = () -> {
                    Fragment fragment = this.getSupportFragmentManager().findFragmentByTag("THANKS_FRAGMENT");
                    if (fragment != null) {
                        this.hideFragmentAfterDelay(fragment);
                    }
                };
                this.finishDelayRunnable = object;
                handler2.postDelayed((Runnable)object, 600L);
            }
        } else {
            Runnable runnable;
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    SurveyAbstractActivity.this.finish();
                }
            };
            this.finishDelayRunnable = object;
            handler2.postDelayed((Runnable)object, 300L);
        }
        this.finishDelayHandler = handler2;
        SurveysUtils.executeRunnableAfterShowingSurvey();
    }

    @Override
    public void finishNPSSurvey(boolean bl) {
        Fragment fragment = (Fragment)this.getSupportFragmentManager().getFragments().get(this.getSupportFragmentManager().getFragments().size() - 1);
        if (bl) {
            this.hideFragmentImmediately(fragment);
        } else if (!AccessibilityUtils.isTalkbackEnabled()) {
            this.hideFragmentAfterDelay(fragment);
        }
    }

    public void onBackPressed() {
        SurveyAbstractActivity surveyAbstractActivity = surveyAbstractActivity.presenter;
        if (surveyAbstractActivity != null) {
            ((SurveyPresenter)((Object)surveyAbstractActivity)).handleOnBackPressedLogic();
        }
    }

    protected void onDestroy() {
        Handler handler = this.finishDelayHandler;
        if (handler != null) {
            Runnable runnable = this.finishDelayRunnable;
            if (runnable != null) {
                handler.removeCallbacks(runnable);
            }
            SurveyAbstractActivity surveyAbstractActivity = this;
            surveyAbstractActivity.finishDelayHandler = null;
            surveyAbstractActivity.finishDelayRunnable = null;
        }
        super.onDestroy();
        InstabugCore.setPluginState(SurveyPlugin.class, (int)0);
        if (SurveysManager.getInstance() != null) {
            SurveysManager.getInstance().registerSurveysTriggerEvents();
        }
        AutoShowingManager.getInstance().setSurveyShown(false);
    }

    @Override
    public void setFrameLayoutHeightWithAnimation(int n) {
        int n2 = this.fragmentContainer.getMeasuredHeight();
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{n2, n});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                5 v0 = this;
                int n = (Integer)valueAnimator.getAnimatedValue();
                valueAnimator = v0.SurveyAbstractActivity.this.fragmentContainer.getLayoutParams();
                v0.SurveyAbstractActivity.this.fragmentContainer.getLayoutParams().height = n;
                v0.SurveyAbstractActivity.this.fragmentContainer.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
            }
        });
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    @Override
    public void setFrameLayoutHeightTo(int n) {
        SurveyAbstractActivity surveyAbstractActivity = surveyAbstractActivity2;
        SurveyAbstractActivity surveyAbstractActivity2 = (RelativeLayout.LayoutParams)surveyAbstractActivity.fragmentContainer.getLayoutParams();
        ((RelativeLayout.LayoutParams)surveyAbstractActivity.fragmentContainer.getLayoutParams()).height = n;
        surveyAbstractActivity.fragmentContainer.setLayoutParams((ViewGroup.LayoutParams)surveyAbstractActivity2);
    }

    public void setLayoutHeightSecondary(ViewType viewType, boolean bl) {
        SurveyAbstractActivity surveyAbstractActivity = surveyAbstractActivity.presenter;
        if (surveyAbstractActivity != null) {
            ((SurveyPresenter)((Object)surveyAbstractActivity)).setLayoutHeightSecondary(viewType, bl);
        }
    }

    public void setBackgroundTransparent(boolean bl) {
        View view = this.getWindow().getDecorView();
        int n = bl ? R.color.instabug_transparent_color : R.color.instabug_dialog_bg_color;
        view.setBackgroundColor(ContextCompat.getColor((Context)this, (int)n));
    }

    public void handleCloseClicked(Survey survey) {
        SurveyAbstractActivity surveyAbstractActivity = surveyAbstractActivity.presenter;
        if (surveyAbstractActivity != null) {
            ((SurveyPresenter)((Object)surveyAbstractActivity)).dismissSurvey(survey);
        }
    }

    @Nullable
    public ViewType getCurrentViewType() {
        SurveyAbstractActivity surveyAbstractActivity = surveyAbstractActivity.presenter;
        if (surveyAbstractActivity != null) {
            return ((SurveyPresenter)((Object)surveyAbstractActivity)).getState();
        }
        return ViewType.PRIMARY;
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.gestureDetector == null) {
            GestureListener.GesturesCallback gesturesCallback;
            GestureListener gestureListener;
            GestureDetector gestureDetector;
            GestureDetector gestureDetector2 = gestureDetector;
            GestureListener gestureListener2 = gestureListener;
            GestureListener.GesturesCallback gesturesCallback2 = gesturesCallback;
            gesturesCallback = new GestureListener.GesturesCallback(){

                @Override
                public void onSwipeRight() {
                    for (Fragment fragment : SurveyAbstractActivity.this.getSupportFragmentManager().getFragments()) {
                        if (!(fragment instanceof SurveyAbstractFragment)) continue;
                        ((SurveyAbstractFragment)fragment).onSwipeRight();
                        break;
                    }
                }

                @Override
                public void onSwipeLeft() {
                    for (Fragment fragment : SurveyAbstractActivity.this.getSupportFragmentManager().getFragments()) {
                        if (!(fragment instanceof SurveyAbstractFragment)) continue;
                        if (SurveyAbstractActivity.this.presenter != null) {
                            ((SurveyPresenter)SurveyAbstractActivity.this.presenter).setLayoutHeightSecondary(ViewType.PRIMARY, true);
                        }
                        ((SurveyAbstractFragment)fragment).onSwipeLeft();
                        break;
                    }
                }

                @Override
                public void onHardSwipeUp() {
                }

                @Override
                public void onHardSwipeDown() {
                }

                @Override
                public void onClick() {
                    Object object = object.SurveyAbstractActivity.this.getSupportFragmentManager().getFragments().iterator();
                    while (object.hasNext()) {
                        Fragment fragment = (Fragment)object.next();
                        if (!(fragment instanceof QuestionAbstractFragment)) continue;
                        object = (QuestionAbstractFragment)fragment;
                        if (!((QuestionAbstractFragment)object).isPartial()) break;
                        ((QuestionAbstractFragment)object).onClick();
                        break;
                    }
                }
            };
            gestureListener = new GestureListener(gesturesCallback2);
            gestureDetector = new GestureDetector((Context)this, (GestureDetector.OnGestureListener)gestureListener2);
            this.gestureDetector = gestureDetector2;
        }
        this.gestureDetector.onTouchEvent(motionEvent);
        return super.dispatchTouchEvent(motionEvent);
    }

    @Override
    public void submitSurvey(Survey survey) {
        SurveyAbstractActivity surveyAbstractActivity = surveyAbstractActivity.presenter;
        if (surveyAbstractActivity != null) {
            ((SurveyPresenter)((Object)surveyAbstractActivity)).submitSurvey(survey);
        }
    }

    @Override
    public void dismissSurvey(Survey survey) {
        SurveyAbstractActivity surveyAbstractActivity = surveyAbstractActivity.presenter;
        if (surveyAbstractActivity != null) {
            ((SurveyPresenter)((Object)surveyAbstractActivity)).dismissSurvey(survey);
        }
    }

    @Override
    public void onPageSelected(int n) {
        this.currentQuestionPosition = n;
    }

    @Nullable
    public Survey getSurvey() {
        return this.survey;
    }

    @Nullable
    public ViewType getViewState() {
        SurveyAbstractActivity surveyAbstractActivity = surveyAbstractActivity.presenter;
        if (surveyAbstractActivity != null) {
            return ((SurveyPresenter)((Object)surveyAbstractActivity)).getState();
        }
        return ViewType.PRIMARY;
    }
}

