/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.network.util;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.user.UserManagerWrapper;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.survey.common.models.ActionEvent;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class SubmittingSurveysUtil {
    public static void addParamsToSubmittingSurveyRequest(Context object, Request.Builder builder, Survey survey) {
        RequestParameter requestParameter;
        RequestParameter requestParameter2;
        RequestParameter requestParameter3;
        RequestParameter requestParameter4;
        Object object2;
        if (!survey.isLastEventDismiss() && (object2 = SubmittingSurveysUtil.getResponsesFromQuestions(survey.getQuestions())).length() > 0) {
            RequestParameter requestParameter5;
            requestParameter4 = requestParameter5;
            requestParameter5 = new RequestParameter("responses", object2);
            builder.addParameter(requestParameter4);
        }
        builder.addParameter(new RequestParameter("responded_at", (Object)survey.getRespondedAt()));
        object2 = InstabugCore.getIdentifiedUsername();
        if (object2 != null) {
            RequestParameter requestParameter6;
            requestParameter4 = requestParameter6;
            requestParameter6 = new RequestParameter("name", object2);
            builder.addParameter(requestParameter4);
        }
        Request.Builder builder2 = builder;
        builder2.addParameter(new RequestParameter("email", (Object)UserManagerWrapper.getUserEmail()));
        builder2.addParameter(new RequestParameter("events", (Object)SubmittingSurveysUtil.getSurveyEvents(survey.getSurveyEvents())));
        if (survey.getLocalization() != null && survey.getLocalization().getCurrentLocale() != null) {
            builder.addParameter(new RequestParameter("locale", (Object)survey.getLocalization().getCurrentLocale()));
        }
        Request.Builder builder3 = builder;
        object2 = requestParameter3;
        requestParameter3 = new RequestParameter("sdk_version", (Object)"15.0.2");
        builder3.addParameter((RequestParameter)object2);
        object2 = requestParameter2;
        requestParameter2 = new RequestParameter("app_version", (Object)DeviceStateProvider.getAppVersion((Context)object));
        builder3.addParameter((RequestParameter)object2);
        object = requestParameter;
        requestParameter = new RequestParameter("push_token", (Object)InstabugCore.getPushNotificationToken());
        builder3.addParameter((RequestParameter)object);
        object = InstabugCore.retrieveAllSDKAttributes();
        if (object != null && ((HashMap)object).size() > 0) {
            RequestParameter requestParameter7;
            object2 = requestParameter7;
            requestParameter7 = new RequestParameter("user_attributes", (Object)SubmittingSurveysUtil.getUserAttributes((HashMap<String, String>)object));
            builder.addParameter((RequestParameter)object2);
        }
        Request.Builder builder4 = builder;
        builder4.addParameter(new RequestParameter("os", (Object)DeviceStateProvider.getOS()));
        builder4.addParameter(new RequestParameter("device", (Object)DeviceStateProvider.getDevice()));
        if (survey.getSessionID() != null) {
            RequestParameter requestParameter8;
            object = requestParameter8;
            requestParameter8 = new RequestParameter("session_id", (Object)survey.getSessionID());
            builder.addParameter((RequestParameter)object);
        }
    }

    private static JSONArray getSurveyEvents(ArrayList<ActionEvent> object) {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        if (object != null && !((ArrayList)object).isEmpty()) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                JSONObject jSONObject;
                ActionEvent actionEvent = (ActionEvent)object.next();
                if (actionEvent.isSynced()) continue;
                JSONObject jSONObject2 = jSONObject;
                jSONObject2();
                jSONObject2.put("event_type", (Object)actionEvent.getEventType());
                long l = actionEvent.getTimestamp();
                jSONObject2.put("timestamp", l);
                jSONObject.put("index", actionEvent.getIndex());
                jSONArray2.put((Object)jSONObject2);
            }
            return jSONArray2;
        }
        return jSONArray2;
    }

    public static JSONArray getResponsesFromQuestions(ArrayList<Question> jSONArray) {
        JSONArray jSONArray2;
        JSONArray jSONArray3 = jSONArray;
        jSONArray = jSONArray2;
        jSONArray2 = new JSONArray();
        for (Question question : jSONArray3) {
            JSONObject jSONObject;
            if (question.getAnswer() == null || question.getAnswer().equals("")) continue;
            JSONObject jSONObject2 = jSONObject;
            jSONObject2();
            jSONObject2.put("value", (Object)question.getAnswer());
            long l = question.getId();
            jSONObject.put("question_id", l);
            jSONArray.put((Object)jSONObject2);
        }
        return jSONArray;
    }

    private static JSONObject getUserAttributes(HashMap<String, String> jSONObject) {
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject;
        jSONObject = jSONObject2;
        jSONObject2 = new JSONObject();
        for (Map.Entry entry : jSONObject3.entrySet()) {
            String string2 = (String)entry.getKey();
            jSONObject.put(string2, entry.getValue());
        }
        return jSONObject;
    }

    public static JSONObject getSurveyAsResponse(Survey survey, String string2) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2 = jSONObject;
        jSONObject2();
        long l = survey.getId();
        jSONObject2.put("id", l);
        jSONObject2.put("type", (Object)survey.getTypeAsString());
        jSONObject3.put("title", (Object)survey.getTitle());
        jSONObject3.put("is_announcement", false);
        jSONObject.put("responses", (Object)SubmittingSurveysUtil.getQuestionsAnswersAsJson(survey.getQuestions(), survey.getType(), string2));
        return jSONObject;
    }

    @VisibleForTesting
    public static JSONArray getQuestionsAnswersAsJson(ArrayList<Question> object, int n, String string2) {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        if ((n == 0 || n == 1) && string2.equals("DISMISSED")) {
            return jSONArray2;
        }
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            JSONObject jSONObject;
            Question question = (Question)object.next();
            if (question.getAnswer() == null || question.getAnswer().equals("")) continue;
            string2 = jSONObject;
            string2();
            long l = question.getId();
            string2.put("question_id", l);
            string2.put("question_title", (Object)question.getTitle());
            string2.put("question_type", (Object)question.getTypeAsString());
            l = question.getAnsweredAt();
            string2.put("response_timestamp", l);
            jSONObject.put("response_value", (Object)question.getAnswer());
            jSONArray2.put((Object)string2);
        }
        return jSONArray2;
    }
}

