/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.network;

import android.content.Context;
import androidx.annotation.Nullable;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.TimeUtils;
import com.instabug.survey.models.Survey;
import com.instabug.survey.network.service.SurveysService;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.utils.SurveysUtils;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class SurveysFetcher {
    private Callback callback;

    public SurveysFetcher(Callback callback) {
        this.callback = callback;
    }

    private boolean shouldFetchAgain() {
        return TimeUtils.currentTimeMillis() - SurveysSettings.getLastFetchedAt() > 10000L;
    }

    public void fetch(Context object, String string2) {
        if (SurveysUtils.isSurveysFeatureEnabled() && this.shouldFetchAgain()) {
            Request.Callbacks<JSONObject, Throwable> callbacks;
            object = callbacks;
            callbacks = new Request.Callbacks<JSONObject, Throwable>(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void onSucceeded(@Nullable JSONObject jSONObject) {
                    JSONException jSONException2;
                    block5: {
                        block4: {
                            List<Survey> list;
                            1 v0;
                            try {
                                SurveysSettings.setLastFetchedAt(TimeUtils.currentTimeMillis());
                                if (jSONObject == null) break block4;
                                v0 = this;
                                list = Survey.fromJson(jSONObject);
                            }
                            catch (JSONException jSONException2) {
                                break block5;
                            }
                            {
                                list.addAll(Survey.getPausedSurveysFromJson(jSONObject));
                            }
                            v0.SurveysFetcher.this.callback.onFetchingSucceeded(list);
                            return;
                        }
                        SurveysFetcher.this.callback.onFetchingFailed(new NullPointerException("Json response is null"));
                        return;
                    }
                    SurveysFetcher.this.callback.onFetchingFailed(jSONException2);
                }

                public void onFailed(Throwable throwable) {
                    SurveysFetcher.this.callback.onFetchingFailed(throwable);
                }
            };
            SurveysService.getInstance().fetchSurveys(string2, (Request.Callbacks<JSONObject, Throwable>)object);
        }
    }

    public static interface Callback {
        public void onFetchingSucceeded(List<Survey> var1);

        public void onFetchingFailed(Throwable var1);
    }
}

