/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.cache.SurveysDbHelper;
import com.instabug.survey.models.Survey;
import java.util.ArrayList;
import java.util.List;

public abstract class SurveysCacheManager {
    public static void addSurvey(final Survey survey) {
        PoolProvider.getSurveysDBExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SurveysDbHelper.insert(survey);
            }
        });
    }

    public static List<Survey> getSurveys() {
        List list = (List)PoolProvider.getSurveysDBExecutor().executeAndGet((ReturnableRunnable)new ReturnableRunnable<List<Survey>>(){

            public List<Survey> run() {
                return SurveysDbHelper.retrieve();
            }
        });
        if (list == null) {
            ArrayList arrayList;
            list = arrayList;
            arrayList = new ArrayList();
        }
        return list;
    }

    public static List<Survey> getTimeTriggeredSurveys() {
        List list = (List)PoolProvider.getSurveysDBExecutor().executeAndGet((ReturnableRunnable)new ReturnableRunnable<List<Survey>>(){

            public List<Survey> run() {
                return SurveysDbHelper.retrieveTimeTriggeredSurveys();
            }
        });
        if (list == null) {
            ArrayList arrayList;
            list = arrayList;
            arrayList = new ArrayList();
        }
        return list;
    }

    public static List<Survey> getReadyToSendSurveys() {
        List list = (List)PoolProvider.getSurveysDBExecutor().executeAndGet((ReturnableRunnable)new ReturnableRunnable<List<Survey>>(){

            public List<Survey> run() {
                return SurveysDbHelper.retrieveReadyToBeSend();
            }
        });
        if (list == null) {
            ArrayList arrayList;
            list = arrayList;
            arrayList = new ArrayList();
        }
        return list;
    }

    public static void update(final Survey survey) {
        PoolProvider.getSurveysDBExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SurveysDbHelper.update(survey);
            }
        });
    }

    @WorkerThread
    public static void updateSessions(final Survey survey) {
        PoolProvider.getSurveysDBExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SurveysDbHelper.updateSessions(survey);
            }
        });
    }

    public static void insertOrUpdatePausedOrLocale(final Survey survey, final boolean bl, final boolean bl2) {
        PoolProvider.getSurveysDBExecutor().execute(new Runnable(){

            @Override
            public void run() {
                10 v0 = this;
                boolean bl3 = v0.bl;
                SurveysDbHelper.insertOrUpdatePausedOrLocales(survey, bl3, v0.bl2);
            }
        });
    }

    public static void updateSurveyTarget(@NonNull Survey survey) {
        PoolProvider.getSurveysDBExecutor().execute(() -> SurveysDbHelper.updateSurveyTarget(survey));
    }

    @Nullable
    public static Survey getSurveyById(final long l) {
        return (Survey)PoolProvider.getSurveysDBExecutor().executeAndGet((ReturnableRunnable)new ReturnableRunnable<Survey>(){

            @Nullable
            public Survey run() {
                return SurveysDbHelper.retrieveById(l);
            }
        });
    }

    public static boolean isSurveyExisting(final long l) {
        Boolean bl = (Boolean)PoolProvider.getSurveysDBExecutor().executeAndGet((ReturnableRunnable)new ReturnableRunnable<Boolean>(){

            @Nullable
            public Boolean run() {
                return SurveysDbHelper.retrieveById(l) != null;
            }
        });
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static void resetSurveyUserInteraction(List<Survey> list) {
        for (Survey survey : list) {
            survey.resetUserInteractions();
            survey.resetUserAnswers();
        }
        SurveysCacheManager.updateBulk(list);
    }

    public static void delete(final long l) {
        PoolProvider.getSurveysDBExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SurveysDbHelper.delete(l);
            }
        });
    }

    @WorkerThread
    public static void updateBulk(final List<Survey> list) {
        PoolProvider.getSurveysDBExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SurveysDbHelper.updateBulk(list);
            }
        });
    }
}

