/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.ui.fragment.whatsnew;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.view.ViewUtils;
import com.instabug.survey.R;
import com.instabug.survey.announcements.cache.AnnouncementCacheManager;
import com.instabug.survey.announcements.models.AnnouncementItem;
import com.instabug.survey.announcements.models.NewFeature;
import org.jetbrains.annotations.NotNull;

public class WhatsNewFeaturesAdapter
extends RecyclerView.Adapter<NewFeatureViewHolder> {
    private final LayoutInflater inflater;
    private final AnnouncementItem announcementItem;

    WhatsNewFeaturesAdapter(Activity activity, AnnouncementItem announcementItem) {
        this.inflater = LayoutInflater.from((Context)activity);
        this.announcementItem = announcementItem;
    }

    @Nullable
    private NewFeature getItem(int n) {
        if (this.announcementItem.getNewFeatures() == null) {
            return null;
        }
        return this.announcementItem.getNewFeatures().get(n);
    }

    @NotNull
    public NewFeatureViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int n) {
        WhatsNewFeaturesAdapter whatsNewFeaturesAdapter = this;
        return whatsNewFeaturesAdapter.new NewFeatureViewHolder(whatsNewFeaturesAdapter.inflater.inflate(R.layout.instabug_announcement_new_feature_item, viewGroup, false));
    }

    public void onBindViewHolder(@NonNull NewFeatureViewHolder newFeatureViewHolder, int n) {
        NewFeature newFeature = this.getItem(n);
        if (newFeature != null) {
            newFeatureViewHolder.bindFeatureText(newFeature);
            if (this.announcementItem != null) {
                newFeatureViewHolder.handleAnnouncementIcon(newFeature);
            }
        }
    }

    public long getItemId(int n) {
        return n;
    }

    public int getItemCount() {
        AnnouncementItem announcementItem = this.announcementItem;
        return announcementItem != null && announcementItem.getNewFeatures() != null ? this.announcementItem.getNewFeatures().size() : 0;
    }

    class NewFeatureViewHolder
    extends RecyclerView.ViewHolder {
        @Nullable
        private final LinearLayout textContainer;
        @Nullable
        private final TextView title;
        @Nullable
        private final TextView description;
        @Nullable
        private final ImageView icon;

        NewFeatureViewHolder(View view) {
            super(view);
            this.textContainer = (LinearLayout)view.findViewById(R.id.feature_content_container);
            this.title = (TextView)view.findViewById(R.id.new_feature_title);
            this.description = (TextView)view.findViewById(R.id.new_feature_description);
            this.icon = (ImageView)view.findViewById(R.id.new_feature_img);
        }

        private void setTextContainerSpacing() {
            LinearLayout linearLayout;
            int n = 0;
            if (!WhatsNewFeaturesAdapter.this.announcementItem.hasNoIcons() && this.textContainer != null) {
                n = ViewUtils.convertDpToPx((Context)this.itemView.getContext(), (float)16.0f);
            }
            if (ViewCompat.getLayoutDirection((View)this.itemView) == 1 && (linearLayout = this.textContainer) != null) {
                linearLayout.setPadding(0, 0, n, 0);
            } else if (ViewCompat.getLayoutDirection((View)this.itemView) == 0 && (this = this.textContainer) != null) {
                this.setPadding(n, 0, 0, 0);
            }
        }

        void bindFeatureText(@NonNull NewFeature object) {
            NewFeatureViewHolder newFeatureViewHolder = this;
            newFeatureViewHolder.setTextContainerSpacing();
            TextView textView = newFeatureViewHolder.title;
            if (textView != null) {
                String string2 = ((NewFeature)object).getTitle() != null ? ((NewFeature)object).getTitle() : "";
                textView.setText((CharSequence)string2);
            }
            if ((this = this.description) != null) {
                object = ((NewFeature)object).getDescription() != null ? ((NewFeature)object).getDescription() : "";
                this.setText((CharSequence)object);
            }
        }

        void handleAnnouncementIcon(@NonNull NewFeature object) {
            ImageView imageView;
            if (WhatsNewFeaturesAdapter.this.announcementItem != null && WhatsNewFeaturesAdapter.this.announcementItem.hasNoIcons() && (imageView = this.icon) != null) {
                int n = imageView.getPaddingTop();
                int n2 = this.icon.getPaddingBottom();
                imageView.setPadding(0, n, 0, n2);
                this.icon.setVisibility(8);
            } else if (WhatsNewFeaturesAdapter.this.announcementItem != null && !WhatsNewFeaturesAdapter.this.announcementItem.hasNoIcons() && (imageView = this.icon) != null) {
                imageView.setVisibility(0);
                object = AnnouncementCacheManager.getAnnouncementAsset(WhatsNewFeaturesAdapter.this.announcementItem.getId(), ((NewFeature)object).getId());
                if (object != null) {
                    BitmapUtils.loadBitmapWithFallback((String)object, (ImageView)this.icon, (int)R.drawable.ibg_survey_ic_star_icon_placholder);
                } else {
                    this.icon.setImageResource(R.drawable.ibg_survey_ic_star_icon_placholder);
                }
            }
        }
    }
}

