/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.ui.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.widget.Toast;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.URLUtil;
import com.instabug.survey.R;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.ui.fragment.versionupdate.UpdateMessageFragment;
import com.instabug.survey.announcements.ui.fragment.whatsnew.WhatsNewFragment;
import java.util.Locale;

public abstract class AnnouncementNavigator {
    public static void navigateToAnnouncement(FragmentManager fragmentManager, Announcement announcement) {
        int n = announcement.getType();
        if (n != 100) {
            if (n == 101) {
                AnnouncementNavigator.showUpdateMessageFragment(fragmentManager, announcement);
            }
        } else {
            int n2 = R.anim.instabug_anim_flyout_to_bottom;
            AnnouncementNavigator.showWhatsNewFragment(fragmentManager, announcement, R.anim.instabug_anim_flyin_from_bottom, n2);
        }
    }

    private static void showWhatsNewFragment(FragmentManager fragmentManager, Announcement announcement, int n, int n2) {
        if (announcement.getAnnouncementItems() != null) {
            AnnouncementNavigator.navigateToFragment(fragmentManager, (Fragment)WhatsNewFragment.newInstance(announcement.getAnnouncementItems().get(0)), n, n2);
        }
    }

    private static void showUpdateMessageFragment(FragmentManager fragmentManager, Announcement announcement) {
        if (announcement.getAnnouncementItems() != null) {
            AnnouncementNavigator.navigateToFragment(fragmentManager, (Fragment)UpdateMessageFragment.newInstance(announcement.getAnnouncementItems().get(0)), 0, 0);
        }
    }

    public static void navigateToFragment(FragmentManager fragmentManager, Fragment fragment, int n, int n2) {
        fragmentManager.beginTransaction().setCustomAnimations(n, n2).replace(R.id.instabug_fragment_container, fragment).commit();
    }

    public static void navigateToExternalBrowser(Context context, String string2) {
        if (context != null) {
            if ((string2 = URLUtil.resolve((String)string2)) == null) {
                Context context2 = context;
                AnnouncementNavigator.showToast(context2, LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)context2), (int)R.string.ib_announcement_redirect_error, (Context)context));
            } else {
                Intent intent;
                Intent intent2 = intent;
                intent2("android.intent.action.VIEW", Uri.parse((String)string2));
                if (intent.resolveActivity(context.getPackageManager()) != null) {
                    context.startActivity(intent2);
                } else {
                    Context context3 = context;
                    AnnouncementNavigator.showToast(context3, LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)context3), (int)R.string.ib_announcement_redirect_error, (Context)context));
                }
            }
        }
    }

    private static void showToast(Context context, String string2) {
        Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
    }
}

