/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.network;

import android.content.Context;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.network.AnnouncementSubmittingUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class AnnouncementsService {
    private static AnnouncementsService INSTANCE;
    private final NetworkManager networkManager;

    private AnnouncementsService() {
        NetworkManager networkManager;
        AnnouncementsService announcementsService = networkManager;
        networkManager = new NetworkManager();
        v1.networkManager = announcementsService;
    }

    public static AnnouncementsService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnnouncementsService();
        }
        return INSTANCE;
    }

    public void fetchAnnouncements(String string, final Request.Callbacks<JSONObject, Throwable> callbacks) {
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        InstabugSDKLogger.d((String)"IBG-Surveys", (String)"fetching announcements");
        string = new Request.Builder().endpoint("/announcements/v2").method("GET").addParameter(new RequestParameter("locale", (Object)string)).addHeader(new RequestParameter("Accept", (Object)"application/vnd.instabug.v2")).addHeader(new RequestParameter("version", (Object)"2")).build();
        Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onSucceeded(RequestResponse requestResponse) {
                JSONException jSONException2;
                block4: {
                    InstabugSDKLogger.d((String)"IBG-Surveys", (String)("fetchingAnnouncementsRequest succeeded, Response code: " + requestResponse.getResponseCode()));
                    InstabugSDKLogger.v((String)"IBG-Surveys", (String)("Response: " + requestResponse));
                    if (requestResponse.getResponseCode() != 200) {
                        callbacks.onFailed((Object)new Throwable("Fetching Announcements got error with response code:" + requestResponse.getResponseCode()));
                        return;
                    }
                    try {
                        if (requestResponse.getResponseBody() != null) {
                            callbacks.onSucceeded((Object)new JSONObject((String)requestResponse.getResponseBody()));
                            return;
                        }
                    }
                    catch (JSONException jSONException2) {
                        break block4;
                    }
                    callbacks.onSucceeded((Object)new JSONObject());
                    return;
                }
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)("submittingAnnouncementRequest got JSONException: " + jSONException2.getMessage()), (Throwable)jSONException2);
                callbacks.onFailed((Object)jSONException2);
            }

            public void onFailed(Throwable throwable) {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)("fetchingAnnouncementsRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                callbacks.onFailed((Object)throwable);
            }
        };
        this.networkManager.doRequest("ANNOUNCEMENTS", 1, (Request)string, (Request.Callbacks)callbacks3);
    }

    public void submittingAnnouncement(Context object, Announcement announcement, final Request.Callbacks<Boolean, Throwable> callbacks) {
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        InstabugSDKLogger.v((String)"IBG-Surveys", (String)"submitting announcement");
        String string = String.valueOf(announcement.getId());
        string = new Request.Builder().method("POST").endpoint("/announcements/:announcement_id/v2/responses".replaceAll(":announcement_id", string));
        AnnouncementSubmittingUtils.addParamsToSubmittingAnnouncementRequest((Request.Builder)string, DeviceStateProvider.getAppVersion((Context)object), announcement);
        object = callbacks2;
        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

            public void onSucceeded(RequestResponse requestResponse) {
                InstabugSDKLogger.d((String)"IBG-Surveys", (String)("submittingAnnouncementRequest succeeded, Response code: " + requestResponse.getResponseCode()));
                String string = "IBG-Surveys";
                StringBuilder stringBuilder = new StringBuilder().append("submittingAnnouncementRequest Response body: ");
                Object object = requestResponse.getResponseBody() != null ? requestResponse.getResponseBody() : "body is null";
                InstabugSDKLogger.v((String)string, (String)stringBuilder.append(object).toString());
                if (requestResponse.getResponseCode() == 200) {
                    callbacks.onSucceeded((Object)Boolean.TRUE);
                } else {
                    2 v0 = this;
                    v0.callbacks.onSucceeded((Object)Boolean.FALSE);
                    v0.callbacks.onFailed((Object)new Throwable("submittingAnnouncementRequest got error with response code:" + requestResponse.getResponseCode()));
                }
            }

            public void onFailed(Throwable throwable) {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)("submittingAnnouncementRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                callbacks.onFailed((Object)throwable);
            }
        };
        this.networkManager.doRequestOnSameThread(1, string.build(), (Request.Callbacks)object);
    }
}

