/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.cache;

import android.content.Context;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.announcements.cache.AnnouncementCacheManager;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.models.AnnouncementItem;
import com.instabug.survey.announcements.models.NewFeature;
import io.reactivexport.Observable;
import io.reactivexport.ObservableEmitter;
import io.reactivexport.ObservableOnSubscribe;
import io.reactivexport.Observer;
import io.reactivexport.observers.DisposableObserver;
import java.util.ArrayList;
import java.util.List;

public abstract class NewFeaturesAssetsHelper {
    public static void downloadAssets(final Announcement announcement) {
        InstabugSDKLogger.d((String)"IBG-Surveys", (String)("downloading announcement assets for: " + announcement.getId()));
        List<Observable<AssetEntity>> list = null;
        if (announcement.getAnnouncementItems() != null) {
            list = NewFeaturesAssetsHelper.getDownloadingObservables(announcement.getAnnouncementItems().get(0));
        }
        if (list == null) {
            return;
        }
        Observable.merge(list).subscribe((Observer)new DisposableObserver<AssetEntity>(){

            public void onNext(AssetEntity assetEntity) {
                InstabugSDKLogger.d((String)"IBG-Surveys", (String)("downloading announcement " + announcement.getId() + " asset started"));
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)("downloading announcement " + announcement.getId() + " assets failed"));
                PoolProvider.postIOTask((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AnnouncementCacheManager.updateAssetStatus(announcement.getId(), 2);
                    }
                });
            }

            public void onComplete() {
                InstabugSDKLogger.d((String)"IBG-Surveys", (String)("downloading announcement " + announcement.getId() + " assets completed"));
                announcement.setAssetsStatus(1);
                PoolProvider.postIOTask((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AnnouncementCacheManager.updateAssetStatus(announcement.getId(), 1);
                    }
                });
            }
        });
    }

    @Nullable
    private static List<Observable<AssetEntity>> getDownloadingObservables(AnnouncementItem announcementItem) {
        ArrayList<Observable<AssetEntity>> arrayList;
        if (announcementItem.getNewFeatures() == null) {
            return null;
        }
        ArrayList<Observable<AssetEntity>> arrayList2 = arrayList;
        arrayList = new ArrayList<Observable<AssetEntity>>(announcementItem.getNewFeatures().size());
        for (int i = 0; i < announcementItem.getNewFeatures().size(); ++i) {
            NewFeature newFeature = announcementItem.getNewFeatures().get(i);
            if (newFeature.getIconUrl() == null || newFeature.getIconUrl().equals("")) continue;
            arrayList2.add(NewFeaturesAssetsHelper.getFeatureObservable(announcementItem.getId(), newFeature));
        }
        return arrayList2;
    }

    private static Observable<AssetEntity> getFeatureObservable(final long l, final NewFeature newFeature) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<AssetEntity>(){

            public void subscribe(final ObservableEmitter<AssetEntity> observableEmitter) {
                if (Instabug.getApplicationContext() == null) {
                    return;
                }
                if (newFeature.getIconUrl() != null) {
                    AssetsCacheManager.getAssetEntity((AssetEntity)AssetsCacheManager.createEmptyEntity((Context)Instabug.getApplicationContext(), (String)newFeature.getIconUrl(), (AssetEntity.AssetType)AssetEntity.AssetType.IMAGE), (AssetsCacheManager.OnDownloadFinished)new AssetsCacheManager.OnDownloadFinished(){

                        public void onSuccess(final AssetEntity assetEntity) {
                            InstabugCore.doOnBackground((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    1 v0 = this;
                                    2 var1_1 = v0.this;
                                    AnnouncementCacheManager.insertAnnouncementAsset(var1_1.l, var1_1.newFeature.getId(), assetEntity.getFile().getPath());
                                    v0.observableEmitter.onNext((Object)assetEntity);
                                    v0.observableEmitter.onComplete();
                                }
                            });
                        }

                        public void onFailed(Throwable throwable) {
                            if (!observableEmitter.isDisposed()) {
                                observableEmitter.onError(throwable);
                            } else {
                                InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Assets Request got error: " + throwable));
                            }
                        }
                    });
                }
            }
        });
    }
}

