/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements;

import android.content.Context;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ObjectMapper;
import com.instabug.library.util.StringUtility;
import com.instabug.library.util.TimeUtils;
import com.instabug.survey.announcements.cache.AnnouncementsDBHelper;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.settings.AnnouncementsSettings;
import com.instabug.survey.common.models.Condition;
import com.instabug.survey.models.CountryInfo;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnnouncementValidator {
    @Deprecated
    @Nullable
    private String appVersionName;
    private String appVersionAndCodeName;

    AnnouncementValidator(@Nullable String string, String string2) {
        this.appVersionName = string;
        this.appVersionAndCodeName = string2;
    }

    @Nullable
    private static Condition getTargetVersionCondition(Announcement object) {
        if (object == null) {
            AnnouncementValidator.log("getTargetVersionCondition(announcement: null)");
        } else {
            AnnouncementValidator.log("getTargetVersionCondition(announcementId: " + ((Announcement)object).getId() + ")");
            for (Condition condition : ((Announcement)object).getTarget().getTargetAudiences()) {
                if (condition.getKey() == null || !condition.getKey().equals("app_version_v2")) continue;
                AnnouncementValidator.log("condition: " + condition);
                return condition;
            }
        }
        return null;
    }

    private List<Announcement> getValidUpdateMessageAnnouncements() {
        ArrayList<Announcement> arrayList;
        Object object = AnnouncementsDBHelper.retrieveByType(101);
        ArrayList<Announcement> arrayList2 = arrayList;
        arrayList = new ArrayList<Announcement>();
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                Announcement announcement = (Announcement)object.next();
                if (!this.checkAnnouncementValidity(announcement) || !this.validateShowingRepetition(announcement)) continue;
                arrayList2.add(announcement);
            }
        }
        return arrayList2;
    }

    private boolean validateShowingRepetition(Announcement announcement) {
        boolean bl = announcement.shouldShow();
        AnnouncementValidator.log("validateShowingRepetition(announcement: " + announcement + "). ShouldShow ? " + bl);
        return bl;
    }

    private List<Announcement> getValidWhatsNewAnnouncements() {
        ArrayList<Announcement> arrayList;
        Object object = AnnouncementsDBHelper.retrieveByType(100);
        ArrayList<Announcement> arrayList2 = arrayList;
        arrayList = new ArrayList<Announcement>();
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                Announcement announcement = (Announcement)object.next();
                if (!this.validateAnnouncementTargetVersion(announcement) || !this.validateShowingRepetition(announcement) || !this.validateAssetsAreReady(announcement)) continue;
                arrayList2.add(announcement);
            }
        }
        return arrayList2;
    }

    private boolean validateAssetsAreReady(Announcement announcement) {
        return announcement.getAssetsStatus() == 1;
    }

    private boolean validateAnnouncementTargetVersion(Announcement cacheable) {
        if (Instabug.getApplicationContext() == null) {
            return false;
        }
        if (!InstabugDeviceProperties.isFirstInstall((Context)Instabug.getApplicationContext()) && (cacheable = AnnouncementValidator.getTargetVersionCondition(cacheable)) != null) {
            return this.validateAppVersionV2((Condition)cacheable);
        }
        return false;
    }

    private boolean validateOSApiLevel(Condition condition) {
        AnnouncementValidator.log("validateOSApiLevel(condition: " + condition + ")");
        int n = Build.VERSION.SDK_INT;
        AnnouncementValidator.log("Build.VERSION.SDK_INT: " + n);
        if (condition.getValue() != null && condition.getOperator() != null) {
            Condition condition2 = condition;
            int n2 = Integer.parseInt(condition2.getValue());
            String string = condition2.getOperator();
            string.hashCode();
            int n3 = -1;
            switch (string.hashCode()) {
                default: {
                    break;
                }
                case 1614662344: {
                    if (!string.equals("not_equal")) break;
                    n3 = 3;
                    break;
                }
                case 365984903: {
                    if (!string.equals("less_than")) break;
                    n3 = 2;
                    break;
                }
                case 96757556: {
                    if (!string.equals("equal")) break;
                    n3 = 1;
                    break;
                }
                case -1374681402: {
                    if (!string.equals("greater_than")) break;
                    n3 = 0;
                }
            }
            switch (n3) {
                default: {
                    return false;
                }
                case 3: {
                    return n != n2;
                }
                case 2: {
                    return n < n2;
                }
                case 1: {
                    return n == n2;
                }
                case 0: 
            }
            return n > n2;
        }
        return false;
    }

    private boolean validateSessionCount(Condition condition, int n) {
        return this.checkSessionCountCondition(condition, n);
    }

    private boolean checkSessionCountCondition(Condition object, int n) {
        AnnouncementValidator.log("checkSessionCountCondition(condition: " + object + "). actualSessionCount: " + n);
        if (((Condition)object).getValue() != null && ((Condition)object).getOperator() != null) {
            Condition condition = object;
            int n2 = Integer.parseInt(condition.getValue());
            object = condition.getOperator();
            ((String)object).hashCode();
            int n3 = -1;
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 1614662344: {
                    if (!((String)object).equals("not_equal")) break;
                    n3 = 3;
                    break;
                }
                case 365984903: {
                    if (!((String)object).equals("less_than")) break;
                    n3 = 2;
                    break;
                }
                case 96757556: {
                    if (!((String)object).equals("equal")) break;
                    n3 = 1;
                    break;
                }
                case -1374681402: {
                    if (!((String)object).equals("greater_than")) break;
                    n3 = 0;
                }
            }
            switch (n3) {
                default: {
                    return false;
                }
                case 3: {
                    return n != n2;
                }
                case 2: {
                    return n < n2;
                }
                case 1: {
                    return n == n2;
                }
                case 0: 
            }
            return n > n2;
        }
        return false;
    }

    private int getDifferenceDays(long l, long l2) {
        return (int)TimeUnit.DAYS.convert(l2 - l, TimeUnit.MILLISECONDS);
    }

    private static void log(String string) {
        InstabugSDKLogger.i((String)"AnnouncementValidator", (String)string);
    }

    public List<Announcement> getValidAnnouncements() {
        List<Announcement> list = this.getValidUpdateMessageAnnouncements();
        if (list.size() == 0) {
            list = this.getValidWhatsNewAnnouncements();
        }
        return list;
    }

    @Nullable
    public Announcement getFirstValidAnnouncement() {
        if ((this = ((AnnouncementValidator)this).getValidAnnouncements()) != null && this.size() > 0) {
            Announcement announcement = (Announcement)this.get(0);
            AnnouncementValidator.log("getFirstValidAnnouncement:" + this.size() + " available announcements");
            AnnouncementValidator.log("getFirstValidAnnouncement: " + announcement);
            return announcement;
        }
        AnnouncementValidator.log("getFirstValidAnnouncement: no valid announcements. Returning null...");
        return null;
    }

    @Nullable
    public String extractVersion(@Nullable String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("\\d+(\\.\\d+)*").matcher(string);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    @VisibleForTesting
    boolean checkAnnouncementValidity(Announcement announcement) {
        Announcement announcement2 = announcement;
        AnnouncementValidator announcementValidator = arrayList;
        Announcement announcement3 = announcement;
        AnnouncementValidator.log("checkStringCondition(announcement: " + announcement + ")");
        ArrayList<Condition> arrayList = announcement3.getTarget().getTargetAudiences();
        boolean bl = announcementValidator.checkPrimitiveTypes(arrayList, announcement3.getConditionsOperator());
        AnnouncementValidator.log("primitiveTypesValidity: " + bl);
        boolean bl2 = ValidationUtils.checkCustomAttributesConditions(announcement2.getTarget().getCustomAttributes(), announcement.getConditionsOperator());
        AnnouncementValidator.log("customAttributesValidity: " + bl2);
        boolean bl3 = ValidationUtils.checkUserEvents(announcement2.getTarget().getUserEvents(), announcement.getConditionsOperator());
        AnnouncementValidator.log("userEventsValidity: " + bl3);
        if (announcement2.getTarget().getUserEvents().size() <= 0 && announcement.getTarget().getCustomAttributes().size() <= 0 && announcement.getTarget().getTargetAudiences().size() <= 0) {
            return true;
        }
        if ("or".equals(announcement.getConditionsOperator())) {
            return bl || bl2 || bl3;
        }
        return bl && bl2 && bl3;
    }

    @VisibleForTesting
    boolean checkPrimitiveTypes(ArrayList<Condition> arrayList, String string) {
        int n = arrayList == null ? 0 : arrayList.size();
        AnnouncementValidator.log("checkPrimitiveTypes(primitiveTypesConditions: " + n + ", conditionsOperator: " + string + ")");
        boolean bl = string.equals("and");
        for (int i = 0; i < n; ++i) {
            boolean bl2 = this.checkPrimitiveType(arrayList.get(i));
            if (i == 0) {
                bl = bl2;
                continue;
            }
            if ("or".equals(string)) {
                bl |= bl2;
                continue;
            }
            bl &= bl2;
        }
        return bl;
    }

    @VisibleForTesting
    boolean checkPrimitiveType(Condition condition) {
        AnnouncementValidator.log("checkPrimitiveType(primitiveTypeCondition: " + condition + ")");
        if (condition.getKey() != null) {
            String string = condition.getKey();
            string.hashCode();
            int n = -1;
            switch (string.hashCode()) {
                default: {
                    break;
                }
                case 2013274756: {
                    if (!string.equals("last_seen")) break;
                    n = 6;
                    break;
                }
                case 1905908461: {
                    if (!string.equals("sessions_count")) break;
                    n = 5;
                    break;
                }
                case 1694233633: {
                    if (!string.equals("app_version_v2")) break;
                    n = 4;
                    break;
                }
                case 957831062: {
                    if (!string.equals("country")) break;
                    n = 3;
                    break;
                }
                case 96619420: {
                    if (!string.equals("email")) break;
                    n = 2;
                    break;
                }
                case -12379384: {
                    if (!string.equals("android_version")) break;
                    n = 1;
                    break;
                }
                case -901870406: {
                    if (!string.equals("app_version")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    return false;
                }
                case 6: {
                    return this.checkLastSeenTimestamp(condition);
                }
                case 5: {
                    return this.validateSessionCount(condition, SettingsManager.getInstance().getSessionsCount());
                }
                case 4: {
                    return this.validateAppVersionV2(condition);
                }
                case 3: {
                    return this.validateCountryCode(condition, (CountryInfo)ObjectMapper.fromJson((String)AnnouncementsSettings.getCountryInfo(), CountryInfo.class));
                }
                case 2: {
                    return this.validateUserEmail(condition);
                }
                case 1: {
                    return this.checkOSApiLevel(condition);
                }
                case 0: 
            }
            return this.validateAppVersion(condition);
        }
        return false;
    }

    public boolean checkOSApiLevel(Condition condition) {
        return this.validateOSApiLevel(condition);
    }

    @VisibleForTesting
    public boolean validateCountryCode(Condition condition, @Nullable CountryInfo countryInfo) {
        if (countryInfo != null && condition != null) {
            String string = countryInfo.getCountryCode();
            if ("equal".equals(condition.getOperator()) && condition.getValue() != null) {
                return condition.getValue().equalsIgnoreCase(string);
            }
            return false;
        }
        return false;
    }

    @Deprecated
    boolean validateAppVersion(Condition object) {
        AnnouncementValidator.log("validateAppVersion(condition: " + object + ")");
        String string = this.extractVersion(((Condition)object).getValue());
        AnnouncementValidator announcementValidator = this;
        String string2 = announcementValidator.extractVersion(announcementValidator.appVersionAndCodeName);
        if (string != null) {
            int n;
            block16: {
                if (string2 == null) {
                    return false;
                }
                try {
                    n = StringUtility.compareVersion((String)string2, (String)string);
                    if (((Condition)object).getOperator() != null) break block16;
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            object = ((Condition)object).getOperator();
            ((String)object).hashCode();
            int n2 = -1;
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 1614662344: {
                    if (!((String)object).equals("not_equal")) break;
                    n2 = 3;
                    break;
                }
                case 365984903: {
                    if (!((String)object).equals("less_than")) break;
                    n2 = 2;
                    break;
                }
                case 96757556: {
                    if (!((String)object).equals("equal")) break;
                    n2 = 1;
                    break;
                }
                case -1374681402: {
                    if (!((String)object).equals("greater_than")) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                default: {
                    return false;
                }
                case 3: {
                    return n != 0;
                }
                case 2: {
                    return n == -1;
                }
                case 1: {
                    return n == 0;
                }
                case 0: 
            }
            return n == 1;
        }
        return ValidationUtils.checkStringCondition((Condition)object, this.appVersionName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean validateAppVersionV2(Condition condition) {
        int n;
        long l;
        long l2;
        String string;
        block12: {
            AnnouncementValidator.log("validateAppVersion(condition: " + condition + ")");
            string = condition.getOperator();
            if (string == null) return false;
            if (condition.getValue() == null) {
                return false;
            }
            if (!string.equals("greater_than")) {
                if (!string.equals("less_than")) return ValidationUtils.checkStringCondition(condition, this.appVersionAndCodeName);
            }
            try {
                l2 = Long.parseLong(condition.getValue());
                l = SurveysSettings.getFirstSeen();
                if (l2 == -1L) return false;
                if (l == -1L) {
                    return false;
                }
                n = -1;
                int n2 = string.hashCode();
                if (n2 == -1374681402) break block12;
                if (n2 == 365984903 && string.equals("less_than")) {
                    n = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (string.equals("greater_than")) {
            n = 0;
        }
        if (n != 0) {
            if (n != 1) {
                return false;
            }
            if (l >= l2) return false;
            return true;
        }
        if (l <= l2) return false;
        return true;
    }

    @VisibleForTesting
    boolean validateUserEmail(Condition condition) {
        String string = InstabugCore.getIdentifiedUserEmail();
        AnnouncementValidator.log("validateUserEmail(condition: " + condition + "). userEmail: " + string);
        return ValidationUtils.checkStringCondition(condition, string);
    }

    public boolean checkLastSeenTimestamp(Condition condition) {
        if (condition.getOperator() != null && condition.getValue() != null) {
            AnnouncementValidator announcementValidator = string;
            long l = Long.parseLong(condition.getValue());
            long l2 = announcementValidator.getDifferenceDays(announcementValidator.getLastSeenTimestamp(), TimeUtils.currentTimeMillis());
            AnnouncementValidator.log("checkLastSeenTimestamp(condition: " + condition + "). daysSinceLastSeen: " + l2);
            String string = condition.getOperator();
            string.hashCode();
            int n = -1;
            switch (string.hashCode()) {
                default: {
                    break;
                }
                case 1614662344: {
                    if (!string.equals("not_equal")) break;
                    n = 3;
                    break;
                }
                case 365984903: {
                    if (!string.equals("less_than")) break;
                    n = 2;
                    break;
                }
                case 96757556: {
                    if (!string.equals("equal")) break;
                    n = 1;
                    break;
                }
                case -1374681402: {
                    if (!string.equals("greater_than")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    return false;
                }
                case 3: {
                    return l2 != l;
                }
                case 2: {
                    return l2 < l;
                }
                case 1: {
                    return l2 == l;
                }
                case 0: 
            }
            return l2 > l;
        }
        return false;
    }

    @VisibleForTesting
    public long getLastSeenTimestamp() {
        return InstabugCore.getLastSeenTimestamp();
    }
}

