/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.UserEventsEventBus;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.storage.cache.db.InstabugDBInsertionListener;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.UserManagerWrapper;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.TaskDebouncer;
import com.instabug.library.util.TimeUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.Survey;
import com.instabug.survey.SurveyTimerEvent;
import com.instabug.survey.announcements.settings.AnnouncementsSettings;
import com.instabug.survey.cache.SurveysCacheManager;
import com.instabug.survey.common.AutoShowingManager;
import com.instabug.survey.common.models.Frequency;
import com.instabug.survey.common.models.UserInteraction;
import com.instabug.survey.common.userInteractions.UserInteractionCacheManager;
import com.instabug.survey.configuration.SurveysConfigurationsProvider;
import com.instabug.survey.di.ServiceLocator;
import com.instabug.survey.models.CountryInfo;
import com.instabug.survey.network.CountryInfoResolver;
import com.instabug.survey.network.SurveysFetcher;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.utils.SurveysUtils;
import com.instabug.survey.utils.SurveysValidator;
import io.reactivexport.disposables.Disposable;
import io.reactivexport.functions.Consumer;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

public class SurveysManager
implements SurveysFetcher.Callback,
SurveysValidator.Callback,
CountryInfoResolver.CountryInfoResolverCallback {
    @Nullable
    private static SurveysManager singleton;
    private final WeakReference<Context> context;
    private final SurveysFetcher surveysFetcher;
    private SurveysValidator surveysValidator;
    @Nullable
    private Disposable triggerDisposable;
    private final CountryInfoResolver countryInfoResolver;
    private final TaskDebouncer networkTaskDebouncer;
    private final SurveysConfigurationsProvider configurationsProvider;
    @VisibleForTesting
    boolean hasTokenChanged;

    public void startFetching(final String string) {
        this.networkTaskDebouncer.debounce(new Runnable(){

            @Override
            public void run() {
                SurveysManager.this.fetchSurveys(string);
            }
        });
    }

    public void setHasTokenChanged(boolean bl) {
        this.hasTokenChanged = bl;
    }

    public void fetchImmediately(String string) {
        SurveysSettings.setLastFetchedAt(0L);
        this.fetchSurveys(string);
    }

    public void registerSurveysTriggerEvents() {
        Disposable disposable = this.triggerDisposable;
        if (disposable == null || disposable.isDisposed()) {
            this.triggerDisposable = UserEventsEventBus.getInstance().subscribe((Consumer)new Consumer<UserEvent>(){

                public void accept(UserEvent userEvent) {
                    if (!SurveysManager.this.canShowSurveys()) {
                        return;
                    }
                    if (userEvent instanceof SurveyTimerEvent) {
                        InstabugSDKLogger.v((String)"IBG-Surveys", (String)"Surveys auto showing is triggered");
                        SurveysManager.this.surveysValidator.showSurveysByTimeTriggerIfAvailable();
                    } else if (SurveysSettings.isSurveysAutoShowing() && userEvent.getEventIdentifier() != null) {
                        InstabugSDKLogger.v((String)"IBG-Surveys", (String)("Survey with event: {" + userEvent.getEventIdentifier() + "} is triggered"));
                        SurveysManager.this.surveysValidator.showSurveysByEventTriggerIfAvailable(userEvent.getEventIdentifier());
                    }
                }
            });
        }
    }

    public void unregisterSurveysTriggerEvents() {
        Disposable disposable = this.triggerDisposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.triggerDisposable.dispose();
        }
    }

    @SuppressLint(value={"THREAD_SAFETY_VIOLATION"})
    boolean showValidSurvey() {
        ParseException parseException2;
        block7: {
            block5: {
                block6: {
                    if (!Instabug.isEnabled()) {
                        InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Couldn't show survey because Instabug SDK is disabled.");
                        return false;
                    }
                    try {
                        if (!this.canShowSurveys()) break block5;
                    }
                    catch (ParseException parseException2) {}
                    com.instabug.survey.models.Survey survey = this.getFirstValidSurvey();
                    if (survey == null) break block6;
                    this.showSurvey(survey);
                    return true;
                    break block7;
                }
                return false;
            }
            return false;
        }
        InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Something went wrong while getting first valid survey", (Throwable)parseException2);
        return false;
    }

    @VisibleForTesting
    boolean canShowSurveys() {
        return InstabugStateProvider.getInstance().getState().equals(InstabugState.ENABLED) && SurveysUtils.isSurveysFeatureEnabled() && Instabug.isAppOnForeground() && !InstabugCore.isForegroundBusy() && this.configurationsProvider.isSurveysAvailableAndUsageNotExceeded() && !this.hasTokenChanged;
    }

    boolean showSurvey(String object) {
        if (this.canShowSurveys() && (object = this.getSurvey((String)object)) != null && !((com.instabug.survey.models.Survey)object).isPaused()) {
            this.showSurvey((com.instabug.survey.models.Survey)object);
            return true;
        }
        return false;
    }

    @Nullable
    @VisibleForTesting
    com.instabug.survey.models.Survey getSurvey(String string) {
        for (com.instabug.survey.models.Survey survey : SurveysCacheManager.getSurveys()) {
            if (survey.getToken() == null || !survey.getToken().equals(string)) continue;
            InstabugSDKLogger.d((String)"IBG-Surveys", (String)("Showing survey With token " + string));
            return survey;
        }
        InstabugSDKLogger.d((String)"IBG-Surveys", (String)("No Survey With token " + string));
        return null;
    }

    @Override
    public void onFetchingSucceeded(List<com.instabug.survey.models.Survey> list) {
        this.cacheLastRetrievedLocale();
        this.invalidateSurveyUserInteractions(list);
        this.invalidateCachedSurveys(list);
        this.migrateSurveys(list);
        if (!Instabug.isEnabled()) {
            return;
        }
        this.startAutomaticSurveyTrigger();
        this.hasTokenChanged = false;
    }

    @VisibleForTesting
    void cacheLastRetrievedLocale() {
        if (this.context.get() != null) {
            SurveysSettings.setLastFetchedLocaleCode(LocaleUtils.getCurrentLocaleResolved((Context)((Context)this.context.get())));
        }
    }

    @VisibleForTesting
    void invalidateCachedSurveys(List<com.instabug.survey.models.Survey> list) {
        for (com.instabug.survey.models.Survey survey : SurveysCacheManager.getSurveys()) {
            if (list.contains(survey)) continue;
            SurveysCacheManager.delete(survey.getId());
        }
    }

    @VisibleForTesting
    void invalidateSurveyUserInteractions(List<com.instabug.survey.models.Survey> list) {
        ArrayList<UserInteraction> arrayList;
        String string = UserManagerWrapper.getUserUUID();
        ArrayList<UserInteraction> arrayList2 = arrayList;
        arrayList = new ArrayList<UserInteraction>();
        for (Serializable serializable : SurveysCacheManager.getSurveys()) {
            if (list.contains(serializable) || (serializable = UserInteractionCacheManager.retrieveUserInteraction(serializable.getId(), string, 0)) == null) continue;
            arrayList2.add((UserInteraction)serializable);
        }
        if (!arrayList2.isEmpty()) {
            UserInteractionCacheManager.deleteBulkOfUserInteractions(arrayList2);
        }
    }

    @Override
    public void onFetchingFailed(Throwable throwable) {
        if (throwable.getMessage() != null) {
            InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Couldn't fetch surveys due to: " + throwable.getMessage()), (Throwable)throwable);
        }
        this.startAutomaticSurveyTrigger();
    }

    @WorkerThread
    @VisibleForTesting
    void migrateSurveys(List<com.instabug.survey.models.Survey> object) {
        object = object.iterator();
        while (object.hasNext()) {
            com.instabug.survey.models.Survey survey = (com.instabug.survey.models.Survey)object.next();
            if (SurveysCacheManager.isSurveyExisting(survey.getId())) {
                com.instabug.survey.models.Survey survey2 = SurveysCacheManager.getSurveyById(survey.getId());
                if (survey2 == null) continue;
                boolean bl = this.isPublishStatusChanged(survey, survey2);
                boolean bl2 = false;
                if (!survey.isPaused()) {
                    bl2 = this.isLocaleChanged(survey, survey2);
                }
                if (bl || bl2) {
                    SurveysCacheManager.insertOrUpdatePausedOrLocale(survey, bl, bl2);
                }
                if (!this.isFrequencyChanged(survey, survey2)) continue;
                com.instabug.survey.models.Survey survey3 = survey2;
                survey3.getTarget().setFrequency(survey.getTarget().getFrequency());
                SurveysCacheManager.updateSurveyTarget(survey3);
                continue;
            }
            if (survey.isPaused()) continue;
            SurveysCacheManager.addSurvey(survey);
        }
    }

    @VisibleForTesting
    void mergeUserInteraction(List<com.instabug.survey.models.Survey> list) {
        ArrayList<com.instabug.survey.models.Survey> arrayList;
        String string = UserManagerWrapper.getUserUUID();
        ArrayList<com.instabug.survey.models.Survey> arrayList2 = arrayList;
        arrayList = new ArrayList<com.instabug.survey.models.Survey>();
        for (com.instabug.survey.models.Survey survey : list) {
            UserInteraction userInteraction = UserInteractionCacheManager.retrieveUserInteraction(survey.getId(), string, 0);
            if (userInteraction == null) continue;
            survey.setUserInteraction(userInteraction);
            arrayList2.add(survey);
        }
        if (!list.isEmpty()) {
            SurveysCacheManager.updateBulk(arrayList2);
        }
    }

    @VisibleForTesting
    boolean isLocaleChanged(com.instabug.survey.models.Survey survey, com.instabug.survey.models.Survey survey2) {
        return survey.getLocalization().getCurrentLocale() != null && !survey.getLocalization().getCurrentLocale().equals(survey2.getLocalization().getCurrentLocale());
    }

    @VisibleForTesting
    boolean isFrequencyChanged(com.instabug.survey.models.Survey serializable, com.instabug.survey.models.Survey survey) {
        Frequency frequency = ((com.instabug.survey.models.Survey)serializable).getTarget().getFrequency();
        serializable = survey.getTarget().getFrequency();
        return frequency.getType() != ((Frequency)serializable).getType() || frequency.getDismissedReshowInterval() != ((Frequency)serializable).getDismissedReshowInterval() || frequency.getShowingInterval() != ((Frequency)serializable).getShowingInterval();
    }

    @VisibleForTesting
    boolean isPublishStatusChanged(com.instabug.survey.models.Survey survey, com.instabug.survey.models.Survey survey2) {
        return survey2.isPaused() != survey.isPaused();
    }

    boolean hasRespondToSurvey(String string) {
        if ((this = ((SurveysManager)this).getSurvey(string)) != null) {
            return ((com.instabug.survey.models.Survey)this).isAnswered();
        }
        InstabugSDKLogger.e((String)"IBG-Surveys", (String)("No survey with token:" + string + " was found."));
        return false;
    }

    public void updateDismissedSurveysSessionCount() {
        for (com.instabug.survey.models.Survey survey : SurveysCacheManager.getSurveys()) {
            if (!survey.isCancelled() || !survey.shouldShowAgain()) continue;
            com.instabug.survey.models.Survey survey2 = survey;
            survey2.incrementSessionCount();
            SurveysCacheManager.updateSessions(survey2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resolveCountryInfo(CountryInfo weakReference, boolean bl) {
        try {
            String string = SurveysSettings.getCountryInfo();
            long l = SurveysSettings.DEFAULT_COUNTRY_RESOLVER_INTERVAL;
            if (string != null && !string.trim().isEmpty()) {
                WeakReference<Context> weakReference2 = weakReference;
                ((CountryInfo)((Object)weakReference2)).fromJson(string);
                l = ((CountryInfo)((Object)weakReference2)).getTtl();
            }
            if (TimeUtils.currentTimeMillis() - SurveysSettings.getCountyInfoLastFetch() <= TimeUnit.DAYS.toMillis(l) && !bl) {
                this.onSuccess((CountryInfo)((Object)weakReference));
                return;
            }
            weakReference = this.context;
            if (weakReference == null) return;
        }
        catch (JSONException jSONException) {}
        if (weakReference.get() == null) return;
        this.countryInfoResolver.resolveCountryCode((Context)this.context.get());
        return;
        InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Can't resolve country info due to: " + jSONException.getMessage()));
    }

    synchronized void showSurveyWithId(long l) {
        if (SurveysCacheManager.getSurveyById(l) != null) {
            this.showSurvey(SurveysCacheManager.getSurveyById(l));
        }
    }

    List<Survey> getAvailableSurveys() {
        return this.surveysValidator.getValidSurveys();
    }

    @Override
    public synchronized void onTimeEventTrigger(@NonNull com.instabug.survey.models.Survey survey) {
        this.showSurvey(survey);
    }

    @Override
    public synchronized void onUserEventTrigger(@NonNull com.instabug.survey.models.Survey survey) {
        this.showSurvey(survey);
    }

    synchronized void release() {
        this.unregisterSurveysTriggerEvents();
        AutoShowingManager.getInstance().setAnnouncementShown(false);
        AutoShowingManager.getInstance().setSurveyShown(false);
        AutoShowingManager.getInstance().release();
        if (singleton != null) {
            singleton = null;
        }
    }

    @Override
    public void onSuccess(CountryInfo countryInfo) {
        try {
            CountryInfo countryInfo2 = countryInfo;
            SurveysSettings.setCountryInfo(countryInfo2.toJson());
            AnnouncementsSettings.setCountryInfo(countryInfo2.toJson());
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Can't update country info due to: " + jSONException.getMessage()));
        }
    }

    @Override
    public void onError(Throwable throwable) {
        InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Can't resolve country info due to: " + throwable.getMessage()));
    }

    void notifyLogout() {
        UserManagerWrapper.getUUIDAsync((InstabugDBInsertionListener)new InstabugDBInsertionListener<String>(){

            public void onDataInserted(String string) {
                List<com.instabug.survey.models.Survey> list = SurveysCacheManager.getSurveys();
                if (list != null && !list.isEmpty()) {
                    List<com.instabug.survey.models.Survey> list2 = list;
                    UserInteractionCacheManager.insertUserInteractions(list2, string);
                    SurveysCacheManager.resetSurveyUserInteraction(list2);
                }
            }
        });
    }

    void notifyUserLoggedIn() {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                List<com.instabug.survey.models.Survey> list = SurveysCacheManager.getSurveys();
                if (list != null && !list.isEmpty()) {
                    SurveysManager.this.mergeUserInteraction(list);
                }
            }
        });
    }

    public void notifyAppVersionChanged() {
        PoolProvider.postIOTask(() -> {
            SurveysValidator surveysValidator;
            Object object = (Context)this.context.get();
            if (object == null) {
                return;
            }
            SurveysValidator surveysValidator2 = surveysValidator;
            Context context = object;
            object = InstabugDeviceProperties.getAppVersionName((Context)context);
            String string = DeviceStateProvider.getAppVersion((Context)context);
            surveysValidator = new SurveysValidator(this, (String)object, string);
            this.surveysValidator = surveysValidator2;
            this.startAutomaticSurveyTrigger();
        });
    }

    private SurveysManager(@NonNull Context object) {
        SurveysManager surveysManager = this;
        surveysManager.configurationsProvider = ServiceLocator.getConfigurationsProvider();
        surveysManager.hasTokenChanged = false;
        surveysManager.context = new WeakReference<Context>((Context)object);
        surveysManager.surveysFetcher = new SurveysFetcher(this);
        Context context = object;
        object = InstabugDeviceProperties.getAppVersionName((Context)context);
        surveysManager.surveysValidator = new SurveysValidator(this, (String)object, DeviceStateProvider.getAppVersion((Context)context));
        surveysManager.countryInfoResolver = new CountryInfoResolver(this);
        surveysManager.networkTaskDebouncer = new TaskDebouncer(TimeUnit.MINUTES.toMillis(1L));
        surveysManager.registerSurveysTriggerEvents();
    }

    public static synchronized void init() {
        if (Instabug.getApplicationContext() == null) {
            return;
        }
        singleton = new SurveysManager(Instabug.getApplicationContext());
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static synchronized SurveysManager getInstance() {
        if (singleton == null) {
            SurveysManager.init();
        }
        return singleton;
    }

    private void fetchSurveys(String string) {
        block4: {
            if (string != null) {
                if (this.context.get() == null) break block4;
                try {
                    this.surveysFetcher.fetch((Context)this.context.get(), string);
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Couldn't fetch surveys due to: " + jSONException.getMessage()), (Throwable)jSONException);
                }
            }
        }
    }

    private void startAutomaticSurveyTrigger() {
        block4: {
            Thread.sleep(10000L);
            if (!SurveysSettings.isSurveysAutoShowing()) break block4;
            if (!Instabug.isAppOnForeground()) break block4;
            try {
                UserEventsEventBus.getInstance().post((Object)new SurveyTimerEvent());
            }
            catch (InterruptedException interruptedException) {
                if (interruptedException.getMessage() == null) break block4;
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Couldn't show survey because thread was interrupted");
            }
        }
    }

    @Nullable
    private com.instabug.survey.models.Survey getFirstValidSurvey() {
        return this.surveysValidator.getFirstValidSurvey();
    }

    private void showSurvey(@NonNull com.instabug.survey.models.Survey survey) {
        if (this.canShowSurveys()) {
            this.startSurveyActivity(survey);
        }
    }

    private void startSurveyActivity(@NonNull com.instabug.survey.models.Survey survey) {
        AutoShowingManager.getInstance().showSurvey(survey);
    }
}

