package com.instabug.survey.ui.survey.text.customized;

import android.os.Bundle;

import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.ui.SurveyActivity;
import com.instabug.survey.ui.SurveyActivityCallback;
import com.instabug.survey.ui.survey.SurveyFragmentCallbacks;
import com.instabug.survey.ui.survey.text.TextQuestionAbstractFragment;

/**
 * A custom implementation of {@link TextQuestionAbstractFragment} to allow submitting the survey if it was dismissed in the midway
 * See <a href="https://instabug.atlassian.net/browse/INSD-4569">[INSD-4569]</a>
 */

public class CustomizedTextQuestionFragment extends TextQuestionAbstractFragment {
    public static CustomizedTextQuestionFragment newInstance(boolean shouldChangeContainerHeight, Question question, SurveyFragmentCallbacks surveyFragmentCallbacks) {
        Bundle args = new Bundle();
        args.putSerializable(KEY_QUESTION_ARGUMENT, question);
        args.putBoolean(KEY_SHOULD_CHANGE_CONTAINER_HEIGHT_ARGUMENT, shouldChangeContainerHeight);
        CustomizedTextQuestionFragment fragment = new CustomizedTextQuestionFragment();
        fragment.setArguments(args);
        fragment.setSurveyFragmentCallbacks(surveyFragmentCallbacks);
        return fragment;
    }

    @Override
    public void close() {
        if (survey == null) {
            return;
        }
        if (SurveysSettings.isCustomizationEnabled()) {
            if (getActivity() instanceof SurveyActivityCallback) {
                if (question != null) {
                    question.setAnswer(null);
                }
                ((SurveyActivityCallback) getActivity()).submitSurvey(survey);
            }
        } else {
            if (getActivity() instanceof SurveyActivityCallback) {
                ((SurveyActivityCallback) getActivity()).dismissSurvey(survey);
            }
        }
    }

    public void handleCloseButtonClicked(Survey survey) {
        if (getActivity() != null && getActivity() instanceof SurveyActivity) {
            ((SurveyActivity) getActivity()).submitSurvey(survey);
        }
    }
}
