package com.instabug.survey.ui.popup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.google.android.gms.tasks.Task;
import com.google.android.play.core.review.ReviewInfo;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.Constants;
import com.instabug.survey.InAppRatingCallback;
import com.instabug.survey.InAppRatingRequestCallback;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.utils.PlayStoreUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Barakat on 06/01/2019
 */
public class PopupQuestionPresenter extends BasePresenter<PopupQuestionContract.View> implements
        PopupQuestionContract.Presenter {

    @NonNull
    private Survey survey;
    @Nullable
    ReviewInfo playReviewInfo = null;

    PopupQuestionPresenter(final PopupQuestionContract.View view, @NonNull Survey survey) {
        super(view);
        this.survey = survey;
        if (survey.isGooglePlayAppRating() && view.getViewContext() != null && view.getViewContext().getActivity() != null) {
            PlayStoreUtils.prepareInAppRating(view.getViewContext().getActivity(), new InAppRatingCallback() {
                @Override
                public void onSuccess(ReviewInfo reviewInfo) {
                    playReviewInfo = reviewInfo;
                    InstabugSDKLogger.d(Constants.LOG_TAG, "Google Play In-app review task succeeded");
                }

                @Override
                public void onFailure(Exception exception) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, "Requesting Google Play In-app review failed", exception);
                }
            });
        }
    }

    @Override
    public void showPrimaryQuestion() {
        if (survey == null) return;
        List<Question> questionList = survey.getQuestions();
        if (questionList != null && !questionList.isEmpty()) {
            final Question primaryQuestion = survey.getQuestions().get(0);
            final PopupQuestionContract.View viewRef = view.get();
            if (viewRef != null && primaryQuestion != null) {
                ArrayList<String> optionalAnswers = primaryQuestion.getOptionalAnswers();
                if (optionalAnswers != null && optionalAnswers.size() >= 2) {
                    viewRef.showPrimaryQuestion(null,
                            primaryQuestion.getTitle(),
                            optionalAnswers.get(0),
                            optionalAnswers.get(1));
                }
            }
        }
    }

    @VisibleForTesting
    void handleBetaAppAnswer() {
        List<Question> questionList = survey.getQuestions();
        if (questionList != null && !questionList.isEmpty()) {
            ArrayList<String> optionalAnswers = questionList.get(0).getOptionalAnswers();
            if (optionalAnswers != null && !optionalAnswers.isEmpty()) {
                questionList.get(0).setAnswer(
                        optionalAnswers.get(0));
                PopupQuestionContract.View viewRef = view.get();
                if (viewRef != null) {
                    viewRef.onBetaAppPrimaryQuestionAnswered(survey);
                }
            }

        }


    }

    @Override
    public void showPositiveSecondaryQuestion() {
        ArrayList<Question> questions = survey.getQuestions();
        if (questions != null && questions.size() >= 2) {
            Question positiveSecondaryQuestion = questions.get(1);
            final PopupQuestionContract.View viewRef = view.get();
            if (viewRef != null && positiveSecondaryQuestion != null
                    && positiveSecondaryQuestion.getOptionalAnswers() != null
                    && positiveSecondaryQuestion.getOptionalAnswers().size() >= 2) {
                viewRef.showAlertForPositiveSecondaryQuestion(null,
                        positiveSecondaryQuestion.getTitle(),
                        positiveSecondaryQuestion.getOptionalAnswers().get(0),
                        positiveSecondaryQuestion.getOptionalAnswers().get(1));

            }
        }
    }

    @Override
    public void showNegativeSecondaryQuestion() {
        // Set primary question's answer to the negative answer [index = 1]
        ArrayList<Question> questions = survey.getQuestions();
        if (questions != null && !questions.isEmpty()) {
            Question question = survey.getQuestions().get(0);
            if (question != null && question.getOptionalAnswers() != null
                    && question.getOptionalAnswers().size() >= 2) {
                question.setAnswer(
                        question.getOptionalAnswers().get(1));
                PopupQuestionContract.View viewRef = view.get();
                if (viewRef != null) {
                    viewRef.showNegativeSecondaryQuestion(survey);
                }
            }
        }

    }

    void positivePrimaryOptionClicked() {
        // Set primary question's answer to the positive answer [index = 0]
        ArrayList<String> optionalAnswers = survey.getQuestions().get(0).getOptionalAnswers();
        if (optionalAnswers != null) {
            survey.getQuestions().get(0).setAnswer(optionalAnswers.get(0));
        }
        if (SurveysSettings.isAppLive()) {
            if (!survey.isGooglePlayAppRating()) {
                showPositiveSecondaryQuestion();
            } else {
                submitSurvey();
                showGooglePlayInAppRating();
            }
        } else {
            handleBetaAppAnswer();
        }
    }

    @Override
    public void showGooglePlayInAppRating() {
        final PopupQuestionContract.View viewRef = view.get();
        if (viewRef != null
                && playReviewInfo != null
                && viewRef.getViewContext() != null
                && viewRef.getViewContext().getActivity() != null) {
            PlayStoreUtils.requestInAppRating(viewRef.getViewContext().getActivity(), playReviewInfo, new InAppRatingRequestCallback() {
                @Override
                public void onComplete(Task<Void> task) {
                    InstabugSDKLogger.d(Constants.LOG_TAG, "Google Play In-app review ready to show");
                }

                @Override
                public void onFailure(Exception exception) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, "Showing Google Play In-app review failed", exception);
                }
            });
        }
    }

    void positiveSecondaryOptionClicked() {
        List<Question> questionList = survey.getQuestions();
        if (questionList != null && questionList.size() >= 2) {
            ArrayList<String> optionalAnswers = survey.getQuestions().get(0).getOptionalAnswers();
            if (optionalAnswers != null && !optionalAnswers.isEmpty()) {
                // Set secondary question's answer to the positive answer [index = 0]
                if (survey.getQuestions().get(1).getOptionalAnswers() == null || survey.getQuestions().get(1).getOptionalAnswers().size() == 0)
                    return;
                survey.getQuestions().get(1).setAnswer(
                        survey.getQuestions().get(1).getOptionalAnswers().get(0));
            }
        }

        survey.addRateEvent();
        PopupQuestionContract.View viewRef = view.get();
        if (viewRef != null) {
            viewRef.onPositiveSecondaryQuestionPositiveResponse(survey);
        }
    }

    void negativeSecondaryOptionClicked() {
        List<Question> questionList = survey.getQuestions();
        if (questionList != null && questionList.size() >= 2) {
            ArrayList<String> optionalAnswers = survey.getQuestions().get(0).getOptionalAnswers();
            if (optionalAnswers != null && optionalAnswers.size() >= 2) {

                if (survey.getQuestions().get(1).getOptionalAnswers() == null || survey.getQuestions().get(1).getOptionalAnswers().size() == 0)
                    return;

                // Set secondary question's answer to the negative answer [index = 1]
                survey.getQuestions().get(1).setAnswer(
                        survey.getQuestions().get(1).getOptionalAnswers().get(1));
                PopupQuestionContract.View viewRef = view.get();
                if (viewRef != null) {
                    viewRef.onPositiveSecondaryQuestionNegativeResponse(survey);
                }
            }
        }
    }

    @Override
    public void dismissSurvey() {
        PopupQuestionContract.View viewRef = view.get();
        if (viewRef != null && survey != null) {
            viewRef.dismissSurvey(survey);
        }
    }

    @Override
    public void submitSurvey() {
        PopupQuestionContract.View viewRef = view.get();
        if (viewRef != null && survey != null) {
            viewRef.submitSurvey(survey);
        }
    }
}
