package com.instabug.survey.ui;

import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;

/**
 * Created by zak on 1/30/18.
 */

public class SurveysAnimations {
    public static void appearAnimation(ImageView button) {
        AnimationSet animationSet = new AnimationSet(true);
        final Animation translateAnimation = new TranslateAnimation(-30, button.getTranslationX(), 0, 0);
        translateAnimation.setDuration(300);
        translateAnimation.setFillAfter(true);
        animationSet.addAnimation(translateAnimation);

        Animation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        alphaAnimation.setDuration(200);
        alphaAnimation.setFillAfter(true);
        animationSet.addAnimation(alphaAnimation);

        button.startAnimation(animationSet);
        button.setVisibility(View.VISIBLE);
    }

    public static void hideAnimation(ImageView backButton) {
        AnimationSet animationSet = new AnimationSet(true);
        final Animation translateAnimation = new TranslateAnimation(backButton.getTranslationX(), -30, 0, 0);
        translateAnimation.setDuration(300);
        translateAnimation.setFillAfter(false);
        animationSet.addAnimation(translateAnimation);

        Animation alphaAnimation = new AlphaAnimation(1.0f, 0f);
        alphaAnimation.setDuration(200);
        alphaAnimation.setFillAfter(true);
        animationSet.addAnimation(alphaAnimation);

        backButton.startAnimation(animationSet);
        backButton.setVisibility(View.INVISIBLE);
    }
}
