package com.instabug.survey.announcements.ui.fragment;

import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;

import androidx.annotation.Nullable;

import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.models.AnnouncementItem;
import com.instabug.survey.announcements.ui.activity.AnnouncementActivity;
import com.instabug.survey.ui.gestures.GesturesHandler;

/**
 * Created by Barakat on 29/12/2018
 */
public abstract class AnnouncementItemFragment<P extends BaseContract.Presenter> extends InstabugBaseFragment<P> {
    protected static final String KEY_ANNOUNCE_ARGUMENT = "announcement_item";
    @Nullable
    protected AnnouncementItem announcementItem;
    @Nullable
    protected RelativeLayout container;
    @Nullable
    protected Announcement announcement;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        if (getActivity() instanceof AnnouncementActivity) {
            announcement = ((AnnouncementActivity) getActivity()).getAnnouncement();
        }
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        if (getActivity() instanceof AnnouncementActivity) {
            ((AnnouncementActivity) getActivity()).setBackgroundTransparent(false);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        // should reset this
        GesturesHandler.reset();
    }

    @Override
    public void onDestroy() {
        container = null;
        GesturesHandler.destroy();
        super.onDestroy();
    }

}
