/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.BuildFieldsProvider;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ObjectMapper;
import com.instabug.library.util.StringUtility;
import com.instabug.library.util.TimeUtils;
import com.instabug.survey.Survey;
import com.instabug.survey.cache.SurveysCacheManager;
import com.instabug.survey.cache.SurveysDbHelper;
import com.instabug.survey.common.models.Condition;
import com.instabug.survey.models.CountryInfo;
import com.instabug.survey.settings.PerSessionSettings;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.utils.DateUtils;
import com.instabug.survey.utils.FrequencyProcessor;
import com.instabug.survey.utils.ValidationUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SurveysValidator {
    private Callback callback;
    @Deprecated
    @Nullable
    private String appVersionName;
    private String appVersionAndCodeName;

    public SurveysValidator(Callback callback, @Nullable String string2, String string3) {
        this.callback = callback;
        this.appVersionName = string2;
        this.appVersionAndCodeName = string3;
    }

    @NonNull
    private List<com.instabug.survey.models.Survey> getAllValidSurveys(List<com.instabug.survey.models.Survey> list) {
        ArrayList<com.instabug.survey.models.Survey> arrayList;
        int n = list == null ? 0 : list.size();
        this.log("getAllValidSurveys(availableSurveys: " + n + ")");
        ArrayList<com.instabug.survey.models.Survey> arrayList2 = arrayList;
        arrayList = new ArrayList<com.instabug.survey.models.Survey>();
        if (list != null) {
            for (com.instabug.survey.models.Survey survey : list) {
                if (survey.isOptInSurvey() || survey.isPaused() || !this.checkSurveyValidity(survey) || !new FrequencyProcessor().isFrequentSurvey(survey)) continue;
                arrayList2.add(survey);
            }
            this.log("validSurveys: " + arrayList2.size());
            Collections.sort(list, new Comparator<com.instabug.survey.models.Survey>(){

                @Override
                public int compare(com.instabug.survey.models.Survey survey, com.instabug.survey.models.Survey survey2) {
                    return Long.compare(survey.getDismissedAt(), survey2.getDismissedAt());
                }
            });
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateOSApiLevel(Condition condition) {
        int n;
        int n2;
        int n3;
        block17: {
            String string2;
            block14: {
                block15: {
                    block16: {
                        int n4;
                        SurveysValidator surveysValidator = this;
                        n3 = BuildFieldsProvider.INSTANCE.provideBuildVersion();
                        surveysValidator.log("validateOSApiLevel(condition: " + condition + ")");
                        surveysValidator.log("Build.VERSION.SDK_INT: " + n3);
                        try {
                            if (condition.getValue() == null) return false;
                            if (condition.getOperator() == null) return false;
                            Condition condition2 = condition;
                            n2 = Integer.parseInt(condition2.getValue());
                            string2 = condition2.getOperator();
                            n = -1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return ValidationUtils.onParseException(condition, numberFormatException);
                        }
                        {
                            n4 = string2.hashCode();
                            if (n4 == -1374681402) break block14;
                            if (n4 == 96757556) break block15;
                            if (n4 == 365984903) break block16;
                        }
                        if (n4 == 1614662344 && string2.equals("not_equal")) {
                            n = 1;
                        }
                        break block17;
                    }
                    if (string2.equals("less_than")) {
                        n = 3;
                    }
                    break block17;
                }
                if (string2.equals("equal")) {
                    n = 0;
                }
                break block17;
            }
            if (string2.equals("greater_than")) {
                n = 2;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 3: {
                if (n3 >= n2) return false;
                return true;
            }
            case 2: {
                if (n3 <= n2) return false;
                return true;
            }
            case 1: {
                if (n3 == n2) return false;
                return true;
            }
            case 0: 
        }
        if (n3 != n2) return false;
        return true;
    }

    @Nullable
    private String extractVersion(@Nullable String string2) {
        if (string2 == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("\\d+(\\.\\d+)*").matcher(string2);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkDaysSinceDismissCondition(Condition condition, long l) {
        int n;
        int n2;
        int n3;
        block19: {
            String string2;
            block16: {
                block17: {
                    block18: {
                        int n4;
                        this.log("checkDaysSinceDismissCondition(condition: " + condition + ", lastDismissDate: " + l + ")");
                        if (condition.getValue() == null) return false;
                        if (condition.getOperator() == null) {
                            return false;
                        }
                        if (l == 0L) {
                            return true;
                        }
                        try {
                            n3 = Integer.parseInt(condition.getValue());
                            n2 = DateUtils.getDifferenceInDays(l);
                            string2 = condition.getOperator();
                            n = -1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return ValidationUtils.onParseException(condition, numberFormatException);
                        }
                        {
                            n4 = string2.hashCode();
                            if (n4 == -1374681402) break block16;
                            if (n4 == 96757556) break block17;
                            if (n4 == 365984903) break block18;
                        }
                        if (n4 == 1614662344 && string2.equals("not_equal")) {
                            n = 1;
                        }
                        break block19;
                    }
                    if (string2.equals("less_than")) {
                        n = 3;
                    }
                    break block19;
                }
                if (string2.equals("equal")) {
                    n = 0;
                }
                break block19;
            }
            if (string2.equals("greater_than")) {
                n = 2;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 3: {
                if (n2 >= n3) return false;
                return true;
            }
            case 2: {
                if (n2 <= n3) return false;
                return true;
            }
            case 1: {
                if (n2 == n3) return false;
                return true;
            }
            case 0: 
        }
        if (n2 != n3) return false;
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkSessionCountCondition(Condition condition, int n) {
        int n2;
        int n3;
        block18: {
            String string2;
            block15: {
                block16: {
                    block17: {
                        int n4;
                        this.log("checkDaysSinceDismissCondition(condition: " + condition + ", actualSessionCount: " + n + ")");
                        if (condition.getValue() == null) return false;
                        if (condition.getOperator() == null) {
                            return false;
                        }
                        try {
                            Condition condition2 = condition;
                            n3 = Integer.parseInt(condition2.getValue());
                            string2 = condition2.getOperator();
                            n2 = -1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return ValidationUtils.onParseException(condition, numberFormatException);
                        }
                        {
                            n4 = string2.hashCode();
                            if (n4 == -1374681402) break block15;
                            if (n4 == 96757556) break block16;
                            if (n4 == 365984903) break block17;
                        }
                        if (n4 == 1614662344 && string2.equals("not_equal")) {
                            n2 = 1;
                        }
                        break block18;
                    }
                    if (string2.equals("less_than")) {
                        n2 = 3;
                    }
                    break block18;
                }
                if (string2.equals("equal")) {
                    n2 = 0;
                }
                break block18;
            }
            if (string2.equals("greater_than")) {
                n2 = 2;
            }
        }
        switch (n2) {
            default: {
                return false;
            }
            case 3: {
                if (n >= n3) return false;
                return true;
            }
            case 2: {
                if (n <= n3) return false;
                return true;
            }
            case 1: {
                if (n == n3) return false;
                return true;
            }
            case 0: 
        }
        if (n != n3) return false;
        return true;
    }

    private boolean validateDaysSinceSignup(Condition condition) {
        return this.checkDaysSinceSignUpCondition(condition);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkDaysSinceSignUpCondition(Condition condition) {
        int n;
        int n2;
        int n3;
        block18: {
            String string2;
            block15: {
                block16: {
                    block17: {
                        int n4;
                        this.log("checkDaysSinceSignUpCondition(condition: " + condition + ")");
                        if (condition.getValue() == null) return false;
                        if (condition.getOperator() == null) {
                            return false;
                        }
                        try {
                            n3 = Integer.parseInt(condition.getValue());
                            n2 = DateUtils.getDifferenceInDays(InstabugCore.getFirstRunAt());
                            this.log("actualDifferenceInDays: " + n2);
                            string2 = condition.getOperator();
                            n = -1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return ValidationUtils.onParseException(condition, numberFormatException);
                        }
                        {
                            n4 = string2.hashCode();
                            if (n4 == -1374681402) break block15;
                            if (n4 == 96757556) break block16;
                            if (n4 == 365984903) break block17;
                        }
                        if (n4 == 1614662344 && string2.equals("not_equal")) {
                            n = 1;
                        }
                        break block18;
                    }
                    if (string2.equals("less_than")) {
                        n = 3;
                    }
                    break block18;
                }
                if (string2.equals("equal")) {
                    n = 0;
                }
                break block18;
            }
            if (string2.equals("greater_than")) {
                n = 2;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 3: {
                if (n2 >= n3) return false;
                return true;
            }
            case 2: {
                if (n2 <= n3) return false;
                return true;
            }
            case 1: {
                if (n2 == n3) return false;
                return true;
            }
            case 0: 
        }
        if (n2 != n3) return false;
        return true;
    }

    private int getDifferenceDays(long l, long l2) {
        return (int)TimeUnit.DAYS.convert(l2 - l, TimeUnit.MILLISECONDS);
    }

    private void log(String string2) {
        InstabugSDKLogger.i((String)"IBG-Surveys", (String)("SurveysValidator: " + string2));
    }

    public void showSurveysByEventTriggerIfAvailable(String string2) {
        this.log("showSurveysByEventTriggerIfAvailable(triggerEvent: " + string2 + ")");
        Object object = SurveysDbHelper.retrieveByTriggerEvent(string2);
        this.log("eventTriggeredSurveys: " + object.size());
        if (object.size() > 0) {
            SurveysValidator surveysValidator = this;
            object = surveysValidator.getAllValidSurveys((List<com.instabug.survey.models.Survey>)object);
            surveysValidator.log("validSurveys: " + object.size());
            object = object.size() > 0 ? object.get(0) : null;
            if (object == null) {
                this.log("no valid surveys for the event" + string2 + ". Returning null");
            } else {
                SurveysValidator surveysValidator2 = this;
                surveysValidator2.log("Survey with id:{ " + ((com.instabug.survey.models.Survey)object).getId() + "} is first valid survey for the event" + string2);
                surveysValidator2.callback.onUserEventTrigger((com.instabug.survey.models.Survey)object);
            }
        }
    }

    public void showSurveysByTimeTriggerIfAvailable() {
        SurveysValidator surveysValidator = this;
        surveysValidator.log("showSurveysByTimeTriggerIfAvailable()");
        Object object = SurveysCacheManager.getTimeTriggeredSurveys();
        surveysValidator.log("timeTriggeredSurveys: " + object.size());
        object = surveysValidator.getAllValidSurveys((List<com.instabug.survey.models.Survey>)object);
        surveysValidator.log("validSurveys: " + object.size());
        object = object.size() > 0 ? object.get(0) : null;
        if (object == null) {
            this.log("no valid time-triggered surveys. Returning null...");
        } else {
            SurveysValidator surveysValidator2 = this;
            surveysValidator2.log("Survey with id:{ " + ((com.instabug.survey.models.Survey)object).getId() + "}  is first valid survey for time-triggered surveys");
            surveysValidator2.callback.onTimeEventTrigger((com.instabug.survey.models.Survey)object);
        }
    }

    @Nullable
    public com.instabug.survey.models.Survey getFirstValidSurvey() {
        SurveysValidator surveysValidator = this;
        surveysValidator.log("getFirstValidSurvey()");
        Object object = SurveysCacheManager.getTimeTriggeredSurveys();
        surveysValidator.log("timeTriggeredSurveys: " + object.size());
        List<com.instabug.survey.models.Survey> list = surveysValidator.getAllValidSurveys((List<com.instabug.survey.models.Survey>)object);
        surveysValidator.log("timeTriggeredSurveys: " + object.size());
        object = list.size() > 0 ? list.get(0) : null;
        if (object == null) {
            this.log("no valid surveys. Returning null...");
        } else {
            this.log("Survey with id:{ " + ((com.instabug.survey.models.Survey)object).getId() + "}  is first valid survey");
        }
        return object;
    }

    @VisibleForTesting
    boolean checkSurveyValidity(com.instabug.survey.models.Survey survey) {
        ((SurveysValidator)((Object)arrayList)).log("checkSurveyValidity(survey: " + survey + ")");
        if (survey.getType() == 2 && !survey.isGooglePlayAppRating() && !PerSessionSettings.getInstance().isLiveAppRequested()) {
            return false;
        }
        if (survey.getType() == 1 && !PerSessionSettings.getInstance().isLiveAppRequested()) {
            return false;
        }
        SurveysValidator surveysValidator = arrayList;
        SurveysValidator surveysValidator2 = arrayList;
        SurveysValidator surveysValidator3 = arrayList;
        com.instabug.survey.models.Survey survey2 = survey;
        ArrayList<Condition> arrayList = survey2.getTargetAudiences();
        String string2 = survey2.getConditionsOperator();
        long l = survey2.getDismissedAt();
        boolean bl = surveysValidator3.checkPrimitiveTypes(arrayList, string2, l);
        surveysValidator3.log("primitiveTypesValidity: " + bl);
        boolean bl2 = ValidationUtils.checkCustomAttributesConditions(survey.getCustomAttributes(), survey.getConditionsOperator());
        surveysValidator2.log("customAttributesValidity: " + bl2);
        boolean bl3 = ValidationUtils.checkUserEvents(survey.getUserEvents(), survey.getConditionsOperator());
        surveysValidator.log("userEventsValidity: " + bl3);
        if ((survey.getUserEvents() == null || survey.getUserEvents().size() <= 0) && survey.getCustomAttributes().size() <= 0 && survey.getTargetAudiences().size() <= 0) {
            return true;
        }
        if ("or".equals(survey.getConditionsOperator())) {
            return bl || bl2 || bl3;
        }
        return bl && bl2 && bl3;
    }

    @VisibleForTesting
    boolean checkPrimitiveTypes(ArrayList<Condition> arrayList, String string2, long l) {
        int n = arrayList == null ? 0 : arrayList.size();
        this.log("checkPrimitiveTypes(primitiveTypesConditions: " + n + ", conditionsOperator: " + string2 + ", dismissedAt: " + l + ")");
        boolean bl = string2.equals("and");
        for (int i = 0; i < n; ++i) {
            boolean bl2 = this.checkPrimitiveType(arrayList.get(i), l);
            if (i == 0) {
                bl = bl2;
                continue;
            }
            if ("or".equals(string2)) {
                bl |= bl2;
                continue;
            }
            bl &= bl2;
        }
        return bl;
    }

    @VisibleForTesting
    boolean checkPrimitiveType(Condition condition, long l) {
        this.log("checkPrimitiveType(primitiveTypeCondition: " + condition + ", dismissedAt: " + l + ")");
        if (condition.getKey() == null) {
            return false;
        }
        String string2 = condition.getKey();
        string2.hashCode();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 2013274756: {
                if (!string2.equals("last_seen")) break;
                n = 9;
                break;
            }
            case 1905908461: {
                if (!string2.equals("sessions_count")) break;
                n = 8;
                break;
            }
            case 1694233633: {
                if (!string2.equals("app_version_v2")) break;
                n = 7;
                break;
            }
            case 1421955229: {
                if (!string2.equals("days_since_dismiss")) break;
                n = 6;
                break;
            }
            case 957831062: {
                if (!string2.equals("country")) break;
                n = 5;
                break;
            }
            case 96619420: {
                if (!string2.equals("email")) break;
                n = 4;
                break;
            }
            case 3076014: {
                if (!string2.equals("date")) break;
                n = 3;
                break;
            }
            case -12379384: {
                if (!string2.equals("android_version")) break;
                n = 2;
                break;
            }
            case -901870406: {
                if (!string2.equals("app_version")) break;
                n = 1;
                break;
            }
            case -1464712027: {
                if (!string2.equals("days_since_signup")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 9: {
                return this.checkLastSeenTimestamp(condition);
            }
            case 8: {
                return this.validateSessionCount(condition, SettingsManager.getInstance().getSessionsCount());
            }
            case 7: {
                return this.validateAppVersionV2(condition);
            }
            case 6: {
                return this.validateDaysSinceDismiss(condition, l);
            }
            case 5: {
                return this.validateCountryCode(condition, (CountryInfo)ObjectMapper.fromJson((String)SurveysSettings.getCountryInfo(), CountryInfo.class));
            }
            case 4: {
                return this.validateUserEmail(condition);
            }
            case 3: {
                return this.validateCurrentDate(condition);
            }
            case 2: {
                return this.checkOSApiLevel(condition);
            }
            case 1: {
                return this.validateAppVersion(condition);
            }
            case 0: 
        }
        return this.validateDaysSinceSignup(condition);
    }

    public boolean checkOSApiLevel(Condition condition) {
        return this.validateOSApiLevel(condition);
    }

    @VisibleForTesting
    public boolean validateCountryCode(Condition condition, @Nullable CountryInfo countryInfo) {
        ((SurveysValidator)((Object)string2)).log("validateOSApiLevel(primitiveTypeCondition: " + condition + ", countryInfo: " + countryInfo + ")");
        if (countryInfo != null && condition != null) {
            String string2 = countryInfo.getCountryCode();
            if ("equal".equals(condition.getOperator()) && condition.getValue() != null) {
                return condition.getValue().equalsIgnoreCase(string2);
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @VisibleForTesting
    boolean validateAppVersion(Condition condition) {
        int n;
        int n2;
        block18: {
            String string2;
            block16: {
                block17: {
                    this.log("validateAppVersion(condition: " + condition + ")");
                    string2 = condition.getOperator();
                    if (string2 == null) {
                        return false;
                    }
                    if (string2.equals("equal")) return ValidationUtils.checkStringCondition(condition, this.appVersionName);
                    if (string2.equals("not_equal")) return ValidationUtils.checkStringCondition(condition, this.appVersionName);
                    String string3 = this.extractVersion(condition.getValue());
                    SurveysValidator surveysValidator = this;
                    String string4 = surveysValidator.extractVersion(surveysValidator.appVersionName);
                    surveysValidator.log("appVersionName: " + this.appVersionName + ", currentVersionName: " + string4);
                    if (string3 == null) return ValidationUtils.checkStringCondition(condition, this.appVersionName);
                    if (string4 == null) return ValidationUtils.checkStringCondition(condition, this.appVersionName);
                    try {
                        n2 = StringUtility.compareVersion((String)string4, (String)string3);
                        n = -1;
                        int n3 = string2.hashCode();
                        if (n3 == -1374681402) break block16;
                        if (n3 == 96757556) break block17;
                        if (n3 != 365984903) {
                            if (n3 == 1614662344 && string2.equals("not_equal")) {
                                n = 1;
                            }
                            break block18;
                        }
                        if (string2.equals("less_than")) {
                            n = 3;
                        }
                        break block18;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                if (string2.equals("equal")) {
                    n = 0;
                }
                break block18;
            }
            if (string2.equals("greater_than")) {
                n = 2;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 3: {
                if (n2 != -1) return false;
                return true;
            }
            case 2: {
                if (n2 != 1) return false;
                return true;
            }
            case 1: {
                if (n2 == 0) return false;
                return true;
            }
            case 0: 
        }
        if (n2 != 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean validateAppVersionV2(Condition condition) {
        int n;
        long l;
        long l2;
        String string2;
        block12: {
            this.log("validateAppVersion(condition: " + condition + ")");
            string2 = condition.getOperator();
            if (string2 == null) return false;
            if (condition.getValue() == null) {
                return false;
            }
            if (!string2.equals("greater_than")) {
                if (!string2.equals("less_than")) return ValidationUtils.checkStringCondition(condition, this.appVersionAndCodeName);
            }
            try {
                l2 = Long.parseLong(condition.getValue());
                l = SurveysSettings.getFirstSeen();
                if (l2 == -1L) return false;
                if (l == -1L) {
                    return false;
                }
                n = -1;
                int n2 = string2.hashCode();
                if (n2 == -1374681402) break block12;
                if (n2 == 365984903 && string2.equals("less_than")) {
                    n = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (string2.equals("greater_than")) {
            n = 0;
        }
        if (n != 0) {
            if (n != 1) {
                return false;
            }
            if (l >= l2) return false;
            return true;
        }
        if (l <= l2) return false;
        return true;
    }

    @VisibleForTesting
    boolean validateCurrentDate(Condition condition) {
        Date date;
        SurveysValidator surveysValidator = date2;
        Date date2 = date;
        date = new Date();
        return surveysValidator.checkDateCondition(condition, date2);
    }

    @VisibleForTesting
    boolean checkDateCondition(Condition serializable, Date object) {
        ((SurveysValidator)object2).log("checkDateCondition(condition: " + serializable + ", actualDate: " + object + ")");
        if (((Condition)serializable).getValue() != null && object != null && ((Condition)serializable).getOperator() != null) {
            Object object2 = InstabugDateFormatter.getDate((String)((Condition)serializable).getValue());
            if (object2 != null) {
                Condition condition = serializable;
                object2 = InstabugDateFormatter.getStandardizedDate((Date)object2);
                serializable = InstabugDateFormatter.getStandardizedDate((Date)object);
                object = condition.getOperator();
                ((String)object).hashCode();
                int n = -1;
                switch (((String)object).hashCode()) {
                    default: {
                        break;
                    }
                    case 1614662344: {
                        if (!((String)object).equals("not_equal")) break;
                        n = 3;
                        break;
                    }
                    case 365984903: {
                        if (!((String)object).equals("less_than")) break;
                        n = 2;
                        break;
                    }
                    case 96757556: {
                        if (!((String)object).equals("equal")) break;
                        n = 1;
                        break;
                    }
                    case -1374681402: {
                        if (!((String)object).equals("greater_than")) break;
                        n = 0;
                    }
                }
                switch (n) {
                    default: {
                        return false;
                    }
                    case 3: {
                        return ((Date)serializable).getDate() != ((Date)object2).getDate();
                    }
                    case 2: {
                        return ((Date)serializable).before((Date)object2);
                    }
                    case 1: {
                        return ((Date)serializable).getDate() == ((Date)object2).getDate();
                    }
                    case 0: 
                }
                return ((Date)serializable).after((Date)object2);
            }
            return false;
        }
        return false;
    }

    @VisibleForTesting
    boolean validateUserEmail(Condition condition) {
        return ValidationUtils.checkStringCondition(condition, InstabugCore.getIdentifiedUserEmail());
    }

    @VisibleForTesting
    boolean validateDaysSinceDismiss(Condition condition, Long l) {
        return this.checkDaysSinceDismissCondition(condition, l);
    }

    @VisibleForTesting
    public boolean validateSessionCount(Condition condition, int n) {
        return this.checkSessionCountCondition(condition, n);
    }

    public boolean checkLastSeenTimestamp(Condition condition) {
        if (condition.getValue() != null && condition.getOperator() != null) {
            SurveysValidator surveysValidator = string2;
            long l = Long.parseLong(condition.getValue());
            long l2 = surveysValidator.getDifferenceDays(surveysValidator.getLastSeenTimestamp(), TimeUtils.currentTimeMillis());
            surveysValidator.log("checkUserEvent(condition: " + condition + ", daysSinceLastSeen: " + l2 + ")");
            String string2 = condition.getOperator();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1614662344: {
                    if (!string2.equals("not_equal")) break;
                    n = 3;
                    break;
                }
                case 365984903: {
                    if (!string2.equals("less_than")) break;
                    n = 2;
                    break;
                }
                case 96757556: {
                    if (!string2.equals("equal")) break;
                    n = 1;
                    break;
                }
                case -1374681402: {
                    if (!string2.equals("greater_than")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    return false;
                }
                case 3: {
                    return l2 != l;
                }
                case 2: {
                    return l2 < l;
                }
                case 1: {
                    return l2 == l;
                }
                case 0: 
            }
            return l2 > l;
        }
        return false;
    }

    @VisibleForTesting
    public long getLastSeenTimestamp() {
        return InstabugCore.getLastSeenTimestamp();
    }

    public List<Survey> getValidSurveys() {
        LinkedList linkedList;
        Object object;
        Object object2;
        block10: {
            object2 = SurveysCacheManager.getTimeTriggeredSurveys();
            object = null;
            try {
                object = this.getAllValidSurveys((List<com.instabug.survey.models.Survey>)object2);
            }
            catch (ParseException parseException) {
                object2 = parseException;
                if (parseException.getMessage() == null) break block10;
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Error:" + ((Throwable)object2).getMessage() + "while getting valid surveys"), (Throwable)object2);
            }
        }
        object2 = linkedList;
        linkedList = new LinkedList();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Survey survey;
                Object object3 = (com.instabug.survey.models.Survey)object.next();
                try {
                    if (!this.checkSurveyValidity((com.instabug.survey.models.Survey)object3)) continue;
                }
                catch (ParseException parseException) {
                    if (parseException.getMessage() == null) continue;
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Error:" + parseException.getMessage() + "while getting valid surveys"), (Throwable)parseException);
                    continue;
                }
                Object object4 = object2;
                Survey survey2 = survey;
                com.instabug.survey.models.Survey survey3 = object3;
                com.instabug.survey.models.Survey survey4 = survey3;
                long l = survey3.getId();
                object3 = survey4.getTitle();
                survey = new Survey(l, (String)object3);
                ((LinkedList)object4).add(survey2);
            }
        }
        return object2;
    }

    public static interface Callback {
        public void onTimeEventTrigger(@NonNull com.instabug.survey.models.Survey var1);

        public void onUserEventTrigger(@NonNull com.instabug.survey.models.Survey var1);
    }
}

