/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey.text;

import android.app.Activity;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.ui.survey.QuestionFragment;
import com.instabug.survey.ui.survey.SurveyFragmentCallbacks;
import com.instabug.survey.ui.survey.text.TextQuestionFragment;
import com.instabug.survey.utils.KeyboardUtils;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public abstract class TextQuestionAbstractFragment
extends QuestionFragment
implements TextWatcher {
    @Nullable
    protected EditText answerEditText;
    @Nullable
    private Runnable startTextWatcherRunnable;

    public static TextQuestionAbstractFragment newInstance(boolean bl, Question question, SurveyFragmentCallbacks surveyFragmentCallbacks) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putSerializable("question", (Serializable)question);
        bundle2.putBoolean("should_change_container_height", bl);
        TextQuestionFragment textQuestionFragment = new TextQuestionFragment();
        textQuestionFragment.setArguments(bundle2);
        textQuestionFragment.setSurveyFragmentCallbacks(surveyFragmentCallbacks);
        return textQuestionFragment;
    }

    private void handleSelectedAnswer(Question question) {
        if (question.getAnswer() != null && !question.getAnswer().isEmpty() && (this = this.answerEditText) != null) {
            this.setText(question.getAnswer());
        }
    }

    protected int getLayout() {
        return R.layout.instabug_dialog_text_survey;
    }

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        TextQuestionAbstractFragment textQuestionAbstractFragment = this;
        super.onCreate(bundle);
        textQuestionAbstractFragment.setRetainInstance(true);
        if (textQuestionAbstractFragment.getArguments() != null) {
            this.question = (Question)this.getArguments().getSerializable("question");
        }
    }

    @Override
    @CallSuper
    protected void initViews(View view, @Nullable Bundle bundle) {
        super.initViews(view, bundle);
        this.questionTextView = (TextView)view.findViewById(R.id.instabug_text_view_question);
        view = (EditText)view.findViewById(R.id.instabug_edit_text_answer);
        this.answerEditText = view;
        if (view != null) {
            View view2 = view;
            view2.getLayoutParams().height = this.getResources().getDimensionPixelSize(R.dimen.question_answer_text_height);
            ((RelativeLayout.LayoutParams)view2.getLayoutParams()).bottomMargin = 10;
            this.handleTextViewMaxLines();
        }
    }

    public void onViewCreated(@NotNull View object, @Nullable Bundle bundle) {
        super.onViewCreated(object, bundle);
        object.setFocusableInTouchMode(true);
        object = this.question;
        if (object != null) {
            this.showTextQuestion((Question)object);
        }
    }

    public void showTextQuestion(Question object) {
        TextQuestionAbstractFragment textQuestionAbstractFragment = this;
        final EditText editText = textQuestionAbstractFragment.answerEditText;
        TextView textView = textQuestionAbstractFragment.questionTextView;
        if (textView != null && editText != null) {
            Runnable runnable;
            String string2 = null;
            if (((Question)object).getTitle() != null) {
                string2 = this.getQuestionTitle(((Question)object).getTitle());
            }
            if (string2 != null) {
                textView.setText((CharSequence)string2);
                ViewCompat.setLabelFor((View)textView, (int)editText.getId());
            }
            Question question = object;
            editText.setHint((CharSequence)this.getLocalizedString(R.string.instabug_str_hint_enter_your_answer));
            object = runnable;
            this.startTextWatcherRunnable = new Runnable(){

                @Override
                public void run() {
                    editText.addTextChangedListener((TextWatcher)TextQuestionAbstractFragment.this);
                }
            };
            editText.postDelayed((Runnable)object, 200L);
            this.handleSelectedAnswer(question);
            return;
        }
    }

    protected String getQuestionTitle(String string2) {
        return string2;
    }

    @Override
    @Nullable
    public String getAnswer() {
        EditText editText = this.answerEditText;
        if (editText != null && !editText.getText().toString().trim().equals("")) {
            return this.answerEditText.getText().toString();
        }
        return null;
    }

    public void showKeyboard() {
        EditText editText;
        if (this.getActivity() != null && (editText = this.answerEditText) != null) {
            editText.requestFocus();
            KeyboardUtils.showKeyboard((Activity)this.getActivity(), this.answerEditText);
        }
    }

    public void onDestroyView() {
        TextQuestionAbstractFragment textQuestionAbstractFragment = this;
        super.onDestroyView();
        EditText editText = textQuestionAbstractFragment.answerEditText;
        if (editText != null) {
            editText.removeTextChangedListener((TextWatcher)this);
            Runnable runnable = this.startTextWatcherRunnable;
            if (runnable != null) {
                TextQuestionAbstractFragment textQuestionAbstractFragment2 = this;
                editText.removeCallbacks(runnable);
                textQuestionAbstractFragment2.startTextWatcherRunnable = null;
                textQuestionAbstractFragment2.answerEditText = null;
            }
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    public void afterTextChanged(Editable object) {
        Question question = this.question;
        if (question == null) {
            return;
        }
        question.setAnswer(object.toString());
        object = this.surveyFragmentCallbacks;
        if (object != null) {
            object.onAnswerTextQuestion(this.question);
        }
    }

    @Override
    public void onDestroy() {
        this.surveyFragmentCallbacks = null;
        super.onDestroy();
    }
}

