/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.custom.InstabugViewPager;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.util.LocaleHelper;
import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.ui.SurveyActivity;
import com.instabug.survey.ui.SurveyActivityCallback;
import com.instabug.survey.ui.survey.QuestionAbstractFragment;
import com.instabug.survey.ui.survey.SurveyFragmentCallbacks;
import com.instabug.survey.ui.survey.SurveyFragmentContract$View;
import com.instabug.survey.ui.survey.SurveyFragmentPresenter;
import com.instabug.survey.ui.survey.adapter.QuestionsPagerAdapter;
import com.instabug.survey.ui.survey.mcq.MCQQuestionAbstractFragment;
import com.instabug.survey.ui.survey.nps.NPSAbstractQuestionFragment;
import com.instabug.survey.ui.survey.rateus.RateUsAbstractFragment;
import com.instabug.survey.ui.survey.rateus.RateUsFragment;
import com.instabug.survey.ui.survey.starrating.StarRatingQuestionAbstractFragment;
import com.instabug.survey.ui.survey.text.TextQuestionAbstractFragment;
import com.instabug.survey.ui.survey.text.customized.CustomizedTextQuestionFragment;
import com.instabug.survey.utils.KeyboardUtils;
import com.instabug.survey.utils.PlayStoreUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class SurveyAbstractFragment
extends InstabugBaseFragment<SurveyFragmentPresenter>
implements SurveyFragmentContract$View,
View.OnClickListener,
SurveyFragmentCallbacks {
    @Nullable
    Survey survey;
    @Nullable
    protected Button submitButton;
    @Nullable
    protected InstabugViewPager questionsPager;
    @Nullable
    private QuestionsPagerAdapter questionsPagerAdapter;
    protected int currentQuestionPosition = -1;
    private String CURRENT_QUESTION_POSITION = "CURRENT_QUESTION_POSITION";
    @Nullable
    private SurveyActivityCallback surveyActivityCallback;
    private boolean shouldShowKeyboard = false;
    private long mLastClickTime;
    protected List<QuestionAbstractFragment> preparedFragments;

    public SurveyAbstractFragment() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.preparedFragments = arrayList2;
    }

    protected static Bundle getFragmentArgs(Survey survey, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("survey", (Serializable)survey);
        bundle.putBoolean("should_show_keyboard", bl);
        return bundle;
    }

    private void handleSubmitButtonState(@Nullable Bundle bundle) {
        InstabugViewPager instabugViewPager;
        if (this.survey != null && this.presenter != null && (instabugViewPager = this.questionsPager) != null) {
            if (bundle != null) {
                if (bundle.getInt(this.CURRENT_QUESTION_POSITION) != -1) {
                    int n;
                    SurveyAbstractFragment surveyAbstractFragment = this;
                    surveyAbstractFragment.currentQuestionPosition = n = bundle.getInt(this.CURRENT_QUESTION_POSITION);
                    surveyAbstractFragment.setSubmitButtonEnabled(((SurveyFragmentPresenter)surveyAbstractFragment.presenter).hasValidAnswer(this.survey, n));
                }
            } else {
                int n;
                SurveyAbstractFragment surveyAbstractFragment = this;
                surveyAbstractFragment.currentQuestionPosition = n = instabugViewPager.getCurrentItem();
                surveyAbstractFragment.setSubmitButtonEnabled(((SurveyFragmentPresenter)surveyAbstractFragment.presenter).hasValidAnswer(this.survey, n));
            }
            return;
        }
    }

    private void handleKeyboardVisibility(final int n) {
        Runnable runnable;
        Object object = this.questionsPager;
        if (object == null) {
            return;
        }
        InstabugViewPager instabugViewPager = object;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (SurveyAbstractFragment.this.questionsPagerAdapter != null) {
                    SurveyAbstractFragment surveyAbstractFragment = SurveyAbstractFragment.this;
                    if (surveyAbstractFragment.survey != null) {
                        if (surveyAbstractFragment.questionsPagerAdapter.getCount() > n) {
                            boolean bl = AccessibilityUtils.isTalkbackEnabled();
                            QuestionAbstractFragment questionAbstractFragment = SurveyAbstractFragment.this.questionsPagerAdapter.getItem(n);
                            if (questionAbstractFragment instanceof TextQuestionAbstractFragment && !bl) {
                                ((TextQuestionAbstractFragment)questionAbstractFragment).showKeyboard();
                                return;
                            }
                            if (SurveyAbstractFragment.this.survey.isStoreRatingSurvey() && SurveyAbstractFragment.this.survey.getQuestions().size() > n && SurveyAbstractFragment.this.survey.getQuestions().get(n).getType() == 0 && SurveyAbstractFragment.this.shouldShowKeyboard && !bl) {
                                4 v0 = this;
                                ((TextQuestionAbstractFragment)v0.SurveyAbstractFragment.this.questionsPagerAdapter.getItem(n)).showKeyboard();
                                SurveyAbstractFragment.access$202(v0.SurveyAbstractFragment.this, false);
                            } else if (SurveyAbstractFragment.this.getActivity() != null) {
                                KeyboardUtils.hide((Activity)SurveyAbstractFragment.this.getActivity());
                            }
                        }
                        return;
                    }
                }
            }
        };
        instabugViewPager.postDelayed((Runnable)object, 100L);
    }

    private void checkViewsVisibility() {
        Button button = this.submitButton;
        if (button != null && button.getVisibility() == 4) {
            this.submitButton.setVisibility(0);
        }
        if ((button = this.questionsPager) != null && button.getVisibility() == 4) {
            this.questionsPager.setVisibility(0);
        }
    }

    private void handleOnSubmitButtonClicked(View object) {
        if (this.survey != null && this.questionsPagerAdapter != null) {
            object = this.questionsPager;
            if (object != null) {
                SurveyAbstractFragment surveyAbstractFragment = this;
                int n = object.getCurrentItem();
                Fragment fragment = surveyAbstractFragment.getChildFragmentManager().findFragmentByTag("android:switcher:" + R.id.instabug_survey_pager + ":" + n);
                String string2 = null;
                if (surveyAbstractFragment.survey.isNPSSurvey()) {
                    this.handleNpsSurvey(n);
                } else {
                    if (fragment != null) {
                        string2 = ((QuestionAbstractFragment)fragment).getAnswer();
                    }
                    if (string2 == null) {
                        if (this.isEmptyAnswers() && !this.survey.isStoreRatingSurvey()) {
                            return;
                        }
                    } else {
                        this.handleKeyboardVisibility(n + 1);
                        object.postDelayed(new Runnable(){
                            final /* synthetic */ InstabugViewPager val$pager;
                            {
                                this.val$pager = instabugViewPager;
                            }

                            @Override
                            public void run() {
                                this.val$pager.scrollForward(true);
                            }
                        }, 300L);
                    }
                    if ((object = this.survey) == null || ((Survey)object).getQuestions() == null) {
                        return;
                    }
                    if (!this.survey.isStoreRatingSurvey() && this.survey.getQuestions().size() > n) {
                        this.survey.getQuestions().get(n).setAnswer(string2);
                    }
                }
                if (string2 != null && n >= this.questionsPagerAdapter.getCount() - 1) {
                    this.handleSurveySubmit();
                }
            }
            return;
        }
    }

    private void handleSurveyNext(int n) {
        SurveyAbstractFragment surveyAbstractFragment = this;
        surveyAbstractFragment.handleKeyboardVisibility(n);
        Object object = surveyAbstractFragment.questionsPager;
        if (object != null) {
            Runnable runnable;
            InstabugViewPager instabugViewPager = object;
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    6 this_ = this_.SurveyAbstractFragment.this.questionsPager;
                    if (this_ != null) {
                        this_.scrollForward(true);
                    }
                }
            };
            instabugViewPager.postDelayed((Runnable)object, 300L);
        }
    }

    private void handleNpsSurvey(int n) {
        if (this.survey != null && this.surveyActivityCallback != null) {
            if (this.isLastQuestion()) {
                if (this.survey.isAppStoreRatingEnabled()) {
                    this.survey.addRateEvent();
                    if (Instabug.getApplicationContext() == null) {
                        return;
                    }
                    Instabug.willRedirectToStore();
                    PlayStoreUtils.rateNow(Instabug.getApplicationContext());
                }
                this.surveyActivityCallback.submitSurvey(this.survey);
            } else {
                this.handleNpsQuestionSubmit(n);
            }
            return;
        }
    }

    private void handleSurveySubmit() {
        if (this.getActivity() != null && this.survey != null) {
            SurveyActivityCallback surveyActivityCallback = this.surveyActivityCallback;
            if (surveyActivityCallback != null) {
                SurveyAbstractFragment surveyAbstractFragment = this;
                KeyboardUtils.hide((Activity)surveyAbstractFragment.getActivity());
                surveyAbstractFragment.hideProgressbar(4);
                surveyAbstractFragment.hideBackButton();
                surveyActivityCallback.submitSurvey(surveyAbstractFragment.survey);
            }
            return;
        }
    }

    private boolean isEmptyAnswers() {
        Survey survey = this.survey;
        if (survey == null) {
            return true;
        }
        SurveyActivityCallback surveyActivityCallback = this.surveyActivityCallback;
        if (surveyActivityCallback != null) {
            if (!survey.isNPSSurvey()) {
                return true;
            }
            SurveyAbstractFragment surveyAbstractFragment = this;
            surveyAbstractFragment.hideProgressbar(4);
            surveyAbstractFragment.hideBackButton();
            surveyActivityCallback.submitSurvey(surveyAbstractFragment.survey);
            return false;
        }
        return true;
    }

    private void handleNpsQuestionSubmit(int n) {
        this.handleSurveyNext(n);
    }

    private void handleRateUsButtonState() {
        if (this.survey != null && this.submitButton != null && this.surveyActivityCallback != null) {
            SurveyAbstractFragment surveyAbstractFragment = this;
            surveyAbstractFragment.hideBackButton();
            Object object = surveyAbstractFragment.submitButton;
            if (object != null) {
                if (this.survey.isAppStoreRatingEnabled() && SurveysSettings.isAppLive()) {
                    if (this.survey.getRatingCTATitle() != null) {
                        object.setText((CharSequence)this.survey.getRatingCTATitle());
                    } else {
                        object.setText(R.string.surveys_nps_btn_rate_us);
                    }
                } else {
                    object.setVisibility(8);
                    object = this.surveyActivityCallback;
                    if (object != null) {
                        object.submitSurvey(this.survey);
                    }
                }
            }
            return;
        }
    }

    private void handleCloseButtonClicked() {
        if (this.survey != null && this.questionsPager != null && this.surveyActivityCallback != null) {
            if (this.isFirstQuestion()) {
                this.surveyActivityCallback.dismissSurvey(this.survey);
            } else if (this.survey.isNPSSurvey() && this.survey.hasPositiveNpsAnswer()) {
                if (this.questionsPager.getAdapter() != null) {
                    InstabugViewPager instabugViewPager = this.questionsPager;
                    int n = instabugViewPager.getAdapter().getCount() > 2 ? this.questionsPager.getCurrentItem() - 2 : this.questionsPager.getCurrentItem() - 1;
                    instabugViewPager.setCurrentItem(n);
                }
            } else {
                this.questionsPager.scrollBackward(true);
            }
            return;
        }
    }

    private int getQuestionPosition(long l) {
        Survey survey = this.survey;
        if (survey != null && survey.getQuestions() != null && this.survey.getQuestions().size() > 0) {
            for (int i = 0; i < this.survey.getQuestions().size(); ++i) {
                if (this.survey.getQuestions().get(i).getId() != l) continue;
                return i;
            }
        }
        return 0;
    }

    private boolean isLastQuestionInNPSSurvey() {
        Survey survey = this.survey;
        if (survey == null) {
            return false;
        }
        if (this.questionsPagerAdapter == null) {
            return false;
        }
        if (!survey.isNPSSurvey()) {
            return false;
        }
        SurveyAbstractFragment surveyAbstractFragment = this;
        int n = surveyAbstractFragment.questionsPagerAdapter.getCount();
        return surveyAbstractFragment.currentQuestionPosition == n - 2;
    }

    private void scrollNpsForward() {
        Survey survey = this.survey;
        if (survey != null && this.submitButton != null && this.questionsPager != null) {
            if (this.currentQuestionPosition == 0 && survey.getQuestions().get(0).getAnswer() != null) {
                SurveyAbstractFragment surveyAbstractFragment = this;
                InstabugViewPager instabugViewPager = surveyAbstractFragment.questionsPager;
                instabugViewPager.setCurrentItem(instabugViewPager.getCurrentItem() + 1, true);
                surveyAbstractFragment.submitButton.setText(R.string.instabug_str_action_submit);
            } else if (this.questionsPager.getCurrentItem() < 1 && this.survey.getQuestions().get(0).getAnswer() != null) {
                SurveyAbstractFragment surveyAbstractFragment = this;
                surveyAbstractFragment.questionsPager.setCurrentItem(1, true);
                surveyAbstractFragment.showBackButton();
            }
            return;
        }
    }

    static /* synthetic */ boolean access$202(SurveyAbstractFragment surveyAbstractFragment, boolean bl) {
        surveyAbstractFragment.shouldShowKeyboard = bl;
        return bl;
    }

    public void onAttach(Context context) {
        SurveyAbstractFragment surveyAbstractFragment = this;
        super.onAttach(context);
        if (surveyAbstractFragment.getActivity() instanceof SurveyActivity) {
            try {
                this.surveyActivityCallback = (SurveyActivityCallback)this.getActivity();
            }
            catch (Exception exception) {
                throw new RuntimeException("Must implement SurveyActivityCallback ");
            }
        }
    }

    public void onDetach() {
        this.surveyActivityCallback = null;
        super.onDetach();
    }

    protected int getLayout() {
        return R.layout.instabug_dialog_survey;
    }

    public void onCreate(@Nullable Bundle object) {
        SurveyAbstractFragment surveyAbstractFragment = this;
        super.onCreate(object);
        surveyAbstractFragment.setRetainInstance(true);
        if (surveyAbstractFragment.getArguments() != null) {
            SurveyAbstractFragment surveyAbstractFragment2 = this;
            surveyAbstractFragment2.survey = (Survey)surveyAbstractFragment2.getArguments().getSerializable("survey");
            surveyAbstractFragment2.shouldShowKeyboard = surveyAbstractFragment2.getArguments().getBoolean("should_show_keyboard");
        }
        if (this.survey != null) {
            SurveyFragmentPresenter surveyFragmentPresenter;
            object = surveyFragmentPresenter;
            surveyFragmentPresenter = new SurveyFragmentPresenter(this, this.survey);
            this.presenter = object;
        }
    }

    @CallSuper
    protected void initViews(View object, @Nullable Bundle bundle) {
        SurveyAbstractFragment surveyAbstractFragment = this;
        View view = object;
        view.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                return n == 4;
            }
        });
        surveyAbstractFragment.submitButton = (Button)view.findViewById(R.id.instabug_btn_submit);
        surveyAbstractFragment.questionsPager = (InstabugViewPager)surveyAbstractFragment.findViewById(R.id.instabug_survey_pager);
        object = surveyAbstractFragment.submitButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this);
        }
        if ((object = this.survey) != null && ((Survey)object).getQuestions() != null) {
            object = this.questionsPager;
            if (object != null) {
                object.setSwipeable(false);
                object.setOffscreenPageLimit(this.survey.getQuestions().size());
                if (this.getActivity() == null) {
                    return;
                }
                if (LocaleHelper.isRTL((Context)this.getActivity())) {
                    object.setRotation(180.0f);
                }
            }
            return;
        }
    }

    public void onViewCreated(@NonNull View object, @Nullable Bundle bundle) {
        super.onViewCreated((View)object, bundle);
        object.setFocusableInTouchMode(true);
        object = (SurveyFragmentPresenter)this.presenter;
        if (object != null) {
            if (this.shouldHandlePowerByFooter()) {
                ((SurveyFragmentPresenter)((Object)object)).handlePowerByFooter();
            }
            ((SurveyFragmentPresenter)((Object)object)).showSurvey();
        }
        this.handleSubmitButtonState(bundle);
    }

    protected boolean shouldHandlePowerByFooter() {
        return true;
    }

    @Override
    public void showSurvey(final Survey survey) {
        Button button = this.submitButton;
        InstabugViewPager instabugViewPager = this.questionsPager;
        if (button != null && instabugViewPager != null) {
            InstabugViewPager instabugViewPager2 = instabugViewPager;
            this.preparedFragments = this.getPreparedFragments(survey);
            SurveyAbstractFragment surveyAbstractFragment = this;
            FragmentManager fragmentManager = surveyAbstractFragment.getChildFragmentManager();
            this.questionsPagerAdapter = new QuestionsPagerAdapter(fragmentManager, surveyAbstractFragment.preparedFragments);
            instabugViewPager2.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

                public void onPageSelected(int n) {
                    Fragment fragment = (Fragment)SurveyAbstractFragment.this.preparedFragments.get(n);
                    if (fragment instanceof RateUsAbstractFragment) {
                        ((RateUsAbstractFragment)fragment).showRateUsQuestion();
                    }
                    super.onPageSelected(n);
                }
            });
            instabugViewPager2.setOffscreenPageLimit(0);
            instabugViewPager.setAdapter((PagerAdapter)this.questionsPagerAdapter);
            this.currentQuestionPosition = 0;
            if (this.questionsPagerAdapter.getCount() > 1 && survey.getType() != 2) {
                if (this.isLastQuestionInNPSSurvey()) {
                    button.setText(R.string.instabug_str_action_submit);
                } else {
                    button.setText(R.string.instabug_str_survey_next);
                }
                this.setQuestionsIndicator(0, survey.getQuestions().size());
                instabugViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                    public void onPageScrolled(int n, float f, int n2) {
                    }

                    public void onPageSelected(int n) {
                        SurveyAbstractFragment.this.currentQuestionPosition = n;
                        if (SurveyAbstractFragment.this.getActivity() != null && SurveyAbstractFragment.this.getActivity() instanceof SurveyActivityCallback) {
                            ((SurveyActivityCallback)SurveyAbstractFragment.this.getActivity()).onPageSelected(n);
                        }
                        3 v0 = this;
                        v0.SurveyAbstractFragment.this.handleOnPageSelected(n, survey);
                        v0.SurveyAbstractFragment.this.handleKeyboardVisibility(n);
                        v0.SurveyAbstractFragment.this.handlePbiViewVisibility();
                        v0.SurveyAbstractFragment.this.handleFragmentContainerHeight(n);
                        v0.SurveyAbstractFragment.this.focusAccessibilityOnSelectedPage(n);
                    }

                    public void onPageScrollStateChanged(int n) {
                    }
                });
            } else {
                this.hideProgressbar(8);
            }
            if (survey.getType() != 2 && (survey.getQuestions().get(0).getAnswer() == null || survey.getQuestions().get(0).getAnswer().isEmpty())) {
                this.setSubmitButtonEnabled(false);
            } else {
                this.setSubmitButtonEnabled(true);
            }
            return;
        }
    }

    protected void handleFragmentContainerHeight(int n) {
    }

    protected void handlePbiViewVisibility() {
    }

    protected void focusAccessibilityOnSelectedPage(int n) {
        if (AccessibilityUtils.isTalkbackEnabled() && (this = ((SurveyAbstractFragment)this).questionsPagerAdapter) != null) {
            QuestionAbstractFragment questionAbstractFragment = ((QuestionsPagerAdapter)((Object)this)).getItem(n);
            questionAbstractFragment.focusAccessibilityOnView((View)questionAbstractFragment.questionTextView);
        }
    }

    @CallSuper
    public void handleOnPageSelected(int n, Survey survey) {
        Button button = this.submitButton;
        if (button != null) {
            this.setQuestionsIndicator(n, survey.getQuestions().size());
            if (!survey.isNPSSurvey()) {
                if (this.isFirstQuestion()) {
                    button.setText(R.string.instabug_str_survey_next);
                } else if (this.isLastQuestion()) {
                    button.setText(R.string.instabug_str_action_submit);
                } else {
                    button.setText(R.string.instabug_str_survey_next);
                }
                String string2 = survey.getQuestions().get(n).getAnswer();
                this.setSubmitButtonEnabled((string2 == null || string2.trim().isEmpty()) ^ true);
            } else if (survey.isNPSSurvey()) {
                if (this.isLastQuestion()) {
                    this.handleRateUsButtonState();
                } else if (this.isFirstQuestion()) {
                    button.setText(R.string.instabug_str_survey_next);
                } else {
                    Button button2 = button;
                    button2.setVisibility(0);
                    button2.setText(R.string.instabug_str_action_submit);
                    this.setSubmitButtonEnabled(true);
                }
            }
        }
    }

    public void onResume() {
        SurveyAbstractFragment surveyAbstractFragment = this;
        super.onResume();
        if (surveyAbstractFragment.questionsPager == null) {
            return;
        }
        if (this.shouldHandleKeyboardVisibility()) {
            SurveyAbstractFragment surveyAbstractFragment2 = this;
            surveyAbstractFragment2.handleKeyboardVisibility(surveyAbstractFragment2.questionsPager.getCurrentItem());
        }
    }

    protected abstract boolean shouldHandleKeyboardVisibility();

    public void onStart() {
        SurveyAbstractFragment surveyAbstractFragment = this;
        super.onStart();
        surveyAbstractFragment.checkViewsVisibility();
    }

    public void onSaveInstanceState(Bundle bundle) {
        SurveyAbstractFragment surveyAbstractFragment = string2;
        SurveyAbstractFragment surveyAbstractFragment2 = string2;
        String string2 = surveyAbstractFragment2.CURRENT_QUESTION_POSITION;
        bundle.putInt(string2, surveyAbstractFragment2.currentQuestionPosition);
        super.onSaveInstanceState(bundle);
    }

    @VisibleForTesting
    List<QuestionAbstractFragment> getPreparedFragments(Survey survey) {
        ArrayList<QuestionAbstractFragment> arrayList;
        ArrayList<QuestionAbstractFragment> arrayList2 = arrayList;
        arrayList = new ArrayList<QuestionAbstractFragment>();
        for (int i = 0; i < survey.getQuestions().size(); ++i) {
            Survey survey2 = survey;
            Question question = survey2.getQuestions().get(i);
            if (survey2.isNPSSurvey() && !question.isEnabled()) continue;
            boolean bl = i == 0;
            if (question.getType() == 1) {
                arrayList2.add(MCQQuestionAbstractFragment.newInstance(bl, question, this));
                continue;
            }
            if (question.getType() == 0) {
                bl = survey.getType() == 2 || bl;
                if (SurveysSettings.isCustomizationEnabled()) {
                    arrayList2.add(CustomizedTextQuestionFragment.newInstance(bl, question, this));
                    continue;
                }
                arrayList2.add(TextQuestionAbstractFragment.newInstance(bl, question, this));
                continue;
            }
            if (question.getType() == 2) {
                arrayList2.add(StarRatingQuestionAbstractFragment.newInstance(bl, question, this));
                continue;
            }
            if (question.getType() != 3) continue;
            this.hideProgressbar(8);
            arrayList2.add(NPSAbstractQuestionFragment.newInstance(bl, question, this));
        }
        if (survey.isNPSSurvey()) {
            arrayList2.add(RateUsAbstractFragment.newInstance(survey, this));
        }
        return arrayList2;
    }

    public void setSubmitButtonEnabled(boolean bl) {
        Survey survey;
        Button button = this.submitButton;
        if (button == null) {
            return;
        }
        button.setEnabled(bl);
        if (this.getActivity() == null) {
            return;
        }
        if (bl) {
            Survey survey2;
            if (SurveysSettings.isCustomizationEnabled() && (survey2 = this.survey) != null && survey2.getType() == 2) {
                if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                    DrawableUtils.setColor((View)button, (int)-16777216);
                    button.setTextColor(ContextCompat.getColor((Context)this.getActivity(), (int)17170443));
                } else {
                    DrawableUtils.setColor((View)button, (int)-1);
                    button.setTextColor(ContextCompat.getColor((Context)this.getActivity(), (int)17170444));
                }
            } else {
                DrawableUtils.setColor((View)button, (int)this.getSubmitButtonColor());
                button.setTextColor(ContextCompat.getColor((Context)this.getActivity(), (int)17170443));
            }
        } else if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
            DrawableUtils.setColor((View)button, (int)ContextCompat.getColor((Context)this.getActivity(), (int)R.color.survey_btn_disabled_color_light));
        } else if (SurveysSettings.isCustomizationEnabled() && (survey = this.survey) != null && survey.getType() == 2) {
            Button button2 = button;
            button2.setTextColor(-1);
            DrawableUtils.setColor((View)button2, (int)Color.parseColor((String)"#d9d9d9"));
        } else {
            button.setTextColor(ContextCompat.getColor((Context)this.getActivity(), (int)R.color.survey_btn_txt_color_dark));
            DrawableUtils.setColor((View)button, (int)ContextCompat.getColor((Context)this.getActivity(), (int)R.color.survey_btn_disabled_color_dark));
        }
    }

    protected abstract int getSubmitButtonColor();

    @VisibleForTesting
    abstract void setQuestionsIndicator(int var1, int var2);

    public void onClick(View view) {
        int n = view.getId();
        if (n == R.id.instabug_btn_submit) {
            this.handleOnSubmitButtonClicked(view);
        } else if (n == R.id.instabug_ic_survey_close) {
            if (SystemClock.elapsedRealtime() - this.mLastClickTime < 1000L) {
                return;
            }
            this.mLastClickTime = SystemClock.elapsedRealtime();
            this.handleCloseButtonClicked();
        }
    }

    protected abstract void hideProgressbar(int var1);

    protected abstract void hideBackButton();

    protected boolean isFirstQuestion() {
        SurveyAbstractFragment surveyAbstractFragment = surveyAbstractFragment.questionsPager;
        if (surveyAbstractFragment == null) {
            return false;
        }
        return surveyAbstractFragment.getCurrentItem() == 0;
    }

    protected boolean isLastQuestion() {
        InstabugViewPager instabugViewPager = this.questionsPager;
        if (instabugViewPager != null && this.questionsPagerAdapter != null) {
            return instabugViewPager.getCurrentItem() == this.questionsPagerAdapter.getCount() - 1;
        }
        return false;
    }

    @Override
    public void onAnswerMCQQuestion(Question question) {
        Survey survey = this.survey;
        if (survey == null) {
            return;
        }
        if (survey.getQuestions() == null) {
            return;
        }
        SurveyAbstractFragment surveyAbstractFragment = this;
        surveyAbstractFragment.survey.getQuestions().get(this.getQuestionPosition(question.getId())).setAnswer(question.getAnswer());
        surveyAbstractFragment.setSubmitButtonEnabled(true);
    }

    @Override
    public void onAnswerTextQuestion(Question object) {
        Survey survey = this.survey;
        if (survey == null) {
            return;
        }
        if (survey.getQuestions() == null) {
            return;
        }
        this.survey.getQuestions().get(this.getQuestionPosition(((Question)object).getId())).setAnswer(((Question)object).getAnswer());
        object = ((Question)object).getAnswer();
        boolean bl = object == null || ((String)object).trim().isEmpty();
        if (!this.survey.isNPSSurvey()) {
            this.setSubmitButtonEnabled(bl ^ true);
        }
    }

    @Override
    public void onAnswerRateQuestion(Question question) {
        if (this.survey == null) {
            return;
        }
        if (question.getAnswer() != null) {
            if (Integer.parseInt(question.getAnswer()) >= 1) {
                SurveyAbstractFragment surveyAbstractFragment = this;
                surveyAbstractFragment.setSubmitButtonEnabled(true);
                if (surveyAbstractFragment.survey.getQuestions() == null) {
                    return;
                }
                this.survey.getQuestions().get(this.getQuestionPosition(question.getId())).setAnswer(question.getAnswer());
            } else {
                this.setSubmitButtonEnabled(false);
            }
        } else {
            this.setSubmitButtonEnabled(false);
        }
    }

    public void onBackPressed() {
        if (this.questionsPager == null) {
            return;
        }
        if ((Fragment)this.preparedFragments.get(this.currentQuestionPosition) instanceof RateUsFragment) {
            return;
        }
        this.questionsPager.scrollBackward(true);
    }

    @Override
    public void onAnswerNPSQuestion(Question question) {
        Survey survey = this.survey;
        if (survey == null) {
            return;
        }
        if (survey.getQuestions() == null) {
            return;
        }
        SurveyAbstractFragment surveyAbstractFragment = this;
        surveyAbstractFragment.survey.getQuestions().get(this.getQuestionPosition(question.getId())).setAnswer(question.getAnswer());
        surveyAbstractFragment.setSubmitButtonEnabled(true);
    }

    @Override
    public void handlePoweredByFooter() {
        if (InstabugCore.getFeatureState((String)"WHITE_LABELING") == Feature.State.ENABLED && !SettingsManager.getInstance().isCustomBrandingEnabled()) {
            InstabugCore.handlePbiFooter((View)this.getView());
        } else if (this.submitButton != null) {
            SurveyAbstractFragment surveyAbstractFragment = this;
            InstabugCore.handlePbiFooter((View)surveyAbstractFragment.getView());
            InstabugCore.handlePbiFooterThemeColor((View)surveyAbstractFragment.getView(), (int)R.color.pbi_footer_color_dark, (int)R.color.pbi_footer_color_light);
            ((LinearLayout.LayoutParams)surveyAbstractFragment.submitButton.getLayoutParams()).bottomMargin = DisplayUtils.dpToPxIntRounded((Resources)this.getResources(), (int)8);
            surveyAbstractFragment.submitButton.requestLayout();
        }
    }

    public void onSwipeRight() {
        Object object;
        SurveyAbstractFragment surveyAbstractFragment = this;
        final InstabugViewPager instabugViewPager = surveyAbstractFragment.questionsPager;
        if (surveyAbstractFragment.getContext() != null && (object = this.survey) != null && this.submitButton != null && instabugViewPager != null) {
            if (((Survey)object).isNPSSurvey()) {
                if (LocaleHelper.isRTL((Context)this.getContext())) {
                    this.scrollNpsForward();
                } else if (instabugViewPager.getCurrentItem() != 2) {
                    InstabugViewPager instabugViewPager2 = instabugViewPager;
                    instabugViewPager2.setCurrentItem(instabugViewPager2.getCurrentItem() - 1, true);
                    this.hideBackButton();
                }
            } else {
                Runnable runnable;
                object = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        SurveyAbstractFragment surveyAbstractFragment = SurveyAbstractFragment.this;
                        if (surveyAbstractFragment.survey != null && surveyAbstractFragment.getContext() != null && instabugViewPager != null) {
                            if (LocaleHelper.isRTL((Context)SurveyAbstractFragment.this.getContext())) {
                                if (SurveyAbstractFragment.this.survey.getQuestions().get(SurveyAbstractFragment.this.currentQuestionPosition).getAnswer() != null && !TextUtils.isEmpty((CharSequence)SurveyAbstractFragment.this.survey.getQuestions().get(SurveyAbstractFragment.this.currentQuestionPosition).getAnswer())) {
                                    instabugViewPager.scrollForward(true);
                                }
                            } else {
                                instabugViewPager.scrollBackward(true);
                            }
                            return;
                        }
                    }
                };
                instabugViewPager.postDelayed((Runnable)object, 300L);
            }
            return;
        }
    }

    protected abstract void showBackButton();

    public void onSwipeLeft() {
        Object object;
        if (this.getContext() != null && (object = this.survey) != null) {
            final InstabugViewPager instabugViewPager = this.questionsPager;
            if (instabugViewPager != null) {
                if (((Survey)object).isNPSSurvey()) {
                    if (LocaleHelper.isRTL((Context)this.getContext())) {
                        if (this.currentQuestionPosition == 1) {
                            instabugViewPager.setCurrentItem(0, true);
                        }
                    } else {
                        this.scrollNpsForward();
                    }
                } else {
                    Runnable runnable;
                    object = runnable;
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            SurveyAbstractFragment surveyAbstractFragment = SurveyAbstractFragment.this;
                            if (surveyAbstractFragment.survey != null && surveyAbstractFragment.getContext() != null) {
                                if (LocaleHelper.isRTL((Context)SurveyAbstractFragment.this.getContext())) {
                                    instabugViewPager.scrollBackward(true);
                                } else if (SurveyAbstractFragment.this.survey.getQuestions().get(SurveyAbstractFragment.this.currentQuestionPosition).getAnswer() != null && !TextUtils.isEmpty((CharSequence)SurveyAbstractFragment.this.survey.getQuestions().get(SurveyAbstractFragment.this.currentQuestionPosition).getAnswer())) {
                                    instabugViewPager.scrollForward(true);
                                }
                                return;
                            }
                        }
                    };
                    instabugViewPager.postDelayed((Runnable)object, 200L);
                }
            }
            return;
        }
    }
}

