/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.LocaleHelper;
import com.instabug.library.util.OrientationUtils;
import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import com.instabug.survey.ui.SurveyActivity;
import com.instabug.survey.ui.SurveyActivityCallback;
import com.instabug.survey.ui.ViewType;
import com.instabug.survey.ui.gestures.GesturesHandler;
import com.instabug.survey.ui.survey.SurveyFragment;
import com.instabug.survey.ui.survey.SurveyFragmentCallbacks;
import com.instabug.survey.ui.survey.rateus.RateUsAbstractFragment;
import com.instabug.survey.ui.survey.rateus.RateUsFragment;
import java.io.Serializable;
import java.util.Iterator;

public abstract class QuestionAbstractFragment
extends InstabugBaseFragment
implements View.OnClickListener,
GesturesHandler.GestureCallback {
    @Nullable
    protected Question question;
    @Nullable
    protected SurveyFragmentCallbacks surveyFragmentCallbacks;
    @Nullable
    protected TextView questionTextView;
    @Nullable
    protected View shadow;
    @Nullable
    protected RelativeLayout container;
    @Nullable
    protected Survey survey;

    public void setSurveyFragmentCallbacks(@NonNull SurveyFragmentCallbacks surveyFragmentCallbacks) {
        this.surveyFragmentCallbacks = surveyFragmentCallbacks;
    }

    public void onCreate(@Nullable Bundle bundle) {
        if (this.getActivity() == null) {
            return;
        }
        if (this.getActivity() instanceof SurveyActivity) {
            this.survey = ((SurveyActivity)this.getActivity()).getSurvey();
        }
        super.onCreate(bundle);
    }

    @CallSuper
    protected void initViews(View view, @Nullable Bundle bundle) {
        if (this.getActivity() == null) {
            return;
        }
        if (this.getActivity() instanceof SurveyActivity) {
            ((SurveyActivity)this.getActivity()).setBackgroundTransparent(false);
        }
        if (this.getContext() == null) {
            return;
        }
        this.shadow = this.findViewById(R.id.survey_shadow);
        this.questionTextView = (TextView)view.findViewById(R.id.instabug_text_view_question);
        this.container = (RelativeLayout)this.findViewById(R.id.instabug_survey_dialog_container);
        if (AccessibilityUtils.isTalkbackEnabled() && (bundle = this.container) != null) {
            int n = Build.VERSION.SDK_INT;
            if (n >= 16) {
                bundle.setImportantForAccessibility(2);
            }
            if (n >= 28) {
                this.container.setScreenReaderFocusable(false);
            }
        }
        if (this.getContext() != null && !this.isPartial() && LocaleHelper.isRTL((Context)this.getContext())) {
            view.setRotation(180.0f);
        }
        if (this instanceof RateUsAbstractFragment) {
            return;
        }
        QuestionAbstractFragment questionAbstractFragment = this;
        questionAbstractFragment.setupQuestionAnnouncementOrder(questionAbstractFragment.questionTextView);
    }

    public abstract boolean isPartial();

    @Nullable
    public abstract String getAnswer();

    protected void handleTextViewMaxLines() {
        if (this.getActivity() == null) {
            return;
        }
        TextView textView = this.questionTextView;
        if (textView != null && OrientationUtils.isInLandscape((Context)this.getActivity())) {
            textView.setMaxLines(3);
        }
    }

    protected void handleOpenSurveyClicked(Survey survey, boolean bl) {
        if (this.getActivity() != null && this.getActivity() instanceof SurveyActivity) {
            if (survey != null && survey.getQuestions() != null && survey.getQuestions().size() > 0) {
                if (survey.getType() != 2 && survey.getQuestions().get(0).getType() != 3) {
                    if (survey.getQuestions().get(0).getType() == 2) {
                        ((SurveyActivity)this.getActivity()).setLayoutHeightSecondary(ViewType.PRIMARY, true);
                        Iterator<Question> iterator = survey.getQuestions().iterator();
                        while (iterator.hasNext()) {
                            if (iterator.next().getType() == 2) continue;
                            ((SurveyActivity)this.getActivity()).setLayoutHeightSecondary(ViewType.SECONDARY, true);
                            break;
                        }
                    } else {
                        ((SurveyActivity)this.getActivity()).setLayoutHeightSecondary(ViewType.SECONDARY, true);
                    }
                } else {
                    ((SurveyActivity)this.getActivity()).setLayoutHeightSecondary(ViewType.PRIMARY, true);
                }
            }
            if (this.getActivity() != null && this.getActivity().getLifecycle().getCurrentState() == Lifecycle.State.RESUMED) {
                int n = R.id.instabug_fragment_container;
                this.getActivity().getSupportFragmentManager().beginTransaction().setCustomAnimations(0, 0).replace(n, (Fragment)SurveyFragment.newInstance(survey, bl)).commit();
            }
        }
    }

    protected void setupQuestionAnnouncementOrder(@Nullable TextView textView) {
        if (!AccessibilityUtils.isTalkbackEnabled()) {
            return;
        }
        Serializable serializable = ((QuestionAbstractFragment)((Object)string2)).survey;
        if (serializable != null && serializable.getQuestions().size() > 1 && ((QuestionAbstractFragment)((Object)string2)).question != null && textView != null) {
            QuestionAbstractFragment questionAbstractFragment = string2;
            int n = R.string.ibg_surveys_question_order_content_description;
            serializable = Integer.valueOf(((QuestionAbstractFragment)((Object)string2)).survey.getQuestions().indexOf(((QuestionAbstractFragment)((Object)string2)).question) + 1);
            Integer n2 = questionAbstractFragment.survey.getQuestions().size();
            String string2 = ((QuestionAbstractFragment)((Object)string2)).question.getTitle();
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray[0] = serializable;
            objectArray[1] = n2;
            objectArray[2] = string2;
            textView.setContentDescription((CharSequence)questionAbstractFragment.getString(n, objectArray2));
        }
    }

    public void focusAccessibilityOnView(@Nullable View view) {
        if (view != null && Build.VERSION.SDK_INT >= 16) {
            Bundle bundle;
            View view2 = view;
            QuestionAbstractFragment questionAbstractFragment = bundle;
            bundle = new Bundle();
            view2.performAccessibilityAction(64, (Bundle)questionAbstractFragment);
            view2.sendAccessibilityEvent(4);
        }
    }

    @Override
    public void onClick() {
        Survey survey = this.survey;
        if (survey == null) {
            return;
        }
        this.handleOpenSurveyClicked(survey, false);
    }

    @Override
    public void close() {
        Survey survey = this.survey;
        if (survey == null) {
            return;
        }
        if (survey.isNPSSurvey() && this instanceof RateUsFragment) {
            if (this.getActivity() instanceof SurveyActivityCallback) {
                ((SurveyActivityCallback)this.getActivity()).submitSurvey(this.survey);
            }
        } else if (this.getActivity() instanceof SurveyActivityCallback) {
            ((SurveyActivityCallback)this.getActivity()).dismissSurvey(this.survey);
        }
    }

    public void onDestroy() {
        GesturesHandler.destroy();
        super.onDestroy();
    }
}

