/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.popup;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import com.google.android.gms.tasks.Task;
import com.google.android.play.core.review.ReviewInfo;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.InAppRatingCallback;
import com.instabug.survey.InAppRatingRequestCallback;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.ui.popup.PopupQuestionContract$View;
import com.instabug.survey.utils.PlayStoreUtils;
import java.io.Serializable;
import java.util.ArrayList;

public class PopupQuestionPresenter
extends BasePresenter<PopupQuestionContract$View>
implements BaseContract.Presenter {
    @NonNull
    private Survey survey;
    @Nullable
    ReviewInfo playReviewInfo = null;

    PopupQuestionPresenter(PopupQuestionContract$View popupQuestionContract$View, @NonNull Survey survey) {
        super((BaseContract.View)popupQuestionContract$View);
        this.survey = survey;
        if (survey.isGooglePlayAppRating() && popupQuestionContract$View.getViewContext() != null && ((Fragment)popupQuestionContract$View.getViewContext()).getActivity() != null) {
            PlayStoreUtils.prepareInAppRating((Activity)((Fragment)popupQuestionContract$View.getViewContext()).getActivity(), new InAppRatingCallback(){

                @Override
                public void onSuccess(ReviewInfo reviewInfo) {
                    PopupQuestionPresenter.this.playReviewInfo = reviewInfo;
                    InstabugSDKLogger.d((String)"IBG-Surveys", (String)"Google Play In-app review task succeeded");
                }

                @Override
                public void onFailure(Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Requesting Google Play In-app review failed", (Throwable)exception);
                }
            });
        }
    }

    public void showPrimaryQuestion() {
        Object object = ((PopupQuestionPresenter)((Object)object3)).survey;
        if (object == null) {
            return;
        }
        if ((object = ((Survey)object).getQuestions()) != null && !object.isEmpty()) {
            Object object2;
            PopupQuestionPresenter popupQuestionPresenter = object3;
            Object object3 = popupQuestionPresenter.survey.getQuestions().get(0);
            object = (PopupQuestionContract$View)popupQuestionPresenter.view.get();
            if (object != null && object3 != null && (object2 = ((Question)object3).getOptionalAnswers()) != null && ((ArrayList)object2).size() >= 2) {
                Object object4 = object;
                ArrayList<String> arrayList = object2;
                object3 = ((Question)object3).getTitle();
                object = arrayList.get(0);
                object2 = arrayList.get(1);
                object4.showPrimaryQuestion(null, (String)object3, (String)object, (String)object2);
            }
        }
    }

    @VisibleForTesting
    void handleBetaAppAnswer() {
        ArrayList<String> arrayList;
        ArrayList<Question> arrayList2 = this.survey.getQuestions();
        if (arrayList2 != null && !arrayList2.isEmpty() && (arrayList = ((Question)arrayList2.get(0)).getOptionalAnswers()) != null && !arrayList.isEmpty()) {
            ((Question)arrayList2.get(0)).setAnswer(arrayList.get(0));
            arrayList2 = (PopupQuestionContract$View)this.view.get();
            if (arrayList2 != null) {
                arrayList2.onBetaAppPrimaryQuestionAnswered(this.survey);
            }
        }
    }

    public void showPositiveSecondaryQuestion() {
        Object object = ((PopupQuestionPresenter)((Object)object2)).survey.getQuestions();
        if (object != null && ((ArrayList)object).size() >= 2) {
            PopupQuestionPresenter popupQuestionPresenter = object2;
            Object object2 = ((ArrayList)object).get(1);
            object = (PopupQuestionContract$View)popupQuestionPresenter.view.get();
            if (object != null && object2 != null && ((Question)object2).getOptionalAnswers() != null && ((Question)object2).getOptionalAnswers().size() >= 2) {
                ArrayList<Question> arrayList = object;
                Object object3 = object2;
                object2 = ((Question)object3).getTitle();
                object = ((Question)object3).getOptionalAnswers().get(0);
                String string2 = ((Question)object3).getOptionalAnswers().get(1);
                arrayList.showAlertForPositiveSecondaryQuestion(null, (String)object2, (String)object, string2);
            }
        }
    }

    public void showNegativeSecondaryQuestion() {
        ArrayList<Question> arrayList = this.survey.getQuestions();
        if (arrayList != null && !arrayList.isEmpty() && (arrayList = this.survey.getQuestions().get(0)) != null && ((Question)((Object)arrayList)).getOptionalAnswers() != null && ((Question)((Object)arrayList)).getOptionalAnswers().size() >= 2) {
            Serializable serializable = arrayList;
            ((Question)serializable).setAnswer(((Question)serializable).getOptionalAnswers().get(1));
            arrayList = (PopupQuestionContract$View)this.view.get();
            if (arrayList != null) {
                arrayList.showNegativeSecondaryQuestion(this.survey);
            }
        }
    }

    void positivePrimaryOptionClicked() {
        ArrayList<String> arrayList = this.survey.getQuestions().get(0).getOptionalAnswers();
        if (arrayList != null) {
            this.survey.getQuestions().get(0).setAnswer(arrayList.get(0));
        }
        if (SurveysSettings.isAppLive()) {
            if (!this.survey.isGooglePlayAppRating()) {
                this.showPositiveSecondaryQuestion();
            } else {
                PopupQuestionPresenter popupQuestionPresenter = this;
                popupQuestionPresenter.submitSurvey();
                popupQuestionPresenter.showGooglePlayInAppRating();
            }
        } else {
            this.handleBetaAppAnswer();
        }
    }

    public void showGooglePlayInAppRating() {
        PopupQuestionContract$View popupQuestionContract$View = (PopupQuestionContract$View)this.view.get();
        if (popupQuestionContract$View != null && this.playReviewInfo != null && popupQuestionContract$View.getViewContext() != null && ((Fragment)popupQuestionContract$View.getViewContext()).getActivity() != null) {
            PlayStoreUtils.requestInAppRating((Activity)((Fragment)popupQuestionContract$View.getViewContext()).getActivity(), this.playReviewInfo, new InAppRatingRequestCallback(){

                @Override
                public void onComplete(Task<Void> task) {
                    InstabugSDKLogger.d((String)"IBG-Surveys", (String)"Google Play In-app review ready to show");
                }

                @Override
                public void onFailure(Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Showing Google Play In-app review failed", (Throwable)exception);
                }
            });
        }
    }

    void positiveSecondaryOptionClicked() {
        ArrayList<Object> arrayList = this.survey.getQuestions();
        if (arrayList != null && arrayList.size() >= 2 && (arrayList = this.survey.getQuestions().get(0).getOptionalAnswers()) != null && !arrayList.isEmpty()) {
            if (this.survey.getQuestions().get(1).getOptionalAnswers() != null && this.survey.getQuestions().get(1).getOptionalAnswers().size() != 0) {
                this.survey.getQuestions().get(1).setAnswer(this.survey.getQuestions().get(1).getOptionalAnswers().get(0));
            } else {
                return;
            }
        }
        PopupQuestionPresenter popupQuestionPresenter = this;
        popupQuestionPresenter.survey.addRateEvent();
        arrayList = (PopupQuestionContract$View)popupQuestionPresenter.view.get();
        if (arrayList != null) {
            arrayList.onPositiveSecondaryQuestionPositiveResponse(this.survey);
        }
    }

    void negativeSecondaryOptionClicked() {
        ArrayList<Question> arrayList = this.survey.getQuestions();
        if (arrayList != null && arrayList.size() >= 2 && (arrayList = this.survey.getQuestions().get(0).getOptionalAnswers()) != null && arrayList.size() >= 2) {
            if (this.survey.getQuestions().get(1).getOptionalAnswers() != null && this.survey.getQuestions().get(1).getOptionalAnswers().size() != 0) {
                PopupQuestionPresenter popupQuestionPresenter = this;
                popupQuestionPresenter.survey.getQuestions().get(1).setAnswer(this.survey.getQuestions().get(1).getOptionalAnswers().get(1));
                arrayList = (PopupQuestionContract$View)popupQuestionPresenter.view.get();
                if (arrayList != null) {
                    arrayList.onPositiveSecondaryQuestionNegativeResponse(this.survey);
                }
            } else {
                return;
            }
        }
    }

    public void dismissSurvey() {
        Survey survey;
        PopupQuestionContract$View popupQuestionContract$View = (PopupQuestionContract$View)this.view.get();
        if (popupQuestionContract$View != null && (survey = this.survey) != null) {
            popupQuestionContract$View.dismissSurvey(survey);
        }
    }

    public void submitSurvey() {
        Survey survey;
        PopupQuestionContract$View popupQuestionContract$View = (PopupQuestionContract$View)this.view.get();
        if (popupQuestionContract$View != null && (survey = this.survey) != null) {
            popupQuestionContract$View.submitSurvey(survey);
        }
    }
}

