/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.gestures;

import android.animation.ValueAnimator;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;

public abstract class GesturesHandler {
    private static int CLICK_ACTION_THRESHOLD = 5;
    private static boolean isClosing = false;
    private static float lastDragingPosition = -1.0f;
    private static int originalHeight = -1;
    private static float startX;
    private static float startY;
    @Nullable
    private static WeakReference<GestureCallback> gestureCallback;

    public static void handle(View view, MotionEvent motionEvent, boolean bl, boolean bl2, @NonNull GestureCallback gestureCallback) {
        ViewGroup.LayoutParams layoutParams = GesturesHandler.gestureCallback;
        if (layoutParams == null || layoutParams.get() == null) {
            GesturesHandler.gestureCallback = new WeakReference<GestureCallback>(gestureCallback);
        }
        view = bl ? (View)view.getParent() : (View)view.getParent().getParent().getParent().getParent();
        layoutParams = view.getLayoutParams();
        if (originalHeight == -1) {
            originalHeight = layoutParams.height;
        }
        GesturesHandler.handleMotionEvent(motionEvent, bl, bl2, gestureCallback, view, layoutParams);
    }

    public static void handleAnnouncementView(View view, MotionEvent motionEvent, @NonNull GestureCallback gestureCallback) {
        ViewGroup.LayoutParams layoutParams = GesturesHandler.gestureCallback;
        if (layoutParams == null || layoutParams.get() == null) {
            GesturesHandler.gestureCallback = new WeakReference<GestureCallback>(gestureCallback);
        }
        view = (View)view.getParent();
        layoutParams = view.getLayoutParams();
        if (originalHeight == -1) {
            originalHeight = layoutParams.height;
        }
        GesturesHandler.handleMotionEvent(motionEvent, false, false, gestureCallback, view, layoutParams);
    }

    public static void handleMotionEvent(MotionEvent motionEvent, boolean n, boolean bl, @NonNull GestureCallback gestureCallback, View view, ViewGroup.LayoutParams layoutParams) {
        int n2 = motionEvent.getActionMasked();
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    if (bl) {
                        if (lastDragingPosition < motionEvent.getRawY()) {
                            layoutParams.height = (int)((float)layoutParams.height - (motionEvent.getRawY() - lastDragingPosition));
                            view.setLayoutParams(layoutParams);
                            lastDragingPosition = motionEvent.getRawY();
                        } else if (lastDragingPosition > motionEvent.getRawY() && (n2 = layoutParams.height) < originalHeight) {
                            layoutParams.height = (int)((float)n2 + (lastDragingPosition - motionEvent.getRawY()));
                            view.setLayoutParams(layoutParams);
                            lastDragingPosition = motionEvent.getRawY();
                        }
                    } else if (n != 0) {
                        if (lastDragingPosition < motionEvent.getRawY()) {
                            layoutParams.height = (int)((float)layoutParams.height - (motionEvent.getRawY() - lastDragingPosition));
                            view.setLayoutParams(layoutParams);
                            lastDragingPosition = motionEvent.getRawY();
                        } else if (lastDragingPosition > motionEvent.getRawY()) {
                            layoutParams.height = (int)((float)layoutParams.height + (lastDragingPosition - motionEvent.getRawY()));
                            view.setLayoutParams(layoutParams);
                            lastDragingPosition = motionEvent.getRawY();
                        }
                    } else if (lastDragingPosition < motionEvent.getRawY()) {
                        layoutParams.height = (int)((float)layoutParams.height - (motionEvent.getRawY() - lastDragingPosition));
                        view.setLayoutParams(layoutParams);
                        lastDragingPosition = motionEvent.getRawY();
                    } else if (lastDragingPosition > motionEvent.getRawY()) {
                        n2 = layoutParams.height;
                        if (n2 < originalHeight) {
                            layoutParams.height = (int)((float)n2 + (lastDragingPosition - motionEvent.getRawY()));
                            view.setLayoutParams(layoutParams);
                        }
                        lastDragingPosition = motionEvent.getRawY();
                    }
                    if (n != 0) {
                        if ((float)layoutParams.height / (float)originalHeight > 2.0f) {
                            if (!bl) {
                                gestureCallback.onClick();
                                isClosing = false;
                            }
                        } else {
                            isClosing = false;
                        }
                    } else if ((float)layoutParams.height / (float)originalHeight < 0.7f) {
                        isClosing = true;
                        gestureCallback.close();
                        originalHeight = -1;
                    } else {
                        isClosing = false;
                    }
                }
            } else {
                n2 = 0;
                float f = motionEvent.getY();
                if (GesturesHandler.isAClick(startX, motionEvent.getX(), startY, f) && n != 0 && !isClosing && !bl) {
                    gestureCallback.onClick();
                    n2 = 1;
                    isClosing = true;
                    originalHeight = -1;
                }
                if (!isClosing) {
                    if (n != 0) {
                        int n3 = originalHeight;
                        n = layoutParams.height;
                        if (n3 != n && n3 > n) {
                            if ((float)n / (float)n3 < 0.7f) {
                                isClosing = true;
                                gestureCallback.close();
                                originalHeight = -1;
                            } else {
                                GesturesHandler.animateBackToOriginalHeight(view, n, n3);
                                n2 = 1;
                            }
                        } else if (n3 != n && n3 < n) {
                            if ((float)n / (float)n3 > 1.4f) {
                                if (!bl) {
                                    gestureCallback.onClick();
                                    originalHeight = -1;
                                }
                            } else {
                                GesturesHandler.animateBackToOriginalHeight(view, n, n3);
                            }
                            n2 = 1;
                        }
                    } else {
                        int n4 = originalHeight;
                        n = layoutParams.height;
                        if (n4 != n && n4 > n) {
                            GesturesHandler.animateBackToOriginalHeight(view, n, n4);
                            n2 = 1;
                        }
                    }
                }
                if (n2 != 0) {
                    originalHeight = -1;
                }
            }
        } else {
            startX = motionEvent.getX();
            startY = motionEvent.getY();
            lastDragingPosition = motionEvent.getRawY();
        }
    }

    private static void animateBackToOriginalHeight(final View view, int n, int n2) {
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener;
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{n, n2});
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener2 = animatorUpdateListener;
        animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                1 v0 = this;
                int n = (Integer)valueAnimator.getAnimatedValue();
                valueAnimator = v0.view.getLayoutParams();
                v0.view.getLayoutParams().height = n;
                v0.view.setLayoutParams((ViewGroup.LayoutParams)valueAnimator);
            }
        };
        valueAnimator.addUpdateListener(animatorUpdateListener2);
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private static boolean isAClick(float f, float f2, float f3, float f4) {
        float f5 = Math.abs(f - f2);
        f = Math.abs(f3 - f4);
        int n = CLICK_ACTION_THRESHOLD;
        return !(f5 > (float)n) && !(f > (float)n);
    }

    public static void reset() {
        originalHeight = -1;
        lastDragingPosition = -1.0f;
    }

    public static void destroy() {
        WeakReference<GestureCallback> weakReference = gestureCallback;
        if (weakReference != null) {
            weakReference.clear();
        }
    }

    public static interface GestureCallback {
        public void onClick();

        public void close();
    }
}

