/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.custom;

import android.content.res.Resources;
import android.view.View;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.ResourcesUtils;
import com.instabug.survey.R;
import com.instabug.survey.ui.custom.RatingAbstractView;
import com.instabug.survey.ui.custom.VirtualViewsInfoProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0014\u0010\u0019\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/instabug/survey/ui/custom/RatingVirtualViewsProvider;", "Lcom/instabug/survey/ui/custom/VirtualViewsInfoProvider;", "ratingView", "Lcom/instabug/survey/ui/custom/RatingAbstractView;", "(Lcom/instabug/survey/ui/custom/RatingAbstractView;)V", "view", "Landroid/view/View;", "getView", "()Landroid/view/View;", "getPositionAt", "", "x", "", "y", "getVirtualViews", "", "onClickActionForPosition", "", "position", "populateNodeForVirtualView", "info", "Landroidx/core/view/accessibility/AccessibilityNodeInfoCompat;", "getDescriptionForPosition", "", "Landroid/content/res/Resources;", "label", "instabug-survey_defaultUiRelease"})
public final class RatingVirtualViewsProvider
implements VirtualViewsInfoProvider {
    @NotNull
    private final RatingAbstractView ratingView;
    @NotNull
    private final View view;

    public RatingVirtualViewsProvider(@NotNull RatingAbstractView ratingAbstractView) {
        Intrinsics.checkNotNullParameter((Object)((Object)ratingAbstractView), (String)"ratingView");
        this.ratingView = ratingAbstractView;
        this.view = ratingAbstractView;
    }

    private final String getDescriptionForPosition(Resources resources, int n) {
        StringBuilder stringBuilder = new StringBuilder().append(n).append(' ').append(this.label(resources, n)).append(" of 5 ");
        boolean bl = (float)n <= this.ratingView.getRating();
        return stringBuilder.append(ResourcesUtils.getSelectedText((Resources)resources, (boolean)bl)).toString();
    }

    private final String label(Resources resources, int n) {
        String string2 = n == 1 ? resources.getString(R.string.ib_star) : resources.getString(R.string.ib_stars);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (position == 1)\n     \u2026String(R.string.ib_stars)");
        return string2;
    }

    @Override
    @NotNull
    public View getView() {
        return this.view;
    }

    @Override
    public int getPositionAt(float f, float f2) {
        return this.ratingView.childPositionAt(f, f2);
    }

    @Override
    @NotNull
    public List<Integer> getVirtualViews() {
        return CollectionsKt.toList((Iterable)new IntRange(1, 5));
    }

    @Override
    public void populateNodeForVirtualView(int n, @NotNull AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
        RatingVirtualViewsProvider ratingVirtualViewsProvider = this;
        Intrinsics.checkNotNullParameter((Object)accessibilityNodeInfoCompat, (String)"info");
        Resources resources = ratingVirtualViewsProvider.getView().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"view.resources");
        accessibilityNodeInfoCompat.setText((CharSequence)ratingVirtualViewsProvider.getDescriptionForPosition(resources, n));
        accessibilityNodeInfoCompat.setBoundsInParent(this.ratingView.childBoundsAtPosition(n));
    }

    @Override
    public void onClickActionForPosition(int n) {
        RatingVirtualViewsProvider ratingVirtualViewsProvider = this;
        ratingVirtualViewsProvider.ratingView.setRating(n, true);
        Resources resources = ratingVirtualViewsProvider.getView().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"view.resources");
        AccessibilityUtils.sendTextEvent((String)ratingVirtualViewsProvider.getDescriptionForPosition(resources, n));
    }
}

