/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.custom;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.R;
import com.instabug.survey.ui.custom.CustomExploreByTouchHelper;
import com.instabug.survey.ui.custom.NPSVirtualViewsProvider;
import java.util.ArrayList;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public abstract class NpsAbstractView
extends View {
    protected int width;
    protected int height;
    protected int count;
    protected int selected;
    protected int selectedNumber;
    private boolean onTouchUp;
    protected boolean isRtl;
    @Nullable
    private OnNpsSelectionListener onNpsSelectionListener;
    protected ArrayList<Rect> npsRects;
    @ColorInt
    protected int circlesRectColor;
    @ColorInt
    protected int borderColor;
    @ColorInt
    protected int indicatorViewBackgroundColor;
    @ColorInt
    protected int numbersColor;
    @ColorInt
    protected int indicatorViewTextColor;
    @ColorInt
    protected int indicatorViewCircleColor;
    @ColorInt
    protected int selectedViewEdgeSize;
    @ColorInt
    protected int rectLine;
    @ColorInt
    protected int heightWithPaddingBottom;
    @ColorInt
    protected int selectedRect;
    @NonNull
    protected Paint paintText;
    @NonNull
    protected Paint paintBorder;
    @NonNull
    protected Paint paintSelectionShape;
    @NonNull
    protected Paint paintSelectionShapeCircle;
    @NonNull
    protected Paint paintSelectionShapeText;
    @NonNull
    protected Path borderPath;
    @NonNull
    protected Path selectionPath;
    @NonNull
    protected Path scoreIndicatorPath;
    @NonNull
    protected CornerPathEffect cornerPathEffect;
    @NonNull
    protected CornerPathEffect rectCornerPathEffect;
    protected float numbersTextSize;
    protected float selectedNumbersTextSize;
    protected float rectCornerPathEffectRadius;

    public NpsAbstractView(Context context, @Nullable AttributeSet attributeSet) {
        ArrayList arrayList;
        NpsAbstractView npsAbstractView = object;
        super(context, attributeSet);
        npsAbstractView.count = 11;
        npsAbstractView.selected = -1;
        npsAbstractView.selectedNumber = -1;
        npsAbstractView.onTouchUp = false;
        npsAbstractView.isRtl = false;
        Object object = arrayList;
        arrayList = new ArrayList();
        npsAbstractView.npsRects = object;
        npsAbstractView.init(attributeSet);
    }

    public NpsAbstractView(Context context, @Nullable AttributeSet attributeSet, int n) {
        ArrayList arrayList;
        NpsAbstractView npsAbstractView = object;
        super(context, attributeSet, n);
        npsAbstractView.count = 11;
        npsAbstractView.selected = -1;
        npsAbstractView.selectedNumber = -1;
        npsAbstractView.onTouchUp = false;
        npsAbstractView.isRtl = false;
        Object object = arrayList;
        arrayList = new ArrayList();
        npsAbstractView.npsRects = object;
        npsAbstractView.init(attributeSet);
    }

    @TargetApi(value=21)
    public NpsAbstractView(Context context, @Nullable AttributeSet attributeSet, int n, int n2) {
        ArrayList arrayList;
        NpsAbstractView npsAbstractView = object;
        super(context, attributeSet, n, n2);
        npsAbstractView.count = 11;
        npsAbstractView.selected = -1;
        npsAbstractView.selectedNumber = -1;
        npsAbstractView.onTouchUp = false;
        npsAbstractView.isRtl = false;
        Object object = arrayList;
        arrayList = new ArrayList();
        npsAbstractView.npsRects = object;
        npsAbstractView.init(attributeSet);
    }

    public static float dpToPixel(Context context, float f) {
        return f * context.getResources().getDisplayMetrics().density;
    }

    public static float pixelToDp(Context context, float f) {
        return f / context.getResources().getDisplayMetrics().density;
    }

    private void drawBorder(Canvas canvas) {
        NpsAbstractView npsAbstractView = this;
        npsAbstractView.paintBorder.setStrokeWidth(NpsAbstractView.dpToPixel(this.getContext(), 2.0f));
        npsAbstractView.paintBorder.setStyle(Paint.Style.STROKE);
        npsAbstractView.paintBorder.setColor(this.getBorderColor());
        npsAbstractView.paintBorder.setPathEffect((PathEffect)this.rectCornerPathEffect);
        float f = npsAbstractView.selectedViewEdgeSize;
        float f2 = (float)Math.floor((double)npsAbstractView.heightWithPaddingBottom / 1.7);
        float f3 = npsAbstractView.getWidth() - this.selectedViewEdgeSize;
        float f4 = npsAbstractView.heightWithPaddingBottom;
        Paint paint = npsAbstractView.paintBorder;
        canvas.drawRect(f, f2, f3, f4, paint);
    }

    private void drawSelectionShape(Canvas canvas) {
        if (this.selected != -1) {
            this.selectionPath.reset();
            this.paintSelectionShape.setColor(this.getIndicatorViewBackgroundColor());
            this.paintSelectionShape.setPathEffect((PathEffect)this.cornerPathEffect);
            float f = this.npsRects.get((int)this.selected).left;
            float f2 = this.npsRects.get((int)this.selected).right;
            float f3 = this.npsRects.get((int)this.selected).top;
            int n = this.rectLine;
            int n2 = this.selectedRect;
            if (n > n2) {
                float f4 = f2;
                float f5 = f;
                f = (float)(n - n2) / 2.0f;
                f2 = f5 + f;
                f = f4 - f;
                float f6 = f2;
                f2 = f;
                f = f6;
            }
            int n3 = this.selectedViewEdgeSize;
            float f7 = f - (float)n3;
            float f8 = f2 + (float)n3;
            this.selectionPath.moveTo(f7, f3);
            this.selectionPath.lineTo(f7, (float)this.heightWithPaddingBottom / 1.7f);
            this.selectionPath.lineTo(f, (float)this.heightWithPaddingBottom / 1.7f + (float)this.selectedViewEdgeSize);
            this.selectionPath.lineTo(f, (float)this.heightWithPaddingBottom);
            this.selectionPath.lineTo(f2, (float)this.heightWithPaddingBottom);
            this.selectionPath.lineTo(f2, (float)this.heightWithPaddingBottom / 1.7f + (float)this.selectedViewEdgeSize);
            this.selectionPath.lineTo(f8, (float)this.heightWithPaddingBottom / 1.7f);
            this.selectionPath.lineTo(f8, 0.0f);
            this.selectionPath.close();
            canvas.drawPath(this.selectionPath, this.paintSelectionShape);
            this.paintSelectionShapeText.setColor(this.getIndicatorViewTextColor());
            this.paintSelectionShapeText.setTextAlign(Paint.Align.CENTER);
            this.paintSelectionShapeText.setTextSize(this.selectedNumbersTextSize);
            this.paintSelectionShapeText.setTypeface(Typeface.defaultFromStyle((int)1));
            String string2 = String.valueOf(this.selectedNumber);
            canvas.drawText(string2, f + (f2 - f) / 2.0f, (float)this.heightWithPaddingBottom / 1.7f / 1.5f, this.paintSelectionShapeText);
        }
    }

    private void onMoveEvent(float f, float f2) {
        this.onTouchUp = false;
        int n = this.selected;
        if (n != -1 && this.npsRects.get(n = (int)f).contains(n, (int)f2)) {
            return;
        }
        for (n = 0; n < this.count; ++n) {
            if (this.npsRects.size() <= n) continue;
            int n2 = (int)f;
            if (!this.npsRects.get(n).contains(n2, (int)f2)) continue;
            if (this.selected != n) {
                this.selectedNumber = this.isRtl ? 10 - n : n;
                this.selected = n;
                this.invalidate();
            }
            return;
        }
    }

    private void onActionUp() {
        this.onTouchUp = true;
        this.invalidate();
    }

    private void onSelection() {
        OnNpsSelectionListener onNpsSelectionListener = this.onNpsSelectionListener;
        if (onNpsSelectionListener != null) {
            onNpsSelectionListener.onScoreSelected(this.selectedNumber);
        }
    }

    public int getCirclesRectColor() {
        return this.circlesRectColor;
    }

    public void setCirclesRectColor(int n) {
        this.circlesRectColor = n;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(@ColorInt int n) {
        this.borderColor = n;
    }

    public int getIndicatorViewBackgroundColor() {
        return this.indicatorViewBackgroundColor;
    }

    public void setIndicatorViewBackgroundColor(@ColorInt int n) {
        this.indicatorViewBackgroundColor = n;
    }

    public int getNumbersColor() {
        return this.numbersColor;
    }

    public void setNumbersColor(@ColorInt int n) {
        this.numbersColor = n;
    }

    public int getIndicatorViewTextColor() {
        return this.indicatorViewTextColor;
    }

    public void setIndicatorViewTextColor(int n) {
        this.indicatorViewTextColor = n;
    }

    public int getIndicatorViewCircleColor() {
        return this.indicatorViewCircleColor;
    }

    public void setIndicatorViewCircleColor(int n) {
        this.indicatorViewCircleColor = n;
    }

    protected void init(@Nullable AttributeSet object) {
        CustomExploreByTouchHelper customExploreByTouchHelper;
        CornerPathEffect cornerPathEffect;
        CornerPathEffect cornerPathEffect2;
        TextPaint textPaint;
        Paint paint;
        Paint paint2;
        TextPaint textPaint2;
        Paint paint3;
        Path path;
        Path path2;
        Path path3;
        if (object == null) {
            return;
        }
        object = this.getContext().obtainStyledAttributes(object, R.styleable.NpsAbstractView);
        this.count = object.getInt(R.styleable.NpsAbstractView_nps_count, 11);
        this.numbersTextSize = object.getDimensionPixelSize(R.styleable.NpsAbstractView_nps_num_text_size, (int)NpsAbstractView.pixelToDp(this.getContext(), 40.0f));
        this.selectedViewEdgeSize = object.getDimensionPixelSize(R.styleable.NpsAbstractView_nps_selected_view_edge_size, (int)NpsAbstractView.pixelToDp(this.getContext(), 30.0f));
        this.selectedNumbersTextSize = object.getDimensionPixelSize(R.styleable.NpsAbstractView_nps_selected_num_text_size, (int)NpsAbstractView.pixelToDp(this.getContext(), 20.0f));
        this.selectedRect = object.getDimensionPixelSize(R.styleable.NpsAbstractView_nps_selected_rect_size, (int)NpsAbstractView.pixelToDp(this.getContext(), 100.0f));
        this.rectCornerPathEffectRadius = object.getDimensionPixelSize(R.styleable.NpsAbstractView_nps_rect_corners_radius, 2);
        if (this.count == 0) {
            this.count = 1;
        }
        this.setCirclesRectColor(AttrResolver.resolveAttributeColor((Context)this.getContext(), (int)R.attr.survey_nps_circles_container_background));
        this.setBorderColor(AttrResolver.resolveAttributeColor((Context)this.getContext(), (int)R.attr.survey_nps_circles_container_border_background));
        this.setNumbersColor(AttrResolver.resolveAttributeColor((Context)this.getContext(), (int)R.attr.survey_nps_numbers_color));
        if (!this.isInEditMode()) {
            this.setIndicatorViewBackgroundColor(InstabugCore.getPrimaryColor());
        }
        this.setIndicatorViewTextColor(-1);
        this.setIndicatorViewCircleColor(-1);
        object.recycle();
        object = path3;
        path3 = new Path();
        this.selectionPath = object;
        object = path2;
        path2 = new Path();
        this.scoreIndicatorPath = object;
        object = path;
        path = new Path();
        this.borderPath = object;
        object = paint3;
        paint3 = new Paint(1);
        this.paintBorder = object;
        object = textPaint2;
        textPaint2 = new TextPaint(1);
        this.paintText = object;
        object = paint2;
        paint2 = new Paint(1);
        this.paintSelectionShape = object;
        object = paint;
        paint = new Paint(1);
        this.paintSelectionShapeCircle = object;
        object = textPaint;
        textPaint = new TextPaint(1);
        this.paintSelectionShapeText = object;
        object = cornerPathEffect2;
        cornerPathEffect2 = new CornerPathEffect(NpsAbstractView.dpToPixel(this.getContext(), 4.0f));
        this.cornerPathEffect = object;
        object = cornerPathEffect;
        cornerPathEffect = new CornerPathEffect(this.rectCornerPathEffectRadius);
        this.rectCornerPathEffect = object;
        object = customExploreByTouchHelper;
        customExploreByTouchHelper = new CustomExploreByTouchHelper(new NPSVirtualViewsProvider(this));
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)object);
        this.setOnHoverListener((view, motionEvent) -> customExploreByTouchHelper.dispatchHoverEvent(motionEvent));
    }

    protected void onMeasure(int n, int n2) {
        int n3;
        super.onMeasure(n, n2);
        int n4 = View.MeasureSpec.getMode((int)n);
        int n5 = n2;
        n = View.MeasureSpec.getSize((int)n);
        n2 = View.MeasureSpec.getMode((int)n5);
        int n6 = View.MeasureSpec.getSize((int)n5);
        this.width = n4 == 0x40000000 ? n : (n4 == Integer.MIN_VALUE ? Math.min(500, n) : 500);
        this.height = n2 == 0x40000000 ? n6 : (n4 == Integer.MIN_VALUE ? Math.min(280, n6) : 280);
        NpsAbstractView npsAbstractView = this;
        float f = npsAbstractView.getContext().getResources().getConfiguration().fontScale;
        this.width = Math.abs(this.width);
        this.height = n3 = Math.abs(Math.round((float)npsAbstractView.height * f));
        npsAbstractView.heightWithPaddingBottom = n3 - 2;
        npsAbstractView.setMeasuredDimension(npsAbstractView.width, n3);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (Build.VERSION.SDK_INT >= 17) {
            boolean bl = this.getLayoutDirection() == 1;
            this.isRtl = bl;
        }
        NpsAbstractView npsAbstractView = this;
        this.calculateNpsRects();
        npsAbstractView.drawRectOfTheCircles(canvas);
        if (npsAbstractView.shouldHaveBorder()) {
            this.drawBorder(canvas);
        }
        NpsAbstractView npsAbstractView2 = this;
        npsAbstractView2.drawNumbers(canvas);
        if (npsAbstractView2.onTouchUp) {
            this.drawScoreIndicator(canvas);
        } else if (this.shouldDrawSelectionShape()) {
            this.drawSelectionShape(canvas);
        }
    }

    protected abstract void calculateNpsRects();

    protected abstract boolean shouldHaveBorder();

    protected abstract boolean shouldDrawSelectionShape();

    protected abstract void drawRectOfTheCircles(Canvas var1);

    protected abstract void drawNumbers(Canvas var1);

    protected abstract void drawScoreIndicator(Canvas var1);

    public boolean onTouchEvent(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        float f = motionEvent2.getX();
        float f2 = motionEvent2.getY();
        switch (motionEvent2.getActionMasked()) {
            default: {
                break;
            }
            case 2: {
                this.onMoveEvent(f, f2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                NpsAbstractView npsAbstractView = this;
                npsAbstractView.onActionUp();
                npsAbstractView.onSelection();
                break;
            }
            case 0: 
            case 5: {
                this.onMoveEvent(f, f2);
                InstabugSDKLogger.d((String)"IBG-Surveys", (String)("onTouchEvent: NPS view touch rect : " + this.selected));
            }
        }
        this.invalidate();
        return true;
    }

    public void setOnSelectionListener(@NonNull OnNpsSelectionListener onNpsSelectionListener) {
        this.onNpsSelectionListener = onNpsSelectionListener;
    }

    public int getScore() {
        return this.selected;
    }

    public void setScore(@IntRange(from=0L, to=11L) int n) {
        this.selected = n;
        this.selectedNumber = n;
        this.onTouchUp = true;
        this.postInvalidate();
    }

    public void setScore(@IntRange(from=0L, to=11L) int n, boolean bl) {
        this.setScore(n);
        if (bl) {
            this.onSelection();
        }
    }

    public int childPositionAt(float f, float f2) {
        for (int i = 0; i < this.npsRects.size(); ++i) {
            int n;
            Rect rect = this.npsRects.get(i);
            if (rect == null || !rect.contains(n = (int)f, (int)f2)) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    @Nullable
    public Rect childBoundsAtPosition(int n) {
        int n2;
        new Rect(this.npsRects.get(n)).top = n2 = (int)Math.floor((double)this.heightWithPaddingBottom / 1.7);
        return new Rect(this.npsRects.get(n));
    }

    public static interface OnNpsSelectionListener {
        public void onScoreSelected(int var1);
    }
}

