/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.settings;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;

public class PersistableSettings {
    @Nullable
    private static PersistableSettings persistableSettings;
    @Nullable
    private SharedPreferences sharedPreferences;
    @Nullable
    private SharedPreferences.Editor editor;

    @SuppressLint(value={"CommitPrefEdits"})
    private PersistableSettings(@NonNull Context context) {
        if (context == null) {
            return;
        }
        context = CoreServiceLocator.getInstabugSharedPreferences((Context)context, (String)"instabug_survey");
        this.sharedPreferences = context;
        if (context != null) {
            this.editor = context.edit();
        }
    }

    public static void init(@Nullable Context context) {
        if (context == null) {
            return;
        }
        persistableSettings = new PersistableSettings(context);
    }

    @Nullable
    public static PersistableSettings getInstance() {
        if (persistableSettings == null) {
            PersistableSettings.init(Instabug.getApplicationContext());
        }
        return persistableSettings;
    }

    public static void release() {
        persistableSettings = null;
    }

    public long getLastSurveyTime() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings != null) {
            return persistableSettings.getLong("last_survey_time", 0L);
        }
        return 0L;
    }

    public void setLastSurveyTime(long l) {
        SharedPreferences.Editor editor = this.editor;
        if (editor != null) {
            editor.putLong("last_survey_time", l);
            this.editor.apply();
        }
    }

    public long getLastFetchedAt() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings != null) {
            return persistableSettings.getLong("survey_last_fetch_time", 0L);
        }
        return 0L;
    }

    public void setLastFetchedAt(long l) {
        SharedPreferences.Editor editor = this.editor;
        if (editor != null) {
            editor.putLong("survey_last_fetch_time", l);
            this.editor.apply();
        }
    }

    @Nullable
    public String getCountryCode() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings != null) {
            return persistableSettings.getString("survey_resolve_country_code", null);
        }
        return null;
    }

    public void setCountryCode(String string2) {
        SharedPreferences.Editor editor = this.editor;
        if (editor != null) {
            editor.putString("survey_resolve_country_code", string2);
            this.editor.apply();
        }
    }

    public long getCountryCodeLastFetch() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings != null) {
            return persistableSettings.getLong("survey_resolve_country_code_last_fetch", 0L);
        }
        return 0L;
    }

    public void setCountryCodeLastFetch(long l) {
        SharedPreferences.Editor editor = this.editor;
        if (editor != null) {
            editor.putLong("survey_resolve_country_code_last_fetch", l);
            this.editor.apply();
        }
    }

    public boolean hasBeenMigrated() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings != null) {
            return persistableSettings.getBoolean("should_remove_old_survey_cache_file", false);
        }
        return false;
    }

    public void markSurveysFilesMigrated() {
        SharedPreferences.Editor editor = this.editor;
        if (editor != null) {
            editor.putBoolean("should_remove_old_survey_cache_file", true);
            this.editor.apply();
        }
    }
}

