/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.network.service;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugNetworkJob;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.cache.SurveysCacheManager;
import com.instabug.survey.common.models.ActionEvent;
import com.instabug.survey.common.models.SyncingStatus;
import com.instabug.survey.di.ServiceLocator;
import com.instabug.survey.models.Survey;
import com.instabug.survey.network.service.SurveysService;
import java.util.ArrayList;
import java.util.List;

public class InstabugSurveysSubmitterJob
extends InstabugNetworkJob {
    @Nullable
    private static InstabugSurveysSubmitterJob INSTANCE;

    private InstabugSurveysSubmitterJob() {
    }

    public static synchronized InstabugSurveysSubmitterJob getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugSurveysSubmitterJob();
        }
        return INSTANCE;
    }

    private static void submitSurveys(@NonNull Context object) {
        InstabugSDKLogger.d((String)"IBG-Surveys", (String)"submitSurveys started");
        Object object2 = SurveysCacheManager.getReadyToSendSurveys();
        InstabugSDKLogger.d((String)"IBG-Surveys", (String)("ready to send surveys size: " + object2.size()));
        if (ServiceLocator.getConfigurationsProvider().isSurveysUsageExceeded()) {
            object = object2.iterator();
            while (object.hasNext()) {
                InstabugSurveysSubmitterJob.markSurveyAsSynced((Survey)object.next());
            }
            SurveysCacheManager.updateBulk((List<Survey>)object2);
        } else {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                InstabugSurveysSubmitterJob.submitSurvey((Context)object, (Survey)object2.next());
            }
        }
    }

    private static void submitSurvey(@NonNull Context object, final @NonNull Survey survey) {
        Request.Callbacks<Boolean, Throwable> callbacks;
        Context context = object;
        object = callbacks;
        callbacks = new Request.Callbacks<Boolean, Throwable>(){

            public void onSucceeded(@Nullable Boolean bl) {
                1 v0 = this;
                InstabugSurveysSubmitterJob.markSurveyAsSynced(v0.survey);
                SurveysCacheManager.update(v0.survey);
            }

            public void onFailed(Throwable throwable) {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Submitting surveys got error: " + throwable.getMessage()));
            }
        };
        SurveysService.getInstance().submittingSurvey(context, survey, (Request.Callbacks<Boolean, Throwable>)object);
    }

    private static void markSurveyAsSynced(@NonNull Survey cacheable) {
        ArrayList<ActionEvent> arrayList;
        Survey survey = cacheable;
        survey.setSurveyState(SyncingStatus.SYNCED);
        survey.setSessionID(null);
        if (survey.isLastEventSubmit()) {
            cacheable.clearAnswers();
        }
        if (cacheable.getSurveyEvents() != null && !(arrayList = cacheable.getSurveyEvents()).isEmpty()) {
            Survey survey2 = cacheable;
            ArrayList<ActionEvent> arrayList2 = arrayList;
            cacheable = (ActionEvent)arrayList2.get(arrayList2.size() - 1);
            ((ActionEvent)cacheable).setSynced(true);
            survey2.getSurveyEvents().clear();
            survey2.getSurveyEvents().add((ActionEvent)cacheable);
        }
    }

    public void start() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (Instabug.getApplicationContext() != null) {
                    try {
                        InstabugSurveysSubmitterJob.submitSurveys(Instabug.getApplicationContext());
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Error " + exception.getMessage() + " occurred while submitting survey"), (Throwable)exception);
                    }
                } else {
                    InstabugSDKLogger.d((String)"IBG-Surveys", (String)"Context was null while submitting surveys");
                }
            }
        };
        this.enqueueJob("SURVEYS", runnable2);
    }
}

