/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.common.models;

import java.io.Serializable;
import org.json.JSONObject;

public class Frequency
implements Serializable {
    private int type;
    private int showingInterval;
    private int dismissedReshowInterval;

    public static Frequency getFromJson(String string2) {
        Frequency frequency = new Frequency();
        frequency.fromJson(string2);
        return frequency;
    }

    public void fromJson(String string2) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        if (new JSONObject(string2).has("frequency_type")) {
            this.setType(jSONObject2.getInt("frequency_type"));
        }
        this.setShowingInterval(jSONObject2.optInt("showing_surveys_interval", 30));
        this.setDismissedReshowInterval(jSONObject2.optInt("reshow_interval", -1));
    }

    public boolean shouldShowEveryTime() {
        return this.getType() == 2;
    }

    public boolean shouldShowOnce() {
        return this.getType() == 1;
    }

    public boolean shouldNotReshowAfterDismiss() {
        return this.getDismissedReshowInterval() == -1;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getShowingInterval() {
        if (this.showingInterval <= 0) {
            this.showingInterval = 30;
        }
        return this.showingInterval;
    }

    public void setShowingInterval(int n) {
        this.showingInterval = n;
    }

    public int getDismissedReshowInterval() {
        if (this.dismissedReshowInterval <= 0) {
            this.dismissedReshowInterval = -1;
        }
        return Math.min(this.dismissedReshowInterval, this.showingInterval);
    }

    public void setDismissedReshowInterval(int n) {
        this.dismissedReshowInterval = n;
    }

    public JSONObject toJson() {
        return new JSONObject().put("frequency_type", this.type).put("showing_surveys_interval", this.showingInterval).put("reshow_interval", this.dismissedReshowInterval);
    }
}

