/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.settings;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;

public class PersistableSettings {
    private static PersistableSettings persistableSettings;
    private SharedPreferences sharedPreferences;
    private SharedPreferences.Editor editor;

    @SuppressLint(value={"CommitPrefEdits"})
    private PersistableSettings(Context context) {
        context = CoreServiceLocator.getInstabugSharedPreferences((Context)context, (String)"instabug_announcements");
        this.sharedPreferences = context;
        if (context != null) {
            this.editor = context.edit();
        }
    }

    public static void init(@NonNull Context context) {
        persistableSettings = new PersistableSettings(context);
    }

    @Nullable
    public static PersistableSettings getInstance() {
        if (persistableSettings == null && Instabug.getApplicationContext() != null) {
            PersistableSettings.init(Instabug.getApplicationContext());
        }
        return persistableSettings;
    }

    public void setLastFetchedAt(long l) {
        SharedPreferences.Editor editor = this.editor;
        if (editor == null) {
            return;
        }
        editor.putLong("announcements_last_fetch_time", l);
        this.editor.apply();
    }

    public long getLastFetchedAt() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return 0L;
        }
        return persistableSettings.getLong("announcements_last_fetch_time", 0L);
    }

    public void setAppLatestVersion(String string) {
        SharedPreferences.Editor editor = this.editor;
        if (editor == null) {
            return;
        }
        editor.putString("announcements_app_latest_version", string);
        this.editor.apply();
    }

    public void setLastAnnouncementTime(long l) {
        SharedPreferences.Editor editor = this.editor;
        if (editor == null) {
            return;
        }
        editor.putLong("last_announcement_time", l);
        this.editor.apply();
    }

    @Nullable
    public String getCountryCode() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return null;
        }
        return persistableSettings.getString("survey_resolve_country_code", null);
    }

    public void setCountryCode(String string) {
        SharedPreferences.Editor editor = this.editor;
        if (editor == null) {
            return;
        }
        editor.putString("survey_resolve_country_code", string);
        this.editor.apply();
    }

    public void setCountryCodeLastFetch(long l) {
        SharedPreferences.Editor editor = this.editor;
        if (editor == null) {
            return;
        }
        editor.putLong("survey_resolve_country_code_last_fetch", l);
        this.editor.apply();
    }

    public void setAnnouncementLastRetrievedLocale(String string) {
        SharedPreferences.Editor editor = this.editor;
        if (editor == null) {
            return;
        }
        editor.putString("announcement_last_retrieved_locale", string);
        this.editor.apply();
    }
}

