/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements.network;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugNetworkJob;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.announcements.cache.AnnouncementCacheManager;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.network.AnnouncementsService;
import com.instabug.survey.common.models.SyncingStatus;
import com.instabug.survey.di.ServiceLocator;
import java.util.List;

public class InstabugAnnouncementSubmitterJob
extends InstabugNetworkJob {
    @Nullable
    private static InstabugAnnouncementSubmitterJob INSTANCE;

    private InstabugAnnouncementSubmitterJob() {
    }

    public static synchronized InstabugAnnouncementSubmitterJob getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugAnnouncementSubmitterJob();
        }
        return INSTANCE;
    }

    private static void submitAnnouncement(@NonNull Context context) {
        InstabugSDKLogger.d((String)"IBG-Surveys", (String)"submitAnnouncements started");
        Object object = AnnouncementCacheManager.getReadyToBeSend();
        InstabugSDKLogger.d((String)"IBG-Surveys", (String)("ready to send Announcements size: " + object.size()));
        if (ServiceLocator.getConfigurationsProvider().isSurveysUsageExceeded()) {
            InstabugAnnouncementSubmitterJob.markAnnouncementsAsSynced(object);
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Request.Callbacks<Boolean, Throwable> callbacks;
            final Announcement announcement = (Announcement)object.next();
            Request.Callbacks<Boolean, Throwable> callbacks2 = callbacks;
            callbacks = new Request.Callbacks<Boolean, Throwable>(){

                public void onSucceeded(@Nullable Boolean bl) {
                    1 v0 = this;
                    v0.announcement.setAnnouncementState(SyncingStatus.SYNCED);
                    v0.announcement.getAnnouncementEvents().clear();
                    AnnouncementCacheManager.updateAnnouncement(v0.announcement);
                }

                public void onFailed(Throwable throwable) {
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Submitting announcement got error: " + throwable.getMessage()));
                }
            };
            AnnouncementsService.getInstance().submittingAnnouncement(context, announcement, callbacks2);
        }
    }

    private static void markAnnouncementsAsSynced(@NonNull List<Announcement> list) {
        for (Announcement announcement : list) {
            announcement.setAnnouncementState(SyncingStatus.SYNCED);
            announcement.getAnnouncementEvents().clear();
        }
        AnnouncementCacheManager.updateBulk(list);
    }

    public void start() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (Instabug.getApplicationContext() != null) {
                    try {
                        InstabugAnnouncementSubmitterJob.submitAnnouncement(Instabug.getApplicationContext());
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Error " + exception.getMessage() + " occurred while submitting announcements"), (Throwable)exception);
                    }
                } else {
                    InstabugSDKLogger.d((String)"IBG-Surveys", (String)"Context was null while trying to submit announcements");
                }
            }
        };
        this.enqueueJob("ANNOUNCEMENTS", runnable2);
    }
}

