/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.announcements;

import android.app.ActivityManager;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.user.UserManagerWrapper;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.TimeUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.announcements.AnnouncementValidator;
import com.instabug.survey.announcements.cache.AnnouncementCacheManager;
import com.instabug.survey.announcements.cache.NewFeaturesAssetsHelper;
import com.instabug.survey.announcements.models.Announcement;
import com.instabug.survey.announcements.network.AnnouncementsService;
import com.instabug.survey.announcements.network.InstabugAnnouncementSubmitterJob;
import com.instabug.survey.announcements.settings.AnnouncementsSettings;
import com.instabug.survey.announcements.settings.PersistableSettings;
import com.instabug.survey.announcements.ui.activity.AnnouncementActivity;
import com.instabug.survey.common.AutoShowingManager;
import com.instabug.survey.common.models.UserInteraction;
import com.instabug.survey.common.userInteractions.UserInteractionCacheManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class AnnouncementManager {
    private static AnnouncementManager instance;
    private final Context applicationContext;
    @Nullable
    private AnnouncementValidator announcementValidator;
    @VisibleForTesting
    boolean hasTokenChanged;

    AnnouncementManager(Context context) {
        AnnouncementManager announcementManager = this;
        announcementManager.hasTokenChanged = false;
        announcementManager.applicationContext = context;
        announcementManager.syncReadyToBeSentAnnouncements();
    }

    @NonNull
    private AnnouncementValidator getAnnouncementValidator() {
        if (this.announcementValidator == null) {
            this.announcementValidator = new AnnouncementValidator(InstabugDeviceProperties.getAppVersionName((Context)this.applicationContext), DeviceStateProvider.getAppVersion((Context)this.applicationContext));
        }
        return this.announcementValidator;
    }

    public static void init(Context context) {
        instance = new AnnouncementManager(context);
    }

    public static AnnouncementManager getInstance(Context context) {
        if (instance == null) {
            AnnouncementManager.init(context);
        }
        return instance;
    }

    private void syncReadyToBeSentAnnouncements() {
        if (this.applicationContext != null) {
            PoolProvider.postIOTask(() -> {
                if (!AnnouncementCacheManager.getReadyToBeSend().isEmpty()) {
                    InstabugAnnouncementSubmitterJob.getInstance().start();
                }
            });
        } else {
            InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Couldn't sync announcements due to null context");
        }
    }

    public static boolean isAnnouncementFeatureAvailable() {
        return InstabugCore.isFeatureAvailable((String)"ANNOUNCEMENTS");
    }

    public static boolean isAnnouncementFeatureEnabled() {
        return InstabugCore.getFeatureState((String)"ANNOUNCEMENTS") == Feature.State.ENABLED;
    }

    private void onFetchingFailed(Throwable throwable) {
        InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Announcement Fetching Failed due to " + throwable.getMessage()));
        this.startAutomaticAnnouncementTrigger();
    }

    private void cacheLastRetrievedLocale() {
        AnnouncementManager announcementManager = announcementManager.applicationContext;
        if (announcementManager != null) {
            AnnouncementsSettings.setLastRetrievedLocale(LocaleUtils.getCurrentLocaleResolved((Context)announcementManager));
        }
    }

    @WorkerThread
    private void startAutomaticAnnouncementTrigger() {
        Object object = AnnouncementCacheManager.getAnnouncementsByType(101);
        List<Announcement> list = AnnouncementCacheManager.getAnnouncementsByType(100);
        if (object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                if (!((Announcement)object.next()).shouldShow()) continue;
                this.showFirstValidAnnouncement();
                return;
            }
        }
        if (list.size() > 0) {
            this.showFirstValidAnnouncement();
        }
    }

    @WorkerThread
    private void startAnnouncementActivity(Announcement announcement) {
        AnnouncementManager announcementManager = Instabug.getApplicationContext();
        if (announcementManager != null) {
            announcementManager = ((ActivityManager.RunningTaskInfo)((ActivityManager)announcementManager.getSystemService((String)"activity")).getRunningTasks((int)1).get((int)0)).topActivity;
            String string = "";
            if (announcementManager != null) {
                string = announcementManager.getClassName();
            }
            if (!AnnouncementActivity.class.getName().equals(string)) {
                AutoShowingManager.getInstance().showAnnouncement(announcement);
            } else {
                InstabugSDKLogger.d((String)"IBG-Surveys", (String)"An announcement is being displayed. Skip showing another one");
            }
        }
    }

    private boolean isFeaturesFetchedBefore() {
        return InstabugCore.isFeaturesFetchedBefore();
    }

    @WorkerThread
    private void mergeUserInteraction(List<Announcement> list) {
        ArrayList<Announcement> arrayList;
        String string = UserManagerWrapper.getUserUUID();
        ArrayList<Announcement> arrayList2 = arrayList;
        arrayList = new ArrayList<Announcement>();
        for (Announcement announcement : list) {
            UserInteraction userInteraction = UserInteractionCacheManager.retrieveUserInteraction(announcement.getId(), string, 1);
            if (userInteraction == null) continue;
            announcement.setUserInteraction(userInteraction);
            arrayList2.add(announcement);
        }
        if (!list.isEmpty()) {
            AnnouncementCacheManager.updateBulk(arrayList2);
        }
    }

    public void setHasTokenChanged(boolean bl) {
        this.hasTokenChanged = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startFetching(String object) {
        JSONException jSONException2;
        block5: {
            block4: {
                Request.Callbacks<JSONObject, Throwable> callbacks;
                String string;
                AnnouncementsService announcementsService;
                if (this.applicationContext == null) return;
                try {
                    if (!this.isFeaturesFetchedBefore()) return;
                    if (!AnnouncementManager.isAnnouncementFeatureEnabled()) return;
                    if (TimeUtils.currentTimeMillis() - AnnouncementsSettings.getInstance().getLastFetchedAt() <= 10000L) break block4;
                }
                catch (JSONException jSONException2) {
                    break block5;
                }
                {
                    announcementsService = AnnouncementsService.getInstance();
                    string = object;
                }
                object = callbacks;
                callbacks = new Request.Callbacks<JSONObject, Throwable>(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void onSucceeded(@Nullable JSONObject object) {
                        JSONException jSONException2;
                        block3: {
                            try {
                                AnnouncementsSettings.getInstance().setLastFetchedAt(TimeUtils.currentTimeMillis());
                                if (object != null) {
                                    object = Announcement.fromJson(object);
                                    AnnouncementManager.this.onFetchingSucceeded((List<Announcement>)object);
                                    return;
                                }
                            }
                            catch (JSONException jSONException2) {
                                break block3;
                            }
                            AnnouncementManager.this.onFetchingFailed(new NullPointerException("json response is null"));
                            return;
                        }
                        AnnouncementManager.this.onFetchingFailed(jSONException2);
                    }

                    public void onFailed(Throwable throwable) {
                        AnnouncementManager.this.onFetchingFailed(throwable);
                    }
                };
                announcementsService.fetchAnnouncements(string, (Request.Callbacks<JSONObject, Throwable>)object);
                return;
            }
            this.showFirstValidAnnouncement();
            return;
        }
        this.onFetchingFailed(jSONException2);
        InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Something went wrong while fetching announcements", (Throwable)jSONException2);
    }

    @VisibleForTesting
    void onFetchingSucceeded(List<Announcement> list) {
        InstabugSDKLogger.d((String)"IBG-Surveys", (String)"Announcement Fetching Succeeded");
        if (!Instabug.isEnabled()) {
            return;
        }
        AnnouncementManager announcementManager = this;
        announcementManager.cacheLastRetrievedLocale();
        announcementManager.setShowingIntervals(list);
        announcementManager.invalidateAnnouncementUserInteractions(list);
        announcementManager.invalidateCachedAnnouncements(list);
        announcementManager.migrateAnnouncements(list);
        announcementManager.startAutomaticAnnouncementTrigger();
        announcementManager.hasTokenChanged = false;
    }

    @WorkerThread
    @VisibleForTesting
    void migrateAnnouncements(List<Announcement> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Announcement announcement = (Announcement)object.next();
            if (announcement == null) continue;
            if (AnnouncementCacheManager.isAnnouncementExist(announcement.getId())) {
                Announcement announcement2 = announcement;
                Announcement announcement3 = AnnouncementCacheManager.getAnnouncement(announcement2.getId());
                boolean bl = this.isPublishStatusChanged(announcement2, announcement3);
                boolean bl2 = this.isLocaleChanged(announcement, announcement3);
                if (announcement.getAssetsStatus() == 0) {
                    NewFeaturesAssetsHelper.downloadAssets(announcement);
                }
                if (!bl && !bl2) continue;
                AnnouncementCacheManager.insertOrUpdatePausedOrLocale(announcement, bl, bl2);
                continue;
            }
            if (announcement.isPaused()) continue;
            Announcement announcement4 = announcement;
            NewFeaturesAssetsHelper.downloadAssets(announcement4);
            AnnouncementCacheManager.addAnnouncement(announcement4);
        }
    }

    @VisibleForTesting
    boolean isLocaleChanged(Announcement announcement, @Nullable Announcement announcement2) {
        if (announcement2 == null) {
            return false;
        }
        return announcement.getLocalization().getCurrentLocale() != null && !announcement.getLocalization().getCurrentLocale().equals(announcement2.getLocalization().getCurrentLocale());
    }

    @VisibleForTesting
    boolean isPublishStatusChanged(Announcement announcement, @Nullable Announcement announcement2) {
        if (announcement2 == null) {
            return false;
        }
        return announcement2.isPaused() != announcement.isPaused();
    }

    @WorkerThread
    @VisibleForTesting
    void invalidateAnnouncementUserInteractions(List<Announcement> list) {
        ArrayList<UserInteraction> arrayList;
        String string = UserManagerWrapper.getUserUUID();
        ArrayList<UserInteraction> arrayList2 = arrayList;
        arrayList = new ArrayList<UserInteraction>();
        for (Serializable serializable : AnnouncementCacheManager.getAllAnnouncement()) {
            if (list.contains(serializable) || (serializable = UserInteractionCacheManager.retrieveUserInteraction(serializable.getId(), string, 1)) == null) continue;
            arrayList2.add((UserInteraction)serializable);
        }
        if (!arrayList2.isEmpty()) {
            UserInteractionCacheManager.deleteBulkOfUserInteractions(arrayList2);
        }
    }

    @WorkerThread
    public void invalidateCachedAnnouncements(List<Announcement> list) {
        for (Announcement announcement : AnnouncementCacheManager.getAllAnnouncement()) {
            if (list.contains(announcement)) continue;
            AnnouncementCacheManager.deleteAnnouncement(String.valueOf(announcement.getId()));
        }
    }

    @VisibleForTesting
    void setShowingIntervals(List<Announcement> object) {
        Iterator<Announcement> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (Announcement)iterator.next();
            if (((Announcement)object).getType() == 101) {
                AnnouncementsSettings.getInstance().setUpdateMsgShowInterval(((Announcement)object).getTarget().getTrigger().getTriggerAfter());
                continue;
            }
            if (((Announcement)object).getType() != 100) continue;
            AnnouncementsSettings.getInstance().setWhatIsNewShowInterval(((Announcement)object).getTarget().getTrigger().getTriggerAfter());
        }
    }

    public void setAppLatestVersion() {
        if (PersistableSettings.getInstance() == null) {
            return;
        }
        PersistableSettings.getInstance().setAppLatestVersion(DeviceStateProvider.getAppVersion((Context)this.applicationContext));
    }

    @VisibleForTesting
    void showFirstValidAnnouncement() {
        if (!this.canShowAnnouncement()) {
            return;
        }
        Announcement announcement = this.getAnnouncementValidator().getFirstValidAnnouncement();
        if (announcement != null) {
            PoolProvider.postIOTask(() -> {
                block4: {
                    AnnouncementManager announcementManager = this;
                    Announcement announcement2 = announcement;
                    Announcement announcement3 = announcement2;
                    long l = announcement2.getTarget().getTrigger().getTriggerAfter();
                    try {
                        Thread.sleep(l * 1000L);
                        announcementManager.startAnnouncementActivity(announcement3);
                    }
                    catch (InterruptedException interruptedException) {
                        if (announcement.getType() == 101) {
                            InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Something went wrong while scheduling update msg announcement", (Throwable)interruptedException);
                            break block4;
                        }
                        if (announcement.getType() != 100) break block4;
                        InstabugSDKLogger.e((String)"IBG-Surveys", (String)"Something went wrong while scheduling what's new announcement", (Throwable)interruptedException);
                    }
                }
            });
        }
    }

    @VisibleForTesting
    boolean canShowAnnouncement() {
        return AnnouncementManager.isAnnouncementFeatureAvailable() && AnnouncementManager.isAnnouncementFeatureEnabled() && !this.hasTokenChanged;
    }

    public void notifyLogout() {
        UserManagerWrapper.getUUIDAsync(string -> {
            List<Announcement> list = AnnouncementCacheManager.getAllAnnouncement();
            if (!list.isEmpty()) {
                List<Announcement> list2 = list;
                UserInteractionCacheManager.insertUserInteractions(list2, string);
                AnnouncementCacheManager.resetAnnouncementUserInteraction(list2);
            }
        });
    }

    public void notifyUserLoggedIn() {
        PoolProvider.postIOTask(() -> {
            List<Announcement> list = AnnouncementCacheManager.getAllAnnouncement();
            if (!list.isEmpty()) {
                this.mergeUserInteraction(list);
            }
        });
    }

    public void notifyAppVersionChanged() {
        PoolProvider.postIOTask(() -> {
            this.announcementValidator = null;
            this.startAutomaticAnnouncementTrigger();
        });
    }
}

