package com.instabug.survey;

import com.google.android.play.core.review.ReviewInfo;

public interface InAppRatingCallback {
    /**
     * Called when the app is found live on GooglePlay console to return the reviewInfo
     *
     * @param reviewInfo required to start the in-app review flow
     */
    void onSuccess(ReviewInfo reviewInfo);

    /**
     * Called when the GooglePlay console request failed to find the app
     *
     * @param exception cause of the failure
     */
    void onFailure(Exception exception);
}
