/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.utils;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.settings.SurveysSettings;

public abstract class SurveysUtils {
    public static boolean isKnownTargetingCondition(@Nullable String string2) {
        if (string2 == null) {
            return false;
        }
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 2013274756: {
                if (!string2.equals("last_seen")) break;
                n = 9;
                break;
            }
            case 1905908461: {
                if (!string2.equals("sessions_count")) break;
                n = 8;
                break;
            }
            case 1694233633: {
                if (!string2.equals("app_version_v2")) break;
                n = 7;
                break;
            }
            case 1421955229: {
                if (!string2.equals("days_since_dismiss")) break;
                n = 6;
                break;
            }
            case 957831062: {
                if (!string2.equals("country")) break;
                n = 5;
                break;
            }
            case 96619420: {
                if (!string2.equals("email")) break;
                n = 4;
                break;
            }
            case 3076014: {
                if (!string2.equals("date")) break;
                n = 3;
                break;
            }
            case -12379384: {
                if (!string2.equals("android_version")) break;
                n = 2;
                break;
            }
            case -901870406: {
                if (!string2.equals("app_version")) break;
                n = 1;
                break;
            }
            case -1464712027: {
                if (!string2.equals("days_since_signup")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
        }
        return true;
    }

    public static boolean isSurveysFeatureAvailable() {
        return InstabugCore.isFeatureAvailable((String)"SURVEYS");
    }

    public static boolean isSurveysFeatureEnabled() {
        return InstabugCore.getFeatureState((String)"SURVEYS") == Feature.State.ENABLED;
    }

    public static void executeRunnableBeforeShowingSurvey() {
        try {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        if (SurveysSettings.getOnShowCallback() == null) break block3;
                        try {
                            SurveysSettings.getOnShowCallback().onShow();
                        }
                        catch (Exception exception) {
                            InstabugSDKLogger.e((String)"IBG-Surveys", (String)"AfterShowingSurveyRunnable has been failed to run.", (Throwable)exception);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)"IBG-Surveys", (String)"AfterShowingSurveyRunnable has been failed to run.", (Throwable)exception);
        }
    }

    public static void executeRunnableAfterShowingSurvey() {
        try {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        if (SurveysSettings.getOnDismissCallback() == null) break block3;
                        try {
                            SurveysSettings.getOnDismissCallback().onDismiss();
                        }
                        catch (Exception exception) {
                            InstabugSDKLogger.e((String)"IBG-Surveys", (String)"AfterShowingSurveyRunnable has been failed to run.", (Throwable)exception);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)"IBG-Surveys", (String)"AfterShowingSurveyRunnable has been failed to run.", (Throwable)exception);
        }
    }
}

