/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.google.android.gms.tasks.Task;
import com.google.android.play.core.review.ReviewInfo;
import com.google.android.play.core.review.ReviewManagerFactory;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.InAppRatingCallback;
import com.instabug.survey.InAppRatingRequestCallback;
import com.instabug.survey.settings.SurveysSettings;
import java.io.FileNotFoundException;

public abstract class PlayStoreUtils {
    public static void rateNow(Context context) {
        Uri uri = Uri.parse((String)("market://details?id=" + InstabugDeviceProperties.getPackageName((Context)context)));
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.addFlags(0x48080000);
        intent.addFlags(0x10000000);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Context context2 = context;
            Intent intent2 = new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + InstabugDeviceProperties.getPackageName((Context)context))));
            Intent intent3 = intent2;
            intent2.addFlags(0x10000000);
            try {
                context2.startActivity(intent3);
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Error: " + exception.getMessage() + " while rating app"));
            }
        }
    }

    public static void isLiveApp(Context object) {
        Request.Callbacks<RequestResponse, Throwable> callbacks;
        if (SurveysSettings.isAppStoreRatingEnabled() != null) {
            return;
        }
        object = "https://play.google.com/store/apps/details?id=" + InstabugDeviceProperties.getPackageName((Context)object);
        object = new Request.Builder().method("GET").url((String)object).disableDefaultParameters(true).build();
        Request.Callbacks<RequestResponse, Throwable> callbacks2 = callbacks;
        callbacks = new Request.Callbacks<RequestResponse, Throwable>(){

            public void onSucceeded(RequestResponse requestResponse) {
                InstabugSDKLogger.v((String)PlayStoreUtils.class.getSimpleName(), (String)("checkingIsLiveApp succeeded, Response code: " + requestResponse.getResponseCode()));
                SurveysSettings.setIsLiveAppRequestedTrue();
                SurveysSettings.setIsAppLive(requestResponse.getResponseCode() == 200);
            }

            public void onFailed(Throwable throwable) {
                if (throwable instanceof FileNotFoundException) {
                    InstabugSDKLogger.w((String)"IBG-Surveys", (String)"Couldn't find this app on playstore");
                } else {
                    InstabugSDKLogger.w((String)"IBG-Surveys", (String)("checkingIsLiveApp got error: " + throwable.toString()));
                }
                SurveysSettings.setIsAppLive(false);
                SurveysSettings.setIsLiveAppRequestedTrue();
            }
        };
        new NetworkManager().doRequest("SURVEYS", 1, (Request)object, (Request.Callbacks)callbacks2);
    }

    public static void requestInAppRating(Activity activity, ReviewInfo reviewInfo, InAppRatingRequestCallback inAppRatingRequestCallback) {
        Task task = ReviewManagerFactory.create((Context)activity).launchReviewFlow(activity, reviewInfo);
        Task task2 = task;
        InAppRatingRequestCallback inAppRatingRequestCallback2 = inAppRatingRequestCallback;
        InAppRatingRequestCallback inAppRatingRequestCallback3 = inAppRatingRequestCallback;
        task2.addOnCompleteListener(inAppRatingRequestCallback3::onComplete);
        try {
            task.addOnFailureListener(exception -> {
                Exception exception2;
                InAppRatingRequestCallback inAppRatingRequestCallback = inAppRatingRequestCallback2;
                inAppRatingRequestCallback2 = exception2;
                exception2 = new Exception("GooglePlay in-app review flow request failed", exception);
                inAppRatingRequestCallback.onFailure((Exception)((Object)inAppRatingRequestCallback2));
            });
        }
        catch (Exception exception2) {
            InstabugSDKLogger.e((String)"IBG-Surveys", (String)("GooglePlay in-app review request failed due to error: " + exception2.getMessage()));
        }
    }

    public static void prepareInAppRating(Activity activity, InAppRatingCallback inAppRatingCallback) {
        try {
            ReviewManagerFactory.create((Context)activity).requestReviewFlow().addOnCompleteListener(task -> {
                Exception exception2;
                block3: {
                    try {
                        if (task.isSuccessful()) {
                            inAppRatingCallback.onSuccess((ReviewInfo)task.getResult());
                            return;
                        }
                    }
                    catch (Exception exception2) {
                        break block3;
                    }
                    inAppRatingCallback.onFailure(new Exception("GooglePlay in-app review task did not succeed, result: " + task.getResult()));
                    return;
                }
                InstabugSDKLogger.e((String)"IBG-Surveys", (String)("Couldn't get GooglePlay in-app review request result" + exception2.getMessage()));
            }).addOnFailureListener(exception -> {
                Exception exception2;
                InAppRatingCallback inAppRatingCallback = inAppRatingCallback;
                inAppRatingCallback = exception2;
                exception2 = new Exception("GooglePlay in-app review request failed", exception);
                inAppRatingCallback.onFailure((Exception)((Object)inAppRatingCallback));
            });
        }
        catch (Exception exception2) {
            InstabugSDKLogger.e((String)"IBG-Surveys", (String)("GooglePlay in-app review request failed due to error: " + exception2.getMessage()));
        }
    }
}

