/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey.welcomepage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.survey.R;
import com.instabug.survey.models.Survey;
import com.instabug.survey.ui.SurveyNavigator;
import com.instabug.survey.ui.survey.welcomepage.WelcomeFragment;
import com.instabug.survey.ui.survey.welcomepage.WelcomeFragmentContract$View;
import com.instabug.survey.ui.survey.welcomepage.WelcomeFragmentPresenter;
import com.instabug.survey.utils.TextSizeCalculator;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public abstract class WelcomeAbstractFragment
extends InstabugBaseFragment<WelcomeFragmentPresenter>
implements WelcomeFragmentContract$View,
View.OnClickListener {
    @Nullable
    private Button takeSurvey;
    @Nullable
    protected Survey survey;
    @Nullable
    protected TextView title;
    @Nullable
    private TextView subtitle;

    public static WelcomeAbstractFragment newInstance(Survey survey) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putSerializable("survey", (Serializable)survey);
        WelcomeFragment welcomeFragment = new WelcomeFragment();
        welcomeFragment.setArguments(bundle2);
        return welcomeFragment;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void addCustomPlaceHolders() {
        TextView textView = this.title;
        if (textView != null) {
            textView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.SURVEYS_WELCOME_SCREEN_TITLE, (String)this.getLocalizedString(R.string.instabug_survey_welcome_feedback)));
        }
        if ((textView = this.subtitle) != null) {
            textView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.SURVEYS_WELCOME_SCREEN_SUBTITLE, (String)this.getLocalizedString(R.string.instabug_survey_welcome_feedback_msg)));
        }
        if ((textView = this.takeSurvey) != null) {
            textView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.SURVEYS_WELCOME_SCREEN_BUTTON, (String)this.getLocalizedString(R.string.instabug_survey_welcome_button)));
        }
    }

    public void onCreate(@Nullable Bundle object) {
        WelcomeFragmentPresenter welcomeFragmentPresenter;
        WelcomeAbstractFragment welcomeAbstractFragment = this;
        super.onCreate(object);
        if (welcomeAbstractFragment.getArguments() != null) {
            this.survey = (Survey)this.getArguments().getSerializable("survey");
        }
        object = welcomeFragmentPresenter;
        welcomeFragmentPresenter = new WelcomeFragmentPresenter(this);
        this.presenter = object;
    }

    protected int getLayout() {
        return R.layout.instabug_survey_fragment_welcome_dialog;
    }

    @CallSuper
    protected void initViews(View view, @Nullable Bundle bundle) {
        WelcomeAbstractFragment welcomeAbstractFragment = this;
        view = (Button)welcomeAbstractFragment.findViewById(R.id.ib_welcome_survey_take_survey);
        welcomeAbstractFragment.takeSurvey = view;
        welcomeAbstractFragment.title = (TextView)welcomeAbstractFragment.findViewById(R.id.ib_welcome_survey_title);
        welcomeAbstractFragment.subtitle = (TextView)welcomeAbstractFragment.findViewById(R.id.ib_welcome_survey_text);
        if (welcomeAbstractFragment.getContext() == null) {
            return;
        }
        if (view != null) {
            view.setOnClickListener((View.OnClickListener)this);
            view.setTextColor(ContextCompat.getColor((Context)this.requireContext(), (int)17170443));
            DrawableUtils.setColor((View)view, (int)this.getTakeSurveyButtonColor());
        }
        this.addCustomPlaceHolders();
    }

    protected abstract int getTakeSurveyButtonColor();

    public void onViewCreated(@NotNull View view, @Nullable Bundle bundle) {
        WelcomeAbstractFragment welcomeAbstractFragment = welcomeAbstractFragment2;
        super.onViewCreated(view, bundle);
        WelcomeAbstractFragment welcomeAbstractFragment2 = welcomeAbstractFragment.presenter;
        if (welcomeAbstractFragment2 != null) {
            ((WelcomeFragmentPresenter)((Object)welcomeAbstractFragment2)).handlePoweredByFooter();
        }
    }

    @Override
    public void handlePoweredByFooter() {
        View view;
        if (this.getActivity() != null && (view = this.rootView) != null) {
            InstabugCore.handlePbiFooter((View)view);
            InstabugCore.handlePbiFooterThemeColor((View)this.rootView, (int)R.color.pbi_footer_color_dark, (int)R.color.pbi_footer_color_light);
            return;
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.ib_welcome_survey_take_survey) {
            this.handleTakeSurveyButtonClicked();
        }
    }

    public void handleTakeSurveyButtonClicked() {
        if (this.getActivity() == null) {
            return;
        }
        Survey survey = this.survey;
        if (survey == null) {
            return;
        }
        if (this.getActivity().getSupportFragmentManager() == null) {
            return;
        }
        Fragment fragment = this.getActivity().getSupportFragmentManager().findFragmentById(R.id.instabug_fragment_container);
        if (fragment != null) {
            this.getActivity().getSupportFragmentManager().beginTransaction().setCustomAnimations(0, 0).remove(fragment).commit();
        }
        SurveyNavigator.navigateToSurveyFromWelcomeScreen(this.getActivity().getSupportFragmentManager(), survey);
    }

    public void onResume() {
        WelcomeAbstractFragment welcomeAbstractFragment = welcomeAbstractFragment2;
        super.onResume();
        WelcomeAbstractFragment welcomeAbstractFragment2 = welcomeAbstractFragment.title;
        if (welcomeAbstractFragment2 != null) {
            TextSizeCalculator.resize((TextView)welcomeAbstractFragment2);
        }
    }
}

