/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey.nps;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.ui.custom.NpsAbstractView;
import com.instabug.survey.ui.custom.NpsView;
import com.instabug.survey.ui.survey.QuestionAbstractFragment;
import com.instabug.survey.ui.survey.QuestionFragment;
import com.instabug.survey.ui.survey.SurveyFragmentCallbacks;
import com.instabug.survey.ui.survey.nps.NPSQuestionFragment;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public abstract class NPSAbstractQuestionFragment
extends QuestionFragment
implements NpsAbstractView.OnNpsSelectionListener {
    @Nullable
    protected NpsView npsLayout;

    public static NPSQuestionFragment newInstance(boolean bl, Question question, SurveyFragmentCallbacks surveyFragmentCallbacks) {
        Bundle bundle;
        NPSQuestionFragment nPSQuestionFragment = new NPSQuestionFragment();
        Bundle bundle2 = bundle;
        new Bundle().putBoolean("should_change_container_height", bl);
        bundle2.putSerializable("question", (Serializable)question);
        nPSQuestionFragment.setArguments(bundle2);
        nPSQuestionFragment.setSurveyFragmentCallbacks(surveyFragmentCallbacks);
        return nPSQuestionFragment;
    }

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        NPSAbstractQuestionFragment nPSAbstractQuestionFragment = this;
        super.onCreate(bundle);
        nPSAbstractQuestionFragment.setRetainInstance(true);
        if (nPSAbstractQuestionFragment.getArguments() != null) {
            this.question = (Question)this.getArguments().getSerializable("question");
        }
    }

    protected int getLayout() {
        return R.layout.instabug_dialog_nps_survey;
    }

    @Override
    @CallSuper
    protected void initViews(View object, @Nullable Bundle bundle) {
        super.initViews((View)object, bundle);
        this.npsLayout = (NpsView)object.findViewById(R.id.instabug_survey_nps_layout);
        if (AccessibilityUtils.isTalkbackEnabled() && (object = this.questionTextView) != null && object.getContentDescription() != null) {
            object = this.questionTextView.getContentDescription() + " " + this.getString(R.string.ibg_surveys_nps_less_likely_content_description) + ". " + this.getString(R.string.ibg_surveys_nps_very_likely_content_description);
            bundle = this.questionTextView;
            if (bundle != null) {
                bundle.setContentDescription((CharSequence)object);
            }
        }
        if ((object = this.npsLayout) != null) {
            object.setOnSelectionListener(this);
        }
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle bundle) {
        NPSAbstractQuestionFragment nPSAbstractQuestionFragment = this;
        super.onViewCreated(view, bundle);
        nPSAbstractQuestionFragment.showNPSQuestion(nPSAbstractQuestionFragment.question);
    }

    void showNPSQuestion(@Nullable Question question) {
        if (question == null) {
            return;
        }
        if (this.questionTextView != null && question.getTitle() != null) {
            this.questionTextView.setText((CharSequence)this.getQuestionTitle(question.getTitle()));
        }
        if (this.npsLayout != null && question.getAnswer() != null && question.getAnswer().length() > 0) {
            this.npsLayout.setScore(Integer.parseInt(question.getAnswer()));
        }
    }

    protected String getQuestionTitle(String string2) {
        return string2;
    }

    @Override
    @Nullable
    public String getAnswer() {
        Question question = ((QuestionAbstractFragment)((Object)question)).question;
        if (question == null) {
            return null;
        }
        return question.getAnswer();
    }

    @Override
    public void onScoreSelected(int n) {
        Question question = this.question;
        if (question == null) {
            return;
        }
        question.setAnswer(String.valueOf(n));
        SurveyFragmentCallbacks surveyFragmentCallbacks = this.surveyFragmentCallbacks;
        if (surveyFragmentCallbacks != null) {
            surveyFragmentCallbacks.onAnswerNPSQuestion(this.question);
        }
    }
}

