/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey.mcq;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.ui.survey.QuestionFragment;
import com.instabug.survey.ui.survey.SurveyFragmentCallbacks;
import com.instabug.survey.ui.survey.mcq.MCQQuestionFragment;
import com.instabug.survey.ui.survey.mcq.SurveyMCQGridAbstractAdapter;
import com.instabug.survey.ui.survey.mcq.SurveyMCQGridAdapter;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public abstract class MCQQuestionAbstractFragment
extends QuestionFragment
implements SurveyMCQGridAbstractAdapter.AnswerOnClickListener {
    @VisibleForTesting
    @Nullable
    protected SurveyMCQGridAbstractAdapter surveyMCQGridAdapter;
    @Nullable
    protected GridView optionalAnswersGridView;

    public static MCQQuestionAbstractFragment newInstance(boolean bl, Question question, SurveyFragmentCallbacks surveyFragmentCallbacks) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putSerializable("question", (Serializable)question);
        bundle2.putBoolean("should_change_container_height", bl);
        MCQQuestionFragment mCQQuestionFragment = new MCQQuestionFragment();
        mCQQuestionFragment.setArguments(bundle2);
        mCQQuestionFragment.setSurveyFragmentCallbacks(surveyFragmentCallbacks);
        return mCQQuestionFragment;
    }

    protected int getLayout() {
        return R.layout.instabug_dialog_mcq_survey;
    }

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        MCQQuestionAbstractFragment mCQQuestionAbstractFragment = this;
        super.onCreate(bundle);
        mCQQuestionAbstractFragment.setRetainInstance(true);
        if (mCQQuestionAbstractFragment.getArguments() != null) {
            this.question = (Question)this.getArguments().getSerializable("question");
        }
    }

    @Override
    @CallSuper
    protected void initViews(View view, @Nullable Bundle bundle) {
        super.initViews(view, bundle);
        this.questionTextView = (TextView)view.findViewById(R.id.instabug_text_view_question);
        this.optionalAnswersGridView = (GridView)view.findViewById(R.id.instabug_survey_mcq_grid_view);
        this.handleTextViewMaxLines();
    }

    public void onViewCreated(@NotNull View object, @Nullable Bundle bundle) {
        super.onViewCreated(object, bundle);
        object.setFocusableInTouchMode(true);
        object = this.question;
        if (object != null) {
            this.showMcqQuestion((Question)object);
        }
    }

    public void showMcqQuestion(Question question) {
        if (question != null && this.getActivity() != null && this.questionTextView != null) {
            SurveyMCQGridAdapter surveyMCQGridAdapter;
            if (question.getTitle() != null) {
                this.questionTextView.setText((CharSequence)question.getTitle());
            }
            SurveyMCQGridAdapter surveyMCQGridAdapter2 = surveyMCQGridAdapter;
            this.surveyMCQGridAdapter = new SurveyMCQGridAdapter((Activity)this.getActivity(), question, this);
            GridView gridView = this.optionalAnswersGridView;
            if (gridView != null) {
                gridView.setAdapter((ListAdapter)surveyMCQGridAdapter2);
            }
            this.surveyMCQGridAdapter.setAnswer(question.getAnswer());
            return;
        }
    }

    @Override
    @Nullable
    public String getAnswer() {
        SurveyMCQGridAbstractAdapter surveyMCQGridAbstractAdapter = this.surveyMCQGridAdapter;
        if (surveyMCQGridAbstractAdapter != null && surveyMCQGridAbstractAdapter.getCurrentAnswer() != null) {
            return this.surveyMCQGridAdapter.getCurrentAnswer();
        }
        if (this.getContext() != null) {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getLocalizedString(R.string.instabug_str_error_survey_without_answer), (int)0).show();
        }
        return null;
    }

    @Override
    public void onAnswerClicked(View object, String string2) {
        object = this.question;
        if (object == null) {
            return;
        }
        ((Question)object).setAnswer(string2);
        object = this.surveyFragmentCallbacks;
        if (object != null) {
            object.onAnswerMCQQuestion(this.question);
        }
    }
}

