/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.ui.custom.MaterialMenuDrawable;
import com.instabug.library.util.LocaleHelper;
import com.instabug.survey.R;
import com.instabug.survey.models.Survey;
import com.instabug.survey.ui.SurveysAnimations;
import com.instabug.survey.ui.survey.SurveyAbstractFragment;

public class SurveyFragment
extends SurveyAbstractFragment {
    @Nullable
    private ImageView backButton;
    @Nullable
    private ProgressBar surveyProgressStepBar;

    public static SurveyFragment newInstance(Survey survey, boolean bl) {
        survey = SurveyAbstractFragment.getFragmentArgs(survey, bl);
        SurveyFragment surveyFragment = new SurveyFragment();
        surveyFragment.setArguments((Bundle)survey);
        return surveyFragment;
    }

    private void inflateProgressBar() {
        ProgressBar progressBar;
        this.surveyProgressStepBar = progressBar = (ProgressBar)this.findViewById(R.id.survey_step_progressbar);
        if (progressBar == null) {
            return;
        }
        LayerDrawable layerDrawable = (LayerDrawable)progressBar.getProgressDrawable();
        if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
            layerDrawable.setDrawableByLayerId(0x1020000, this.getResources().getDrawable(R.drawable.ibg_survey_progressbar_background_light));
        } else {
            layerDrawable.setDrawableByLayerId(0x1020000, this.getResources().getDrawable(R.drawable.ibg_survey_progressbar_background_dark));
        }
        LayerDrawable layerDrawable2 = layerDrawable;
        layerDrawable2.getDrawable(1).setColorFilter(InstabugCore.getPrimaryColor(), PorterDuff.Mode.SRC_IN);
        progressBar.setProgressDrawable((Drawable)layerDrawable2);
    }

    private void inflateBackButton() {
        ImageView imageView;
        this.backButton = imageView = (ImageView)this.findViewById(R.id.instabug_ic_survey_close);
        if (imageView == null) {
            return;
        }
        if (this.getActivity() != null) {
            MaterialMenuDrawable materialMenuDrawable;
            ImageView imageView2 = imageView;
            ImageView imageView3 = imageView;
            ImageView imageView4 = imageView;
            imageView = materialMenuDrawable;
            imageView4.setImageDrawable(new MaterialMenuDrawable((Context)this.getActivity(), ContextCompat.getColor((Context)this.getActivity(), (int)17170443), MaterialMenuDrawable.Stroke.THIN).getCurrent());
            imageView3.setOnClickListener((View.OnClickListener)this);
            imageView3.setVisibility(4);
            imageView2.setContentDescription((CharSequence)this.getString(R.string.feature_request_go_back));
            if (LocaleHelper.isRTL((Context)this.getActivity())) {
                imageView.setRTLEnabled(true);
            }
            imageView.setIconState(MaterialMenuDrawable.IconState.ARROW);
        }
    }

    private void setBackButtonVisibility(int n) {
        ImageView imageView = this.backButton;
        if (imageView == null) {
            return;
        }
        if (n == 0 && imageView.getVisibility() != 0) {
            SurveysAnimations.appearAnimation(this.backButton);
        } else {
            SurveysAnimations.hideAnimation(this.backButton);
        }
    }

    @Override
    protected boolean shouldHandleKeyboardVisibility() {
        return true;
    }

    @Override
    protected void initViews(View view, @Nullable Bundle bundle) {
        SurveyFragment surveyFragment = this;
        super.initViews(view, bundle);
        surveyFragment.inflateBackButton();
        surveyFragment.inflateProgressBar();
    }

    @Override
    protected int getSubmitButtonColor() {
        return InstabugCore.getPrimaryColor();
    }

    @Override
    public void handleOnPageSelected(int n, Survey survey) {
        SurveyFragment surveyFragment = this;
        super.handleOnPageSelected(n, survey);
        ImageView imageView = surveyFragment.backButton;
        if (imageView == null) {
            return;
        }
        if (!survey.isNPSSurvey()) {
            if (this.isFirstQuestion()) {
                this.setBackButtonVisibility(4);
            } else if (this.isLastQuestion()) {
                imageView.setVisibility(0);
            } else {
                imageView.setVisibility(0);
            }
        } else if (survey.isNPSSurvey()) {
            if (this.isLastQuestion()) {
                this.setBackButtonVisibility(4);
            } else if (this.isFirstQuestion()) {
                imageView.setVisibility(4);
            } else {
                this.setBackButtonVisibility(0);
            }
        }
    }

    @Override
    @VisibleForTesting
    void setQuestionsIndicator(int n, int n2) {
        ProgressBar progressBar = this.surveyProgressStepBar;
        if (progressBar == null) {
            return;
        }
        progressBar.setMax(n2 * 100);
        ProgressBar progressBar2 = this.surveyProgressStepBar;
        int n3 = progressBar2.getProgress();
        n = (n + 1) * 100;
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = n3;
        nArray[1] = n;
        ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)progressBar2, (String)"progress", (int[])nArray2);
        objectAnimator.setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        objectAnimator.start();
    }

    @Override
    protected void hideBackButton() {
        this.setBackButtonVisibility(4);
    }

    @Override
    protected void showBackButton() {
        SurveyFragment surveyFragment = surveyFragment.backButton;
        if (surveyFragment != null) {
            surveyFragment.setVisibility(0);
        }
    }

    @Override
    protected void hideProgressbar(int n) {
        SurveyFragment surveyFragment = surveyFragment.surveyProgressStepBar;
        if (surveyFragment == null) {
            return;
        }
        surveyFragment.setVisibility(n);
    }
}

