/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.survey;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.survey.R;
import com.instabug.survey.models.Survey;
import com.instabug.survey.ui.SurveyActivity;
import com.instabug.survey.ui.ViewType;
import com.instabug.survey.ui.gestures.GestureListener;
import com.instabug.survey.ui.gestures.GesturesHandler;
import com.instabug.survey.ui.survey.QuestionAbstractFragment;
import com.instabug.survey.ui.survey.mcq.partial.PartialMCQQuestionFragment;
import com.instabug.survey.ui.survey.nps.partial.PartialNpsQuestionFragment;
import com.instabug.survey.ui.survey.rateus.RateUsFragment;
import com.instabug.survey.ui.survey.starrating.partial.PartialStarRatingQuestionFragment;
import com.instabug.survey.ui.survey.text.partial.PartialTextQuestionFragment;
import com.instabug.survey.utils.KeyboardUtils;

public abstract class QuestionFragment
extends QuestionAbstractFragment
implements View.OnTouchListener {
    @Nullable
    protected ImageView closeBtn;
    @Nullable
    private GestureDetector detector;

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void initViews(View view, @Nullable Bundle object) {
        QuestionFragment questionFragment = this;
        super.initViews(view, (Bundle)object);
        view = (ImageView)questionFragment.findViewById(R.id.survey_partial_close_btn);
        this.closeBtn = view;
        if (view != null && this.survey != null) {
            QuestionFragment questionFragment2 = this;
            questionFragment2.traversCloseBtnAfter(view.getRootView().getId());
            if (questionFragment2.survey.isDismissible()) {
                View view2 = view;
                view2.setVisibility(0);
                view2.setOnClickListener((View.OnClickListener)this);
            } else {
                view.setVisibility(8);
            }
        }
        if ((view = this.container) != null) {
            object = this.survey;
            if (object != null && ((Survey)object).isDismissible()) {
                view.setOnTouchListener((View.OnTouchListener)this);
            }
            view.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onResume() {
        QuestionFragment questionFragment = this;
        super.onResume();
        if (questionFragment.survey != null && this.getActivity() != null && this.getActivity() instanceof SurveyActivity) {
            if (this instanceof PartialTextQuestionFragment) {
                if (this.survey.isStoreRatingSurvey()) {
                    ((SurveyActivity)this.getActivity()).setLayoutHeightSecondary(ViewType.PRIMARY, true);
                } else {
                    ((SurveyActivity)this.getActivity()).setLayoutHeightSecondary(ViewType.PARTIAL, false);
                }
            }
            GesturesHandler.reset();
            return;
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.getActivity() == null) {
            return false;
        }
        QuestionFragment questionFragment = this;
        KeyboardUtils.hide((Activity)questionFragment.getActivity());
        GesturesHandler.handle(view, motionEvent, questionFragment.isPartial(), false, this);
        if (this.detector == null && this.getContext() != null) {
            GestureListener.GesturesCallback gesturesCallback;
            GestureListener gestureListener;
            GestureDetector gestureDetector;
            view = gestureDetector;
            Context context = this.getContext();
            GestureListener gestureListener2 = gestureListener;
            GestureListener.GesturesCallback gesturesCallback2 = gesturesCallback;
            gesturesCallback = new GestureListener.GesturesCallback(){

                @Override
                public void onSwipeRight() {
                }

                @Override
                public void onSwipeLeft() {
                }

                @Override
                public void onHardSwipeUp() {
                    QuestionFragment.this.onClick();
                }

                @Override
                public void onHardSwipeDown() {
                    QuestionFragment.this.close();
                }

                @Override
                public void onClick() {
                }
            };
            gestureListener = new GestureListener(gesturesCallback2);
            gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)gestureListener2);
            this.detector = view;
        }
        if ((this = this.detector) != null) {
            this.onTouchEvent(motionEvent);
        }
        return true;
    }

    public void onClick(View view) {
        if (this.survey == null) {
            return;
        }
        int n = view.getId();
        if (n == R.id.survey_partial_close_btn) {
            QuestionFragment questionFragment = this;
            questionFragment.handleCloseButtonClicked(questionFragment.survey);
        } else if (n == R.id.instabug_survey_dialog_container || n == R.id.instabug_text_view_question && this.getActivity() != null && ((SurveyActivity)this.getActivity()).getCurrentViewType() != ViewType.SECONDARY) {
            QuestionFragment questionFragment = this;
            questionFragment.handleOpenSurveyClicked(questionFragment.survey, false);
        }
    }

    protected void handleCloseButtonClicked(Survey survey) {
        if (this.getActivity() != null) {
            if (survey.isNPSSurvey() && this instanceof RateUsFragment) {
                ((SurveyActivity)this.getActivity()).submitSurvey(survey);
            } else {
                ((SurveyActivity)this.getActivity()).handleCloseClicked(survey);
            }
        }
    }

    protected void traversCloseBtnAfter(int n) {
        if (AccessibilityUtils.isTalkbackEnabled() && (this = this.closeBtn) != null) {
            if (Build.VERSION.SDK_INT >= 22) {
                this.setAccessibilityTraversalAfter(n);
            }
            return;
        }
    }

    @Override
    public boolean isPartial() {
        return this instanceof PartialTextQuestionFragment || this instanceof PartialMCQQuestionFragment || this instanceof PartialStarRatingQuestionFragment || this instanceof PartialNpsQuestionFragment;
    }
}

