/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.popup;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import com.instabug.survey.ui.SurveyActivityCallback;
import com.instabug.survey.ui.popup.PopupQuestionContract$View;
import com.instabug.survey.ui.popup.PopupQuestionPresenter;
import com.instabug.survey.utils.PlayStoreUtils;

public abstract class PopupAbstractQuestionFragment
extends InstabugBaseFragment<PopupQuestionPresenter>
implements PopupQuestionContract$View {
    @Nullable
    protected PopupQuestionPresenter presenter;
    private SurveyActivityCallback callback;

    public void onCreate(@Nullable Bundle bundle) {
        PopupAbstractQuestionFragment popupAbstractQuestionFragment = this;
        super.onCreate(bundle);
        popupAbstractQuestionFragment.setRetainInstance(true);
    }

    protected int getLayout() {
        return R.layout.instabug_dialog_popup_survey;
    }

    protected void initViews(View object, @Nullable Bundle object2) {
        object = null;
        if (this.getArguments() != null) {
            object = (Survey)this.getArguments().getSerializable("KEY_SURVEY_ARGUMENT");
        }
        if (object != null) {
            PopupQuestionPresenter popupQuestionPresenter;
            object2 = popupQuestionPresenter;
            object2(this, (Survey)object);
            this.presenter = object2;
            popupQuestionPresenter.showPrimaryQuestion();
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.callback = (SurveyActivityCallback)context;
            return;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Survey Activity must implement SurveyActivityCallback");
        }
    }

    @Override
    public void onBetaAppPrimaryQuestionAnswered(Survey survey) {
        this.callback.submitSurvey(survey);
    }

    @Override
    public void onPositiveSecondaryQuestionNegativeResponse(Survey survey) {
        this.callback.submitSurvey(survey);
    }

    @Override
    public void onPositiveSecondaryQuestionPositiveResponse(Survey survey) {
        if (this.getContext() == null) {
            return;
        }
        PopupAbstractQuestionFragment popupAbstractQuestionFragment = this;
        Instabug.willRedirectToStore();
        PlayStoreUtils.rateNow(popupAbstractQuestionFragment.getContext());
        popupAbstractQuestionFragment.callback.submitSurvey(survey);
    }

    @Override
    public void showNegativeSecondaryQuestion(Survey survey) {
        Question question = survey.getSecondaryNegativeQuestion();
        if (this.getFragmentManager() != null && question != null) {
            this.navigateToNegativeSecondaryQuestionFragment(survey, question);
            return;
        }
    }

    protected abstract void navigateToNegativeSecondaryQuestionFragment(Survey var1, Question var2);

    @Override
    public void dismissSurvey(Survey survey) {
        this.callback.dismissSurvey(survey);
    }

    @Override
    public void submitSurvey(Survey survey) {
        this.callback.submitSurvey(survey);
    }
}

