/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui.custom;

import android.content.res.Resources;
import android.view.View;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.ResourcesUtils;
import com.instabug.survey.ui.custom.NpsAbstractView;
import com.instabug.survey.ui.custom.VirtualViewsInfoProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/instabug/survey/ui/custom/NPSVirtualViewsProvider;", "Lcom/instabug/survey/ui/custom/VirtualViewsInfoProvider;", "npsView", "Lcom/instabug/survey/ui/custom/NpsAbstractView;", "(Lcom/instabug/survey/ui/custom/NpsAbstractView;)V", "view", "Landroid/view/View;", "getView", "()Landroid/view/View;", "getDescriptionForPosition", "", "position", "", "getPositionAt", "x", "", "y", "getVirtualViews", "", "onClickActionForPosition", "", "populateNodeForVirtualView", "info", "Landroidx/core/view/accessibility/AccessibilityNodeInfoCompat;", "instabug-survey_defaultUiRelease"})
public final class NPSVirtualViewsProvider
implements VirtualViewsInfoProvider {
    @NotNull
    private final NpsAbstractView npsView;
    @NotNull
    private final View view;

    public NPSVirtualViewsProvider(@NotNull NpsAbstractView npsAbstractView) {
        Intrinsics.checkNotNullParameter((Object)((Object)npsAbstractView), (String)"npsView");
        this.npsView = npsAbstractView;
        this.view = npsAbstractView;
    }

    private final String getDescriptionForPosition(int n) {
        NPSVirtualViewsProvider nPSVirtualViewsProvider = stringBuilder;
        StringBuilder stringBuilder = new StringBuilder().append(n).append(' ');
        Resources resources = nPSVirtualViewsProvider.npsView.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"npsView.resources");
        boolean bl = n == nPSVirtualViewsProvider.npsView.getScore();
        return stringBuilder.append(ResourcesUtils.getSelectedText((Resources)resources, (boolean)bl)).toString();
    }

    @Override
    @NotNull
    public View getView() {
        return this.view;
    }

    @Override
    public int getPositionAt(float f, float f2) {
        return this.npsView.childPositionAt(f, f2);
    }

    @Override
    @NotNull
    public List<Integer> getVirtualViews() {
        return CollectionsKt.toList((Iterable)new IntRange(0, 10));
    }

    @Override
    public void populateNodeForVirtualView(int n, @NotNull AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
        Intrinsics.checkNotNullParameter((Object)accessibilityNodeInfoCompat, (String)"info");
        accessibilityNodeInfoCompat.setText((CharSequence)this.getDescriptionForPosition(n));
        accessibilityNodeInfoCompat.setBoundsInParent(this.npsView.childBoundsAtPosition(n));
    }

    @Override
    public void onClickActionForPosition(int n) {
        this.npsView.setScore(n, true);
        AccessibilityUtils.sendTextEvent((String)this.getDescriptionForPosition(n));
    }
}

