/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.ui;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.R;
import com.instabug.survey.models.Survey;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.ui.popup.PopupCustomizedQuestionFragment;
import com.instabug.survey.ui.popup.PopupPublicQuestionFragment;
import com.instabug.survey.ui.survey.mcq.partial.PartialMCQQuestionFragment;
import com.instabug.survey.ui.survey.nps.partial.PartialNpsQuestionFragment;
import com.instabug.survey.ui.survey.starrating.partial.PartialStarRatingQuestionFragment;
import com.instabug.survey.ui.survey.text.partial.PartialTextQuestionFragment;

public abstract class SurveyNavigator {
    public static void navigateToSurvey(FragmentManager fragmentManager, Survey survey, int n, int n2) {
        if (survey.getQuestions().get(0).getType() == 0) {
            SurveyNavigator.showPartialQuestionFragment(fragmentManager, survey, n, n2);
        } else if (survey.getQuestions().get(0).getType() == 1) {
            SurveyNavigator.showPartialMCQFragment(fragmentManager, survey, n, n2);
        } else if (survey.getQuestions().get(0).getType() == 2) {
            SurveyNavigator.showPartialStarFragment(fragmentManager, survey, n, n2);
        } else if (survey.getQuestions().get(0).getType() == 3) {
            SurveyNavigator.showPartialNpsFragment(fragmentManager, survey, n, n2);
        } else if (survey.getQuestions().get(0).getType() == 5) {
            SurveyNavigator.showPopUpQuestionFragment(fragmentManager, survey, n, n2);
        }
    }

    public static void navigateToSurvey(FragmentManager fragmentManager, Survey survey) {
        int n = R.anim.instabug_anim_flyout_to_bottom;
        SurveyNavigator.navigateToSurvey(fragmentManager, survey, R.anim.instabug_anim_flyin_from_bottom, n);
    }

    public static void navigateToSurveyFromWelcomeScreen(FragmentManager fragmentManager, Survey survey) {
        SurveyNavigator.navigateToSurvey(fragmentManager, survey, 0, 0);
    }

    private static void showPartialNpsFragment(FragmentManager fragmentManager, Survey survey, int n, int n2) {
        SurveyNavigator.navigateToFragment(fragmentManager, (Fragment)PartialNpsQuestionFragment.newInstance(survey), n, n2);
    }

    private static void showPartialStarFragment(FragmentManager fragmentManager, Survey survey, int n, int n2) {
        SurveyNavigator.navigateToFragment(fragmentManager, (Fragment)PartialStarRatingQuestionFragment.newInstance(survey), n, n2);
    }

    private static void showPartialMCQFragment(FragmentManager fragmentManager, Survey survey, int n, int n2) {
        SurveyNavigator.navigateToFragment(fragmentManager, (Fragment)PartialMCQQuestionFragment.newInstance(survey), n, n2);
    }

    private static void showPartialQuestionFragment(FragmentManager fragmentManager, Survey survey, int n, int n2) {
        SurveyNavigator.navigateToFragment(fragmentManager, (Fragment)PartialTextQuestionFragment.newInstance(survey), n, n2);
    }

    private static void showPopUpQuestionFragment(FragmentManager fragmentManager, Survey object, int n, int n2) {
        object = SurveysSettings.isCustomizationEnabled() ? PopupCustomizedQuestionFragment.newInstance((Survey)object) : PopupPublicQuestionFragment.newInstance((Survey)object);
        SurveyNavigator.navigateToFragment(fragmentManager, (Fragment)object, n, n2);
    }

    public static void navigateToFragment(@Nullable FragmentManager fragmentManager, Fragment fragment, int n, int n2) {
        if (fragmentManager != null) {
            fragmentManager.beginTransaction().setCustomAnimations(n, n2).replace(R.id.instabug_fragment_container, fragment).commit();
        } else if (fragment != null) {
            InstabugSDKLogger.e((String)"IBG-Surveys", (String)("couldn't navigate to fragment " + fragment.getTag() + " fragmentManager is null"));
        }
    }
}

