/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.network;

import android.content.Context;
import androidx.annotation.Nullable;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.TimeUtils;
import com.instabug.survey.announcements.settings.AnnouncementsSettings;
import com.instabug.survey.models.CountryInfo;
import com.instabug.survey.network.service.SurveysService;
import com.instabug.survey.settings.SurveysSettings;
import org.json.JSONException;
import org.json.JSONObject;

public class CountryInfoResolver {
    private CountryInfoResolverCallback callback;

    public CountryInfoResolver(CountryInfoResolverCallback countryInfoResolverCallback) {
        this.callback = countryInfoResolverCallback;
    }

    public void resolveCountryCode(Context context) {
        SurveysService.getInstance().resolveCountryInfo(new Request.Callbacks<JSONObject, Throwable>(){

            public void onSucceeded(@Nullable JSONObject jSONObject) {
                if (jSONObject != null) {
                    CountryInfo countryInfo;
                    InstabugSDKLogger.d((String)"IBG-Surveys", (String)"resolveCountryCode succeed");
                    CountryInfo countryInfo2 = countryInfo;
                    countryInfo2();
                    try {
                        countryInfo.fromJson(jSONObject.toString());
                        CountryInfoResolver.this.callback.onSuccess(countryInfo2);
                        SurveysSettings.setCountryInfoLastFetch(TimeUtils.currentTimeMillis());
                        AnnouncementsSettings.setCountryInfoLastFetch(TimeUtils.currentTimeMillis());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        CountryInfoResolver.this.callback.onError(jSONException);
                    }
                } else {
                    InstabugSDKLogger.e((String)"IBG-Surveys", (String)"resolveCountryCode succeed: but response is null");
                }
            }

            public void onFailed(Throwable throwable) {
                CountryInfoResolver.this.callback.onError(throwable);
            }
        });
    }

    public static interface CountryInfoResolverCallback {
        public void onSuccess(CountryInfo var1);

        public void onError(Throwable var1);
    }
}

